/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.zarr;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.janelia.saalfeldlab.n5.Bzip2Compression;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.GzipCompression;
import org.janelia.saalfeldlab.n5.RawCompression;
import org.janelia.saalfeldlab.n5.blosc.BloscCompression;
import org.janelia.scicomp.n5.zstandard.ZstandardCompression;

public interface ZarrCompressor {
    public static final Map<String, Class<? extends ZarrCompressor>> registry = Stream.of(new AbstractMap.SimpleImmutableEntry<String, Class<Raw>>("raw", Raw.class), new AbstractMap.SimpleImmutableEntry<String, Class<Zstandard>>("zstd", Zstandard.class), new AbstractMap.SimpleImmutableEntry<String, Class<Blosc>>("blosc", Blosc.class), new AbstractMap.SimpleImmutableEntry<String, Class<Zlib>>("zlib", Zlib.class), new AbstractMap.SimpleImmutableEntry<String, Class<Gzip>>("gzip", Gzip.class), new AbstractMap.SimpleImmutableEntry<String, Class<Bz2>>("bz2", Bz2.class)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    public static final JsonAdapter jsonAdapter = new JsonAdapter();
    public static final TypeAdapter<Raw> rawNullAdapter = new TypeAdapter<Raw>(){

        public void write(JsonWriter out, Raw value) throws IOException {
            boolean serializeNull = out.getSerializeNulls();
            out.setSerializeNulls(true);
            out.nullValue();
            out.setSerializeNulls(serializeNull);
        }

        public Raw read(JsonReader in) {
            return new Raw();
        }
    };

    public static ZarrCompressor fromCompression(Compression compression) {
        try {
            if (compression instanceof BloscCompression) {
                return new Blosc((BloscCompression)compression);
            }
            if (compression instanceof GzipCompression) {
                Class<?> clazz = compression.getClass();
                Field field = clazz.getDeclaredField("useZlib");
                field.setAccessible(true);
                Boolean useZlib = (Boolean)field.get(compression);
                field.setAccessible(false);
                return useZlib != null && useZlib != false ? new Zlib((GzipCompression)compression) : new Gzip((GzipCompression)compression);
            }
            if (compression instanceof Bzip2Compression) {
                return new Bz2((Bzip2Compression)compression);
            }
            if (compression instanceof ZstandardCompression) {
                return new Zstandard((ZstandardCompression)compression);
            }
            return new Raw();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return null;
        }
    }

    public Compression getCompression();

    public static class JsonAdapter
    implements JsonDeserializer<ZarrCompressor> {
        public ZarrCompressor deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            JsonElement jsonId = jsonObject.get("id");
            if (jsonId == null) {
                return null;
            }
            String id = jsonId.getAsString();
            Class<? extends ZarrCompressor> compressorClass = registry.get(id);
            if (compressorClass == null) {
                return null;
            }
            return (ZarrCompressor)context.deserialize(json, compressorClass);
        }
    }

    public static class Raw
    implements ZarrCompressor {
        public RawCompression getCompression() {
            return new RawCompression();
        }
    }

    public static class Bz2
    implements ZarrCompressor {
        private final String id = "bz2";
        private final int level;

        public Bz2(int level) {
            this.level = level;
        }

        public Bz2(Bzip2Compression compression) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
            Class<?> clazz = compression.getClass();
            Field field = clazz.getDeclaredField("blockSize");
            field.setAccessible(true);
            this.level = field.getInt(compression);
            field.setAccessible(false);
        }

        public Bzip2Compression getCompression() {
            return new Bzip2Compression(this.level);
        }
    }

    public static class Gzip
    implements ZarrCompressor {
        private final String id = "gzip";
        private final int level;

        public Gzip(int level) {
            this.level = level;
        }

        public Gzip(GzipCompression compression) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
            Class<?> clazz = compression.getClass();
            Field field = clazz.getDeclaredField("level");
            field.setAccessible(true);
            this.level = field.getInt(compression);
            field.setAccessible(false);
        }

        public GzipCompression getCompression() {
            return new GzipCompression(this.level);
        }
    }

    public static class Zlib
    implements ZarrCompressor {
        private final String id = "zlib";
        private final int level;

        public Zlib(int level) {
            this.level = level;
        }

        public Zlib(GzipCompression compression) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
            Class<?> clazz = compression.getClass();
            Field field = clazz.getDeclaredField("level");
            field.setAccessible(true);
            this.level = field.getInt(compression);
            field.setAccessible(false);
        }

        public GzipCompression getCompression() {
            return new GzipCompression(this.level, true);
        }
    }

    public static class Blosc
    implements ZarrCompressor {
        private final String id = "blosc";
        private final String cname;
        private final int clevel;
        private final int shuffle;
        private final int blocksize;
        private final transient int nthreads;

        public Blosc(String cname, int clevel, int shuffle, int blockSize, int nthreads) {
            this.cname = cname;
            this.clevel = clevel;
            this.shuffle = shuffle;
            this.blocksize = blockSize;
            this.nthreads = nthreads;
        }

        public Blosc(BloscCompression compression) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
            Class<?> clazz = compression.getClass();
            Field field = clazz.getDeclaredField("cname");
            field.setAccessible(true);
            this.cname = (String)field.get(compression);
            field.setAccessible(false);
            field = clazz.getDeclaredField("clevel");
            field.setAccessible(true);
            this.clevel = field.getInt(compression);
            field.setAccessible(false);
            field = clazz.getDeclaredField("shuffle");
            field.setAccessible(true);
            this.shuffle = field.getInt(compression);
            field.setAccessible(false);
            field = clazz.getDeclaredField("blocksize");
            field.setAccessible(true);
            this.blocksize = field.getInt(compression);
            field.setAccessible(false);
            field = clazz.getDeclaredField("nthreads");
            field.setAccessible(true);
            this.nthreads = field.getInt(compression);
            field.setAccessible(false);
        }

        public BloscCompression getCompression() {
            return new BloscCompression(this.cname, this.clevel, this.shuffle, this.blocksize, Math.max(1, this.nthreads));
        }
    }

    public static class Zstandard
    implements ZarrCompressor {
        private final String id = "zstd";
        private final int level;
        private final transient int nbWorkers;

        public Zstandard(int level) {
            this(level, 0);
        }

        public Zstandard(int level, int nbWorkers) {
            this.level = level;
            this.nbWorkers = nbWorkers;
        }

        public Zstandard(ZstandardCompression compression) {
            this.level = compression.getLevel();
            this.nbWorkers = compression.getNbWorkers();
        }

        @Override
        public Compression getCompression() {
            ZstandardCompression compression = new ZstandardCompression(this.level);
            if (this.nbWorkers != 0) {
                compression.setNbWorkers(this.nbWorkers);
            }
            return compression;
        }
    }
}

