/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.geometry.compression;

import org.scijava.java3d.utils.geometry.compression.CommandStream;
import org.scijava.java3d.utils.geometry.compression.CompressionStream;
import org.scijava.java3d.utils.geometry.compression.CompressionStreamColor;
import org.scijava.java3d.utils.geometry.compression.CompressionStreamElement;
import org.scijava.java3d.utils.geometry.compression.CompressionStreamNormal;
import org.scijava.java3d.utils.geometry.compression.HuffmanNode;
import org.scijava.java3d.utils.geometry.compression.HuffmanTable;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Color4f;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Vector3f;

class CompressionStreamVertex
extends CompressionStreamElement {
    private int X;
    private int Y;
    private int Z;
    private int meshFlag;
    private int stripFlag;
    private float floatX;
    private float floatY;
    private float floatZ;
    int xAbsolute;
    int yAbsolute;
    int zAbsolute;
    CompressionStreamColor color = null;
    CompressionStreamNormal normal = null;

    CompressionStreamVertex(CompressionStream stream, Point3f p, Vector3f n, Color3f c, int stripFlag, int meshFlag) {
        this(stream, p, n, stripFlag, meshFlag);
        if (stream.vertexColor3) {
            this.color = new CompressionStreamColor(stream, c);
        }
    }

    CompressionStreamVertex(CompressionStream stream, Point3f p, Vector3f n, Color4f c, int stripFlag, int meshFlag) {
        this(stream, p, n, stripFlag, meshFlag);
        if (stream.vertexColor4) {
            this.color = new CompressionStreamColor(stream, c);
        }
    }

    CompressionStreamVertex(CompressionStream stream, Point3f p, Vector3f n, int stripFlag, int meshFlag) {
        this.stripFlag = stripFlag;
        this.meshFlag = meshFlag;
        this.floatX = p.x;
        this.floatY = p.y;
        this.floatZ = p.z;
        stream.byteCount += 12;
        ++stream.vertexCount;
        if ((double)p.x < stream.mcBounds[0].x) {
            stream.mcBounds[0].x = p.x;
        }
        if ((double)p.y < stream.mcBounds[0].y) {
            stream.mcBounds[0].y = p.y;
        }
        if ((double)p.z < stream.mcBounds[0].z) {
            stream.mcBounds[0].z = p.z;
        }
        if ((double)p.x > stream.mcBounds[1].x) {
            stream.mcBounds[1].x = p.x;
        }
        if ((double)p.y > stream.mcBounds[1].y) {
            stream.mcBounds[1].y = p.y;
        }
        if ((double)p.z > stream.mcBounds[1].z) {
            stream.mcBounds[1].z = p.z;
        }
        if (stream.vertexNormals) {
            this.normal = new CompressionStreamNormal(stream, n);
        }
    }

    @Override
    void quantize(CompressionStream stream, HuffmanTable huffmanTable) {
        int quant = stream.positionQuant < 1 ? 1 : (stream.positionQuant > 16 ? 16 : stream.positionQuant);
        this.absolute = false;
        if (stream.firstPosition || stream.positionQuantChanged) {
            this.absolute = true;
            stream.lastPosition[0] = 0;
            stream.lastPosition[1] = 0;
            stream.lastPosition[2] = 0;
            stream.firstPosition = false;
            stream.positionQuantChanged = false;
        }
        double px = ((double)this.floatX - stream.center[0]) * stream.scale;
        double py = ((double)this.floatY - stream.center[1]) * stream.scale;
        double pz = ((double)this.floatZ - stream.center[2]) * stream.scale;
        this.X = (int)(px * 32768.0);
        this.Y = (int)(py * 32768.0);
        this.Z = (int)(pz * 32768.0);
        this.X &= quantizationMask[quant];
        this.Y &= quantizationMask[quant];
        this.Z &= quantizationMask[quant];
        if (this.X < stream.qcBounds[0].x) {
            stream.qcBounds[0].x = this.X;
        }
        if (this.Y < stream.qcBounds[0].y) {
            stream.qcBounds[0].y = this.Y;
        }
        if (this.Z < stream.qcBounds[0].z) {
            stream.qcBounds[0].z = this.Z;
        }
        if (this.X > stream.qcBounds[1].x) {
            stream.qcBounds[1].x = this.X;
        }
        if (this.Y > stream.qcBounds[1].y) {
            stream.qcBounds[1].y = this.Y;
        }
        if (this.Z > stream.qcBounds[1].z) {
            stream.qcBounds[1].z = this.Z;
        }
        this.xAbsolute = this.X;
        this.yAbsolute = this.Y;
        this.zAbsolute = this.Z;
        this.X -= stream.lastPosition[0];
        this.Y -= stream.lastPosition[1];
        this.Z -= stream.lastPosition[2];
        stream.lastPosition[0] = stream.lastPosition[0] + this.X;
        stream.lastPosition[1] = stream.lastPosition[1] + this.Y;
        stream.lastPosition[2] = stream.lastPosition[2] + this.Z;
        this.X = this.X << 16 >> 16;
        this.Y = this.Y << 16 >> 16;
        this.Z = this.Z << 16 >> 16;
        this.computeLengthShift(this.X, this.Y, this.Z);
        if (this.length == 0) {
            this.length = 1;
        }
        huffmanTable.addPositionEntry(this.length, this.shift, this.absolute);
        if (this.color != null) {
            this.color.quantize(stream, huffmanTable);
        }
        if (this.normal != null) {
            this.normal.quantize(stream, huffmanTable);
        }
        if (this.meshFlag == 1) {
            stream.meshBuffer.push(this);
        }
    }

    @Override
    void outputCommand(HuffmanTable huffmanTable, CommandStream outputBuffer) {
        int command = 64;
        HuffmanNode t = huffmanTable.getPositionEntry(this.length, this.shift, this.absolute);
        int componentLength = t.dataLength - t.shift;
        int subcommandLength = t.tagLength + 3 * componentLength;
        this.X = this.X >> t.shift & (int)lengthMask[componentLength];
        this.Y = this.Y >> t.shift & (int)lengthMask[componentLength];
        this.Z = this.Z >> t.shift & (int)lengthMask[componentLength];
        long positionSubcommand = (long)t.tag << 3 * componentLength | (long)this.X << 2 * componentLength | (long)this.Y << 1 * componentLength | (long)this.Z << 0 * componentLength;
        if (subcommandLength < 6) {
            command |= (int)(positionSubcommand << 6 - subcommandLength);
            subcommandLength = 0;
        } else {
            command |= (int)(positionSubcommand >>> subcommandLength - 6);
            subcommandLength -= 6;
        }
        long body = (long)this.stripFlag << subcommandLength + 1 | (long)this.meshFlag << subcommandLength + 0 | positionSubcommand & lengthMask[subcommandLength];
        outputBuffer.addCommand(command, 8, body, subcommandLength + 3);
        if (this.normal != null) {
            this.normal.outputSubcommand(huffmanTable, outputBuffer);
        }
        if (this.color != null) {
            this.color.outputSubcommand(huffmanTable, outputBuffer);
        }
    }

    public String toString() {
        String d = this.absolute ? "" : "delta ";
        String c = this.color == null ? "" : "\n\n " + this.color.toString();
        String n = this.normal == null ? "" : "\n\n " + this.normal.toString();
        return "position: " + this.floatX + " " + this.floatY + " " + this.floatZ + "\n" + "fixed point " + d + this.X + " " + this.Y + " " + this.Z + "\n" + "length " + this.length + " shift " + this.shift + (this.absolute ? " absolute" : " relative") + "\n" + "strip flag " + this.stripFlag + " mesh flag " + this.meshFlag + c + n;
    }
}

