/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.scijava.java3d.BoundingLeaf;
import org.scijava.java3d.Fog;
import org.scijava.java3d.Group;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.SceneGraphObjectState;
import org.scijava.vecmath.Color3f;

public abstract class FogState
extends SceneGraphObjectState {
    protected int[] scopes;
    protected int boundingLeaf;

    public FogState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        this.control.writeBounds(out, ((Fog)this.node).getInfluencingBounds());
        out.writeInt(((Fog)this.node).numScopes());
        for (int i = 0; i < ((Fog)this.node).numScopes(); ++i) {
            out.writeInt(this.control.getSymbolTable().addReference(((Fog)this.node).getScope(i)));
        }
        out.writeInt(this.control.getSymbolTable().addReference(((Fog)this.node).getInfluencingBoundingLeaf()));
        Color3f clr = new Color3f();
        ((Fog)this.node).getColor(clr);
        this.control.writeColor3f(out, clr);
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        ((Fog)this.node).setInfluencingBounds(this.control.readBounds(in));
        this.scopes = new int[in.readInt()];
        for (int i = 0; i < this.scopes.length; ++i) {
            this.scopes[i] = in.readInt();
        }
        this.boundingLeaf = in.readInt();
        ((Fog)this.node).setColor(this.control.readColor3f(in));
    }

    @Override
    public void buildGraph() {
        for (int i = 0; i < this.scopes.length; ++i) {
            ((Fog)this.node).addScope((Group)this.control.getSymbolTable().getJ3dNode(this.scopes[i]));
        }
        ((Fog)this.node).setInfluencingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        super.buildGraph();
    }
}

