/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.TransformInterpolator;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.InterpolatorState;

public abstract class TransformInterpolatorState
extends InterpolatorState {
    private int target = 0;

    public TransformInterpolatorState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        TransformInterpolator ti = (TransformInterpolator)this.node;
        this.control.writeTransform3D(out, ti.getTransformAxis());
        out.writeInt(this.control.getSymbolTable().addReference(ti.getTarget()));
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        TransformInterpolator ti = (TransformInterpolator)this.node;
        ti.setTransformAxis(this.control.readTransform3D(in));
        this.target = in.readInt();
    }

    @Override
    public void buildGraph() {
        ((TransformInterpolator)this.node).setTarget((TransformGroup)this.control.getSymbolTable().getJ3dNode(this.target));
        super.buildGraph();
    }
}

