/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import java.util.Arrays;
import java.util.TreeSet;
import java.util.stream.IntStream;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealComponentMappingTransform;

public class RealInvertibleComponentMappingTransform
extends RealComponentMappingTransform
implements InvertibleRealTransform,
AffineGet {
    protected final int[] inverseComponent;
    protected final RealPoint dpt;

    public RealInvertibleComponentMappingTransform(int[] componentIn) {
        this(Arrays.stream(componentIn).max().getAsInt() + 1, componentIn);
    }

    public RealInvertibleComponentMappingTransform(int nd, int[] componentIn) {
        super(nd, RealInvertibleComponentMappingTransform.checkAndFillComponent(componentIn, nd));
        this.inverseComponent = new int[nd];
        for (int i = 0; i < nd; ++i) {
            this.inverseComponent[this.components[i]] = i;
        }
        this.dpt = new RealPoint(this.components.length);
    }

    private static int[] checkAndFillComponent(int[] component, int nd) {
        TreeSet<Integer> sortedIndexes = new TreeSet<Integer>();
        for (int i = 0; i < component.length; ++i) {
            sortedIndexes.add(component[i]);
        }
        int max = (Integer)sortedIndexes.last();
        if (max > nd - 1) {
            nd = max + 1;
        }
        if (component.length == nd) {
            return component;
        }
        return RealInvertibleComponentMappingTransform.buildNewComponent(component, sortedIndexes, nd);
    }

    private static int[] buildNewComponent(int[] component, TreeSet<Integer> sortedIndexes, int nd) {
        TreeSet missingIndexes = new TreeSet();
        IntStream.range(0, nd).forEach(i -> missingIndexes.add(i));
        missingIndexes.removeAll(sortedIndexes);
        int[] compOut = new int[nd];
        System.arraycopy(component, 0, compOut, 0, component.length);
        for (int i2 = component.length; i2 < nd; ++i2) {
            compOut[i2] = (Integer)missingIndexes.pollFirst();
        }
        return compOut;
    }

    public void applyInverse(double[] source, double[] target) {
        assert (source.length >= this.numTargetDimensions);
        assert (target.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            source[d] = target[this.inverseComponent[d]];
        }
    }

    public void applyInverse(RealPositionable source, RealLocalizable target) {
        assert (source.numDimensions() >= this.numTargetDimensions);
        assert (target.numDimensions() >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            source.setPosition(target.getDoublePosition(this.inverseComponent[d]), d);
        }
    }

    @Override
    public RealInvertibleComponentMappingTransform copy() {
        return new RealInvertibleComponentMappingTransform(this.components);
    }

    public RealInvertibleComponentMappingTransform inverse() {
        return new RealInvertibleComponentMappingTransform(this.inverseComponent);
    }

    public int numDimensions() {
        return this.components.length;
    }

    public double get(int row, int column) {
        return this.components[row] == column ? 1.0 : 0.0;
    }

    public double[] getRowPackedCopy() {
        int n = this.components.length;
        double[] mtx = new double[n * (n + 1)];
        for (int i = 0; i < n; ++i) {
            mtx[i + (n + 1) * this.components[i]] = 1.0;
        }
        return mtx;
    }

    public RealLocalizable d(int d) {
        for (int i = 0; i < this.components.length; ++i) {
            this.dpt.setPosition(this.get(i, d), i);
        }
        return this.dpt;
    }
}

