/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.imglib2;

import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.BiFunction;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.label.AbstractLabelMultisetLoader;
import net.imglib2.type.label.ByteUtils;
import net.imglib2.type.label.LabelMultisetEntry;
import net.imglib2.type.label.LabelMultisetEntryList;
import net.imglib2.type.label.LongMappedAccessData;
import net.imglib2.type.label.MappedAccessData;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class N5LabelMultisetCacheLoader
extends AbstractLabelMultisetLoader {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final N5Reader n5;
    private final String dataset;
    private final BiFunction<CellGrid, long[], byte[]> nullReplacement;

    public N5LabelMultisetCacheLoader(N5Reader n5, String dataset) {
        this(n5, dataset, (g, p) -> null);
    }

    public N5LabelMultisetCacheLoader(N5Reader n5, String dataset, BiFunction<CellGrid, long[], byte[]> nullReplacement) {
        super(N5LabelMultisetCacheLoader.generateCellGrid(n5, dataset));
        this.n5 = n5;
        this.dataset = dataset;
        this.nullReplacement = nullReplacement;
    }

    public static BiFunction<CellGrid, long[], byte[]> constantNullReplacement(long id) {
        return new ConstantNullReplacement(id);
    }

    private static CellGrid generateCellGrid(N5Reader n5, String dataset) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        long[] dimensions = attributes.getDimensions();
        int[] cellDimensions = attributes.getBlockSize();
        return new CellGrid(dimensions, cellDimensions);
    }

    protected byte[] getData(long ... gridPosition) {
        LOG.debug("Reading block for position {}", (Object)gridPosition);
        DataBlock block = this.n5.readBlock(this.dataset, this.n5.getDatasetAttributes(this.dataset), gridPosition);
        LOG.debug("Read block for position {} {}", (Object)gridPosition, (Object)block);
        return block == null ? this.nullReplacement.apply(this.grid, gridPosition) : (byte[])block.getData();
    }

    private static class ConstantNullReplacement
    implements BiFunction<CellGrid, long[], byte[]> {
        private final long id;

        private ConstantNullReplacement(long id) {
            this.id = id;
        }

        private static int numElements(int[] size) {
            int n = 1;
            for (int s : size) {
                n *= s;
            }
            return n;
        }

        @Override
        public byte[] apply(CellGrid cellGrid, long[] cellPos) {
            int i;
            long[] cellMin = new long[cellPos.length];
            int[] cellDims = new int[cellMin.length];
            Arrays.setAll(cellMin, d -> cellPos[d] * (long)cellGrid.cellDimension(d));
            cellGrid.getCellDimensions(cellPos, cellMin, cellDims);
            int numElements = ConstantNullReplacement.numElements(cellDims);
            LongMappedAccessData listData = (LongMappedAccessData)LongMappedAccessData.factory.createStorage(0L);
            LabelMultisetEntryList list = new LabelMultisetEntryList(listData, 0L);
            LabelMultisetEntry entry = new LabelMultisetEntry(0L, 1);
            list.createListAt((MappedAccessData)listData, 0L);
            entry.setId(this.id);
            entry.setCount(1);
            list.add(entry);
            int listSize = (int)list.getSizeInBytes();
            byte[] bytes = new byte[4 + numElements * 8 + numElements * 4 + listSize];
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.putInt(numElements);
            for (i = 0; i < numElements; ++i) {
                bb.putLong(this.id);
            }
            for (i = 0; i < numElements; ++i) {
                bb.putInt(0);
            }
            LOG.debug("Putting id {}", (Object)this.id);
            for (i = 0; i < listSize; ++i) {
                bb.put(ByteUtils.getByte((long[])listData.getData(), (long)i));
            }
            LOG.debug("Returning {} bytes for {} elements", (Object)bytes.length, (Object)numElements);
            return bytes;
        }
    }
}

