/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.axis;

import java.util.Arrays;
import java.util.List;
import net.imagej.axis.AbstractCalibratedAxis;
import net.imagej.axis.AxisType;

public class EnumeratedAxis
extends AbstractCalibratedAxis {
    private double[] values;
    private boolean invertible;

    public EnumeratedAxis(AxisType type, List<? extends Number> values) {
        this(type, values.stream().mapToDouble(x -> x.doubleValue()).toArray());
    }

    public EnumeratedAxis(AxisType type, double[] values) {
        super(type);
        this.setValues(values);
    }

    public EnumeratedAxis(AxisType type, String unit, double[] values) {
        super(type, unit);
        this.setValues(values);
    }

    public void setValues(double[] values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("Need at least one value");
        }
        this.values = values;
        this.invertible = true;
        for (int i = 0; i < values.length - 1; ++i) {
            if (!(values[i] >= values[i + 1])) continue;
            this.invertible = false;
            break;
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Arrays.hashCode(this.values);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EnumeratedAxis)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnumeratedAxis other = (EnumeratedAxis)o;
        return Arrays.equals(this.values, other.values);
    }

    @Override
    public double calibratedValue(double rawValue) {
        double i1;
        if (this.values.length == 1) {
            return this.values[0];
        }
        double i0 = Math.floor(rawValue);
        if (i0 == (i1 = Math.ceil(rawValue)) && i0 >= 0.0 && i0 < (double)this.values.length) {
            return this.values[(int)i0];
        }
        if (i0 < 0.0) {
            double slope = this.values[1] - this.values[0];
            double offset = this.values[0];
            return slope * rawValue + offset;
        }
        if (i1 >= (double)this.values.length) {
            int len = this.values.length;
            double slope = this.values[len - 1] - this.values[len - 2];
            double offset = this.values[len - 1];
            return slope * (rawValue - (double)len + 1.0) + offset;
        }
        double w = rawValue - i0;
        return (1.0 - w) * this.values[(int)i0] + w * this.values[(int)i1];
    }

    @Override
    public double rawValue(double calibratedValue) {
        if (!this.invertible) {
            throw new UnsupportedOperationException("Non-invertible calibration values");
        }
        if (this.values.length == 1) {
            return 0.0;
        }
        int index = Arrays.binarySearch(this.values, calibratedValue);
        if (index >= 0) {
            return index;
        }
        int i0 = -index - 2;
        int i1 = -index - 1;
        if (i0 < 0) {
            double slope = this.values[1] - this.values[0];
            double offset = this.values[0];
            return (calibratedValue - offset) / slope;
        }
        if (i1 >= this.values.length) {
            int len = this.values.length;
            double slope = this.values[len - 1] - this.values[len - 2];
            double offset = this.values[len - 1];
            return (calibratedValue - offset) / slope + (double)len - 1.0;
        }
        double frac = (this.values[i1] - calibratedValue) / (this.values[i1] - this.values[i0]);
        return (double)i1 - frac;
    }

    @Override
    public String generalEquation() {
        return "N/A";
    }

    @Override
    public String particularEquation() {
        return "N/A";
    }

    @Override
    public EnumeratedAxis copy() {
        return new EnumeratedAxis(this.type(), this.unit(), (double[])this.values.clone());
    }
}

