/*
 * Decompiled with CFR 0.152.
 */
package fiji.util.gui;

import fiji.util.Levenshtein;
import ij.IJ;
import ij.WindowManager;
import ij.text.TextWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class CommandFinderBase
extends JFrame
implements ActionListener,
WindowListener,
KeyListener,
ItemListener,
MouseListener {
    protected JTextField prompt;
    protected JList completions;
    protected JScrollPane scrollPane;
    protected DefaultListModel completionsModel;
    protected JButton runButton;
    protected JButton closeButton;
    protected JButton exportButton;
    protected JCheckBox fullInfoCheckBox;
    protected JCheckBox fuzzyCheckBox;
    protected JCheckBox closeCheckBox;
    protected List<Action> actions;

    public CommandFinderBase(String title) {
        super(title);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.addWindowListener(this);
        this.fullInfoCheckBox = new JCheckBox("Show full information", false);
        this.fullInfoCheckBox.addItemListener(this);
        this.fullInfoCheckBox.addKeyListener(this);
        this.fuzzyCheckBox = new JCheckBox("Fuzzy matching", false);
        this.fuzzyCheckBox.addItemListener(this);
        this.fuzzyCheckBox.addKeyListener(this);
        this.closeCheckBox = new JCheckBox("Close when running", true);
        this.fuzzyCheckBox.addItemListener(this);
        this.fuzzyCheckBox.addKeyListener(this);
        JPanel northPanel = new JPanel();
        northPanel.add(new JLabel("Type part of a command:"));
        this.prompt = new JTextField("", 30);
        this.prompt.getDocument().addDocumentListener(new PromptDocumentListener());
        this.prompt.addKeyListener(this);
        northPanel.add(this.prompt);
        contentPane.add((Component)northPanel, "North");
        this.completionsModel = new DefaultListModel();
        this.completions = new JList(this.completionsModel);
        this.scrollPane = new JScrollPane(this.completions);
        this.completions.setSelectionMode(0);
        this.completions.setLayoutOrientation(0);
        this.completions.setVisibleRowCount(20);
        this.completions.addKeyListener(this);
        contentPane.add((Component)this.scrollPane, "Center");
        this.completions.addMouseListener(this);
        this.runButton = new JButton("Run");
        this.exportButton = new JButton("Export");
        this.closeButton = new JButton("Close");
        this.runButton.addActionListener(this);
        this.exportButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.runButton.addKeyListener(this);
        this.closeButton.addKeyListener(this);
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BorderLayout());
        JPanel optionsPanel = new JPanel();
        optionsPanel.add(this.fullInfoCheckBox);
        optionsPanel.add(this.fuzzyCheckBox);
        optionsPanel.add(this.closeCheckBox);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.runButton);
        buttonsPanel.add(this.exportButton);
        buttonsPanel.add(this.closeButton);
        southPanel.add((Component)optionsPanel, "Center");
        southPanel.add((Component)buttonsPanel, "South");
        contentPane.add((Component)southPanel, "South");
        this.pack();
    }

    public abstract void populateActions();

    public void error(String message) {
        IJ.error((String)message);
    }

    protected boolean showFullInformation() {
        return this.fullInfoCheckBox.isSelected();
    }

    protected boolean fuzzyMatching() {
        return this.fuzzyCheckBox.isSelected();
    }

    protected boolean closeWhenRunning() {
        return this.closeCheckBox.isSelected();
    }

    protected void populateList(String matchingSubstring) {
        String substring = matchingSubstring.toLowerCase();
        this.completionsModel.removeAllElements();
        if (this.fuzzyMatching()) {
            this.populateListFuzzily(substring, this.showFullInformation());
        } else {
            for (Action action : this.actions) {
                if (action.label.toLowerCase().indexOf(substring) < 0) continue;
                this.completionsModel.addElement(action);
            }
        }
    }

    protected void populateListFuzzily(String substring, boolean fullInfo) {
        int i;
        Levenshtein levenshtein = new Levenshtein(0, 10, 1, 5, 0, 0);
        Object[] pairs = new LevenshteinPair[this.actions.size()];
        for (i = 0; i < this.actions.size(); ++i) {
            int cost = levenshtein.cost(substring, this.actions.get((int)i).label.toLowerCase());
            pairs[i] = new LevenshteinPair(i, cost);
        }
        Arrays.sort(pairs);
        for (i = 0; i < pairs.length && i < 50; ++i) {
            this.completionsModel.addElement(this.actions.get(((LevenshteinPair)pairs[i]).index));
        }
    }

    void export() {
        StringBuffer sb = new StringBuffer(5000);
        for (int i = 0; i < this.completionsModel.size(); ++i) {
            sb.append(i);
            sb.append("\t");
            sb.append(this.completionsModel.elementAt(i).toString());
            sb.append("\n");
        }
        TextWindow tw = new TextWindow("Menu Item Labels", " \tCommand", sb.toString(), 600, 500);
    }

    public void run(Action action) {
        if (action == null) {
            return;
        }
        action.run();
        if (this.closeWhenRunning()) {
            this.dispose();
        }
    }

    public void run(int itemIndex) {
        if (itemIndex < 0) {
            return;
        }
        this.run((Action)this.completionsModel.elementAt(itemIndex));
    }

    public void runSelected() {
        this.run((Action)this.completions.getSelectedValue());
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
            this.populateActions();
            this.populateList("");
        }
        if (visible) {
            WindowManager.addWindow((Frame)this);
        }
        super.setVisible(visible);
    }

    @Override
    public void dispose() {
        WindowManager.removeWindow((Frame)this);
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.runButton) {
            int selected = this.completions.getSelectedIndex();
            if (selected < 0) {
                this.error("Please select a command to run");
                return;
            }
            this.run(selected);
        } else if (source == this.exportButton) {
            this.export();
        } else if (source == this.closeButton) {
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        Object source = ie.getSource();
        int index = this.completions.getSelectedIndex();
        this.populateList(this.prompt.getText());
        if (index >= 0) {
            this.completions.setSelectedIndex(index);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            this.runSelected();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        int key = ke.getKeyCode();
        int items = this.completionsModel.getSize();
        Object source = ke.getSource();
        if (key == 27) {
            this.dispose();
        } else if (source == this.prompt) {
            if (key == 10) {
                if (1 == items) {
                    this.run(0);
                }
                return;
            }
            int index = -1;
            if (key == 38) {
                index = this.completions.getSelectedIndex() - 1;
                if (index < 0) {
                    index = items - 1;
                }
            } else if (key == 40) {
                index = this.completions.getSelectedIndex() + 1;
                if (index >= items) {
                    index = Math.min(items - 1, 0);
                }
            } else if (key == 34) {
                index = this.completions.getLastVisibleIndex();
            }
            if (index >= 0) {
                this.completions.requestFocus();
                this.completions.ensureIndexIsVisible(index);
                this.completions.setSelectedIndex(index);
            }
        } else if (key == 8) {
            this.prompt.requestFocus();
        } else if (source == this.completions) {
            if (key == 10) {
                this.runSelected();
            } else if (key == 38) {
                if (this.completions.getSelectedIndex() <= 0) {
                    this.completions.clearSelection();
                    this.prompt.requestFocus();
                }
            } else if (key == 40 && this.completions.getSelectedIndex() == items - 1) {
                this.completions.clearSelection();
                this.prompt.requestFocus();
            }
        } else if (source == this.runButton) {
            if (key == 10) {
                this.runSelected();
            }
        } else if (source == this.closeButton && key == 10) {
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    protected class PromptDocumentListener
    implements DocumentListener {
        protected PromptDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            CommandFinderBase.this.populateList(CommandFinderBase.this.prompt.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            CommandFinderBase.this.populateList(CommandFinderBase.this.prompt.getText());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            CommandFinderBase.this.populateList(CommandFinderBase.this.prompt.getText());
        }
    }

    protected static class LevenshteinPair
    implements Comparable<LevenshteinPair> {
        int index;
        int cost;

        public LevenshteinPair(int index, int cost) {
            this.index = index;
            this.cost = cost;
        }

        @Override
        public int compareTo(LevenshteinPair other) {
            return this.cost - other.cost;
        }
    }

    protected abstract class Action {
        protected String label;
        protected String menuLocation;

        public Action(String label, String menuLocation) {
            this.label = label;
            this.menuLocation = menuLocation;
        }

        public abstract void run();

        public String getExtraInformation() {
            if (!CommandFinderBase.this.showFullInformation()) {
                return "";
            }
            return " (" + this.menuLocation + ")";
        }

        public String toString() {
            return this.label + this.getExtraInformation();
        }
    }
}

