/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.example;

import edu.utexas.clm.archipelago.Cluster;
import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.compute.SerializableCallable;
import edu.utexas.clm.archipelago.network.node.ClusterNode;
import ij.plugin.PlugIn;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Test_Cluster
implements PlugIn {
    Cluster cluster;
    ExecutorService[] executors;
    final int[] coreCount = new int[]{4, 128};
    int numCalls;

    private ArrayList<Future<NullCall>> submitJobs(ExecutorService[] executors, int[] coreCount, int numCalls) {
        ArrayList<Future<NullCall>> futures = new ArrayList<Future<NullCall>>(numCalls);
        int eid = 0;
        for (int i = 0; i < numCalls; ++i) {
            int n = coreCount[eid];
            futures.add(executors[eid].submit(new NullCall(5000L, n)));
            if (++eid < executors.length) continue;
            eid = 0;
        }
        return futures;
    }

    private ArrayList<NullCall> createCallables(int coreCount, int numCalls) {
        ArrayList<NullCall> callables = new ArrayList<NullCall>(numCalls);
        for (int i = 0; i < numCalls; ++i) {
            callables.add(new NullCall(5000L, coreCount));
        }
        return callables;
    }

    private void logResults(List<Future<NullCall>> futures) {
        for (Future<NullCall> future : futures) {
            try {
                NullCall nullCall = future.get();
                if (nullCall != null) {
                    FijiArchipelago.log("Callable requested " + nullCall.nc + ", ran on " + nullCall.string);
                    continue;
                }
                FijiArchipelago.log("Callable returned null");
            }
            catch (InterruptedException ie) {
                FijiArchipelago.err("Test: Interrupted!");
                return;
            }
            catch (ExecutionException ee) {
                FijiArchipelago.err("Test: " + ee);
                return;
            }
        }
    }

    private void basicTest() {
        FijiArchipelago.log("Basic Test");
        this.logResults(this.submitJobs(this.executors, this.coreCount, this.numCalls));
        FijiArchipelago.log("Basic Test Complete");
    }

    private void midCancelTest() {
        FijiArchipelago.log("Mid Cancel Test");
        ArrayList<Future<NullCall>> futures = this.submitJobs(this.executors, this.coreCount, this.numCalls);
        boolean ok = true;
        int clusterMaxThreads = this.cluster.getMaxThreads();
        for (ClusterNode node : this.cluster.getNodes()) {
            if (!ok || node.getThreadLimit() == clusterMaxThreads) continue;
            FijiArchipelago.log("Waiting to close " + node);
            while (node.numRunningThreads() == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            FijiArchipelago.log("Closing " + node);
            node.close();
            ok = false;
        }
        this.logResults(futures);
        FijiArchipelago.log("Mid Cancel Test Complete");
    }

    private void shutdownTest() {
        FijiArchipelago.log("Shutdown Test");
        final ArrayList<Future<NullCall>> finalFutures = this.submitJobs(this.executors, this.coreCount, this.numCalls);
        Thread t = new Thread(){

            @Override
            public void run() {
                Test_Cluster.this.logResults(finalFutures);
            }
        };
        t.start();
        FijiArchipelago.log("Shutting down cluster");
        this.executors[0].shutdown();
        try {
            t.join();
        }
        catch (InterruptedException ie) {
            FijiArchipelago.log("Test: Interrupted!");
        }
        FijiArchipelago.log("Shutdown Test Complete");
    }

    private void invokeAllTest() {
        FijiArchipelago.log("Invoke All Test");
        try {
            this.logResults(this.executors[0].invokeAll(this.createCallables(this.coreCount[0], this.numCalls)));
        }
        catch (InterruptedException ie) {
            FijiArchipelago.err(ie.toString());
        }
        FijiArchipelago.log("Invoke All Test Complete");
    }

    private void invokeAllTimeoutTest() {
        FijiArchipelago.log("Invoke All Timeout Test");
        try {
            List<Future<NullCall>> results = this.executors[0].invokeAll(this.createCallables(this.coreCount[0], this.numCalls * 2), 7500L, TimeUnit.MILLISECONDS);
            this.logResults(results);
        }
        catch (InterruptedException ie) {
            FijiArchipelago.err(ie.toString());
        }
        FijiArchipelago.log("Invoke All Timeout Test Complete");
    }

    private void invokeAnyTest() {
    }

    private void invokeAnyTimeoutTest() {
    }

    public synchronized void run(String arg) {
        if (Cluster.activeCluster() || FijiArchipelago.runClusterGUI()) {
            this.cluster = Cluster.getCluster();
            this.executors = new ExecutorService[this.coreCount.length];
            this.cluster.waitUntilReady();
            try {
                this.cluster.waitForAllNodes(3000000L);
            }
            catch (TimeoutException toe) {
                FijiArchipelago.log("Test: Timed out waiting for nodes, continuing anyway");
            }
            catch (InterruptedException ie) {
                FijiArchipelago.log("Test: Interrupted while waiting, quitting.");
                return;
            }
            for (int i = 0; i < this.coreCount.length; ++i) {
                this.executors[i] = this.cluster.getService(this.coreCount[i]);
            }
            this.numCalls = this.cluster.getNodes().size() * 4;
            this.basicTest();
            this.invokeAllTest();
            this.invokeAllTimeoutTest();
            this.invokeAnyTimeoutTest();
            this.midCancelTest();
            this.shutdownTest();
        }
    }

    public static class NullCall
    implements SerializableCallable<NullCall> {
        private final long winks;
        private final int nc;
        private String string;

        public NullCall(long sleepTime, int n) {
            this.winks = sleepTime;
            this.nc = n;
        }

        @Override
        public NullCall call() throws Exception {
            try {
                Thread.sleep(this.winks);
                this.string = InetAddress.getLocalHost().getHostName();
            }
            catch (InterruptedException ie) {
                this.string = "interrupted";
            }
            catch (UnknownHostException uhe) {
                this.string = "unknown";
            }
            return this;
        }
    }
}

