/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import customnode.CustomMesh;
import ij3d.ContentNode;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.View;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Tuple3f;

public class CustomMeshNode
extends ContentNode {
    private CustomMesh mesh;
    protected Point3f min;
    protected Point3f max;
    protected Point3f center;

    protected CustomMeshNode() {
    }

    public CustomMeshNode(CustomMesh mesh) {
        this.mesh = mesh;
        this.calculateMinMaxCenterPoint();
        this.addChild((Node)mesh);
    }

    public CustomMesh getMesh() {
        return this.mesh;
    }

    @Override
    public void getMin(Tuple3d min) {
        min.set((Tuple3f)this.min);
    }

    @Override
    public void getMax(Tuple3d max) {
        max.set((Tuple3f)this.max);
    }

    @Override
    public void getCenter(Tuple3d center) {
        center.set((Tuple3f)this.center);
    }

    @Override
    public void channelsUpdated(boolean[] channels) {
    }

    @Override
    public void lutUpdated(int[] r, int[] g, int[] b, int[] a) {
    }

    @Override
    public void colorUpdated(Color3f color) {
        this.mesh.setColor(color);
    }

    @Override
    public void eyePtChanged(View view) {
    }

    @Override
    public float getVolume() {
        return this.mesh.getVolume();
    }

    @Override
    public void shadeUpdated(boolean shaded) {
        this.mesh.setShaded(shaded);
    }

    @Override
    public void thresholdUpdated(int threshold) {
    }

    @Override
    public void transparencyUpdated(float transparency) {
        this.mesh.setTransparency(transparency);
    }

    private void calculateMinMaxCenterPoint() {
        this.min = new Point3f();
        this.max = new Point3f();
        this.center = new Point3f();
        this.mesh.calculateMinMaxCenterPoint(this.min, this.max, this.center);
    }

    @Override
    public void restoreDisplayedData(String path, String name) {
        this.mesh.restoreDisplayedData(path, name);
    }

    @Override
    public void swapDisplayedData(String path, String name) {
        this.mesh.swapDisplayedData(path, name);
    }

    @Override
    public void clearDisplayedData() {
        this.mesh.clearDisplayedData();
    }
}

