/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.concatenate.Concatenable;
import net.imglib2.concatenate.PreConcatenable;
import net.imglib2.realtransform.AbstractScale;
import net.imglib2.realtransform.ScaleGet;

public class Scale3D
extends AbstractScale
implements Concatenable<ScaleGet>,
PreConcatenable<ScaleGet> {
    protected final Scale3D inverse;

    protected Scale3D(double[] s, Scale3D inverse, RealPoint[] ds) {
        super(s, ds);
        assert (s.length == this.numDimensions()) : "Input dimensions do not match or are not 3.";
        this.inverse = inverse;
    }

    public Scale3D(double sx, double sy, double sz) {
        super(new double[3], new RealPoint[3]);
        this.s[0] = sx;
        this.s[1] = sy;
        this.s[2] = sz;
        this.ds[0] = new RealPoint(new double[]{sx, 0.0, 0.0});
        this.ds[1] = new RealPoint(new double[]{0.0, sy, 0.0});
        this.ds[2] = new RealPoint(new double[]{0.0, 0.0, sz});
        double[] si = new double[]{1.0 / this.s[0], 1.0 / this.s[1], 1.0 / this.s[2]};
        RealPoint[] dis = new RealPoint[]{new RealPoint(new double[]{si[0], 0.0, 0.0}), new RealPoint(new double[]{0.0, si[1], 0.0}), new RealPoint(new double[]{0.0, 0.0, si[2]})};
        this.inverse = new Scale3D(si, this, dis);
    }

    public Scale3D(double ... s) {
        super((double[])s.clone(), new RealPoint[s.length]);
        assert (s.length == this.numDimensions()) : "Input dimensions do not match or are not 3.";
        this.ds[0] = new RealPoint(new double[]{s[0], 0.0, 0.0});
        this.ds[1] = new RealPoint(new double[]{0.0, s[1], 0.0});
        this.ds[2] = new RealPoint(new double[]{0.0, 0.0, s[2]});
        double[] si = new double[]{1.0 / s[0], 1.0 / s[1], 1.0 / s[2]};
        RealPoint[] dis = new RealPoint[]{new RealPoint(new double[]{si[0], 0.0, 0.0}), new RealPoint(new double[]{0.0, si[1], 0.0}), new RealPoint(new double[]{0.0, 0.0, si[2]})};
        this.inverse = new Scale3D(si, this, dis);
    }

    public void set(double sx, double sy, double sz) {
        this.s[0] = sx;
        this.s[1] = sy;
        this.s[2] = sz;
        this.inverse.s[0] = 1.0 / sx;
        this.inverse.s[1] = 1.0 / sy;
        this.inverse.s[2] = 1.0 / sz;
        this.ds[0].setPosition(sx, 0);
        this.ds[1].setPosition(sy, 1);
        this.ds[2].setPosition(sz, 2);
        this.inverse.ds[0].setPosition(this.inverse.s[0], 0);
        this.inverse.ds[1].setPosition(this.inverse.s[1], 1);
        this.inverse.ds[2].setPosition(this.inverse.s[2], 2);
    }

    @Override
    public void set(double ... s) {
        assert (s.length == this.numDimensions()) : "Input dimensions do not match or are not 3.";
        this.s[0] = s[0];
        this.s[1] = s[1];
        this.s[2] = s[2];
        this.inverse.s[0] = 1.0 / s[0];
        this.inverse.s[1] = 1.0 / s[1];
        this.inverse.s[2] = 1.0 / s[2];
        this.ds[0].setPosition(s[0], 0);
        this.ds[1].setPosition(s[1], 1);
        this.ds[2].setPosition(s[2], 2);
        this.inverse.ds[0].setPosition(this.inverse.s[0], 0);
        this.inverse.ds[1].setPosition(this.inverse.s[1], 1);
        this.inverse.ds[2].setPosition(this.inverse.s[2], 2);
    }

    @Override
    public void applyInverse(double[] source, double[] target) {
        assert (source.length >= this.numDimensions() && target.length >= this.numDimensions()) : "Input dimensions too small.";
        source[0] = target[0] / this.s[0];
        source[1] = target[1] / this.s[1];
        source[2] = target[2] / this.s[2];
    }

    @Override
    public void applyInverse(float[] source, float[] target) {
        assert (source.length >= this.numDimensions() && target.length >= this.numDimensions()) : "Input dimensions too small.";
        source[0] = (float)((double)target[0] / this.s[0]);
        source[1] = (float)((double)target[1] / this.s[1]);
        source[2] = (float)((double)target[2] / this.s[2]);
    }

    @Override
    public void applyInverse(RealPositionable source, RealLocalizable target) {
        assert (source.numDimensions() >= this.numDimensions() && target.numDimensions() >= this.numDimensions()) : "Input dimensions too small.";
        source.setPosition(target.getDoublePosition(0) / this.s[0], 0);
        source.setPosition(target.getDoublePosition(1) / this.s[1], 1);
        source.setPosition(target.getDoublePosition(2) / this.s[2], 2);
    }

    @Override
    public void apply(double[] source, double[] target) {
        assert (source.length >= this.numDimensions() && target.length >= this.numDimensions()) : "Input dimensions too small.";
        target[0] = source[0] * this.s[0];
        target[1] = source[1] * this.s[1];
        target[2] = source[2] * this.s[2];
    }

    @Override
    public void apply(float[] source, float[] target) {
        assert (source.length >= this.numDimensions() && target.length >= this.numDimensions()) : "Input dimensions too small.";
        target[0] = (float)((double)source[0] * this.s[0]);
        target[1] = (float)((double)source[1] * this.s[1]);
        target[2] = (float)((double)source[2] * this.s[2]);
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        assert (source.numDimensions() >= this.numDimensions() && target.numDimensions() >= this.numDimensions()) : "Input dimensions too small.";
        target.setPosition(source.getDoublePosition(0) * this.s[0], 0);
        target.setPosition(source.getDoublePosition(1) * this.s[1], 1);
        target.setPosition(source.getDoublePosition(2) * this.s[2], 2);
    }

    @Override
    public double get(int row, int column) {
        assert (row >= 0 && row < this.numDimensions()) : "Dimension index out of bounds.";
        return row == column ? this.s[row] : 0.0;
    }

    @Override
    public double[] getRowPackedCopy() {
        double[] matrix = new double[12];
        matrix[0] = this.s[0];
        matrix[5] = this.s[1];
        matrix[10] = this.s[2];
        return matrix;
    }

    @Override
    public Scale3D inverse() {
        return this.inverse;
    }

    @Override
    public Scale3D copy() {
        return new Scale3D(this.s);
    }

    public Scale3D preConcatenate(ScaleGet a) {
        this.set(this.s[0] * a.getScale(0), this.s[1] * a.getScale(1), this.s[2] * a.getScale(2));
        return this;
    }

    public Class<ScaleGet> getPreConcatenableClass() {
        return ScaleGet.class;
    }

    public Scale3D concatenate(ScaleGet a) {
        return this.preConcatenate(a);
    }

    public Class<ScaleGet> getConcatenableClass() {
        return ScaleGet.class;
    }

    @Override
    public boolean isIdentity() {
        return this.s[0] == 1.0 && this.s[1] == 1.0 && this.s[2] == 1.0;
    }
}

