/*
 * Decompiled with CFR 0.152.
 */
package org.siox.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IntHashMap {
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private Entry[] data;
    private int size;
    private int threshold;
    private float loadFactor;
    protected transient int modCount = 0;

    public IntHashMap() {
        this(16, 0.75f);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap(int initialCapacity, float loadFactor) {
        this.data = new Entry[initialCapacity];
        this.loadFactor = loadFactor;
    }

    public IntHashMap(Map aMap) {
        this(Math.max(2 * aMap.size(), 16), 0.75f);
        this.putAll(aMap);
    }

    public IntHashMap(IntHashMap anIntHashMap) {
        this(Math.max(2 * anIntHashMap.size(), 16), 0.75f);
        this.putAll(anIntHashMap);
    }

    public void clear() {
        if (this.size > 0) {
            ++this.modCount;
            Arrays.fill(this.data, 0, this.size - 1, null);
            this.size = 0;
        }
    }

    public Object clone() {
        IntHashMap anIntHashMap = new IntHashMap(this.data.length, this.loadFactor);
        System.arraycopy(this.data, 0, anIntHashMap.data, 0, this.size);
        anIntHashMap.size = this.size;
        return anIntHashMap;
    }

    private int hash(int key, int tablelength) {
        return (key & Integer.MAX_VALUE) % tablelength;
    }

    public boolean containsKey(int key) {
        Entry[] table = this.data;
        int idx = this.hash(key, table.length);
        Entry anEntry = table[idx];
        while (anEntry != null) {
            if (anEntry.key == key) {
                return true;
            }
            anEntry = anEntry.next;
        }
        return false;
    }

    public boolean containsKey(Integer key) {
        return this.containsKey((int)key);
    }

    public boolean containsValue(Object value) {
        Entry[] table = this.data;
        if (value == null) {
            for (int i = 0; i < this.data.length; ++i) {
                Entry anEntry = table[i];
                while (anEntry != null) {
                    if (null == anEntry.value) {
                        return true;
                    }
                    anEntry = anEntry.next;
                }
            }
        } else {
            for (int i = 0; i < this.data.length; ++i) {
                Entry anEntry = table[i];
                while (anEntry != null) {
                    if (value.equals(anEntry.value)) {
                        return true;
                    }
                    anEntry = anEntry.next;
                }
            }
        }
        return false;
    }

    public Set entrySet() {
        return new AbstractSet(){

            @Override
            public void clear() {
                IntHashMap.this.clear();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Entry searched = (Entry)o;
                Entry[] table = IntHashMap.this.data;
                int idx = IntHashMap.this.hash(searched.key, table.length);
                Entry entry = table[idx];
                while (entry != null) {
                    if (entry.equals(searched)) {
                        return true;
                    }
                    entry = entry.next;
                }
                return false;
            }

            @Override
            public Iterator iterator() {
                return new MapIterator(2);
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Entry)) {
                    return false;
                }
                return IntHashMap.this.removeEntry((Entry)o);
            }

            @Override
            public int size() {
                return IntHashMap.this.size;
            }
        };
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntHashMap)) {
            return false;
        }
        IntHashMap anIntHashMap = (IntHashMap)o;
        if (anIntHashMap.size != this.size) {
            return false;
        }
        for (Entry anEntry : this.entrySet()) {
            if (!(anEntry.value == null ? !anIntHashMap.containsKey(anEntry.key) || anIntHashMap.get(anEntry.key) != null : !anEntry.value.equals(anIntHashMap.get(anEntry.key)))) continue;
            return false;
        }
        return true;
    }

    public Object get(int key) {
        Entry[] table = this.data;
        int idx = this.hash(key, table.length);
        Entry anEntry = table[idx];
        while (anEntry != null) {
            if (anEntry.key == key) {
                return anEntry.value;
            }
            anEntry = anEntry.next;
        }
        return null;
    }

    public Object get(Integer key) {
        return this.get((int)key);
    }

    public int hashCode() {
        int hash = 0;
        Iterator anIterator = this.entrySet().iterator();
        while (anIterator.hasNext()) {
            hash += anIterator.next().hashCode();
        }
        return hash;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Set keySet() {
        return new AbstractSet(){

            @Override
            public Iterator iterator() {
                return new MapIterator(0);
            }

            @Override
            public int size() {
                return IntHashMap.this.size;
            }

            @Override
            public boolean contains(Object o) {
                return IntHashMap.this.containsKey((Integer)o);
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Integer)) {
                    return false;
                }
                Entry entry = IntHashMap.this.removeEntryByKey((Integer)o);
                if (entry != null) {
                    entry.value = null;
                }
                return entry != null;
            }

            @Override
            public void clear() {
                IntHashMap.this.clear();
            }
        };
    }

    public Object put(int key, Object value) {
        Entry[] table = this.data;
        int idx = this.hash(key, table.length);
        Entry anEntry = table[idx];
        while (anEntry != null) {
            if (anEntry.key == key) {
                Object old = anEntry.value;
                anEntry.value = value;
                return old;
            }
            anEntry = anEntry.next;
        }
        ++this.modCount;
        if (this.size >= this.threshold) {
            Entry[] oldData = this.data;
            Entry[] newData = new Entry[2 * oldData.length + 1];
            ++this.modCount;
            this.threshold = (int)((float)newData.length * this.loadFactor);
            for (int i = 0; i < oldData.length; ++i) {
                Entry entry = oldData[i];
                while (entry != null) {
                    Entry curr = entry;
                    entry = entry.next;
                    int newIdx = this.hash(curr.key, newData.length);
                    curr.next = newData[newIdx];
                    newData[newIdx] = curr;
                }
            }
            table = this.data = newData;
            idx = this.hash(key, table.length);
        }
        table[idx] = new Entry(key, value, table[idx]);
        ++this.size;
        return null;
    }

    public Object put(Integer key, Object value) {
        return this.put((int)key, value);
    }

    private void putAll(Iterator aMapEntryInterator) {
        while (aMapEntryInterator.hasNext()) {
            Map.Entry anEntry = (Map.Entry)aMapEntryInterator.next();
            this.put((int)((Integer)anEntry.getKey()), anEntry.getValue());
        }
    }

    public void putAll(IntHashMap anIntHashMap) {
        this.putAll(anIntHashMap.entrySet().iterator());
    }

    public void putAll(Map aMap) {
        this.putAll(aMap.entrySet().iterator());
    }

    private boolean removeEntry(Entry anEntry) {
        Entry[] table = this.data;
        int idx = this.hash(anEntry.key, table.length);
        Entry curr = table[idx];
        Entry prev = null;
        while (curr != null) {
            if (anEntry.equals(curr)) {
                ++this.modCount;
                if (prev == null) {
                    table[idx] = curr.next;
                } else {
                    prev.next = curr.next;
                }
                return true;
            }
            prev = curr;
            curr = curr.next;
        }
        return false;
    }

    public Entry removeEntryByKey(int key) {
        Entry[] table = this.data;
        int idx = this.hash(key, table.length);
        Entry curr = table[idx];
        Entry prev = null;
        while (curr != null) {
            if (curr.key == key) {
                ++this.modCount;
                if (prev == null) {
                    table[idx] = curr.next;
                } else {
                    prev.next = curr.next;
                }
                return curr;
            }
            prev = curr;
            curr = curr.next;
        }
        return null;
    }

    public Object remove(int key) {
        Entry removed = this.removeEntryByKey(key);
        if (removed != null) {
            Object value = removed.value;
            removed.value = null;
            return value;
        }
        return null;
    }

    public Object remove(Integer key) {
        return this.remove((int)key);
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        Entry anEntry;
        Iterator anIterator = this.entrySet().iterator();
        StringBuffer aStringBuffer = new StringBuffer();
        aStringBuffer.append("IntHashMap{");
        if (anIterator.hasNext()) {
            anEntry = (Entry)anIterator.next();
            aStringBuffer.append(anEntry.key).append("=").append(anEntry.value);
        }
        while (anIterator.hasNext()) {
            aStringBuffer.append(",");
            anEntry = (Entry)anIterator.next();
            aStringBuffer.append(anEntry.key + "=" + anEntry.value);
        }
        aStringBuffer.append("}");
        return aStringBuffer.toString();
    }

    public Collection values() {
        return new AbstractCollection(){

            @Override
            public Iterator iterator() {
                return new MapIterator(1);
            }

            @Override
            public int size() {
                return IntHashMap.this.size;
            }

            @Override
            public boolean contains(Object o) {
                return IntHashMap.this.containsValue(o);
            }

            @Override
            public void clear() {
                IntHashMap.this.clear();
            }
        };
    }

    private class MapIterator
    implements Iterator {
        private final Entry[] table;
        private int index;
        private Entry currEntry;
        private Entry prevEntry;
        private int validModCount;
        private int type;

        MapIterator(int type) {
            this.table = IntHashMap.this.data;
            this.index = -1;
            this.currEntry = null;
            this.prevEntry = null;
            this.validModCount = IntHashMap.this.modCount;
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            Entry entry = this.currEntry;
            int i = this.index;
            while (entry == null && i < this.table.length) {
                entry = this.table[++i];
            }
            this.index = i;
            this.currEntry = this.table[this.index];
            return this.currEntry != null;
        }

        public Object next() {
            if (IntHashMap.this.modCount != this.validModCount) {
                throw new ConcurrentModificationException();
            }
            Entry entry = this.currEntry;
            int i = this.index;
            while (entry == null && i < this.table.length) {
                entry = this.table[++i];
            }
            this.index = i;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            this.prevEntry = this.currEntry;
            this.currEntry = entry.next;
            if (this.type == 2) {
                return entry;
            }
            return this.type == 0 ? new Integer(entry.key) : entry.value;
        }

        @Override
        public void remove() {
            if (this.prevEntry == null) {
                throw new IllegalStateException();
            }
            if (IntHashMap.this.modCount != this.validModCount) {
                throw new ConcurrentModificationException();
            }
            Object o = IntHashMap.this.remove(this.prevEntry.key);
            ++this.validModCount;
            if (o == null && IntHashMap.this.modCount != this.validModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class Entry
    implements Map.Entry,
    Serializable {
        private static final long serialVersionUID = 577580285278842632L;
        final int key;
        Object value;
        Entry next;

        Entry(int key, Object value, Entry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry anEntry = (Entry)o;
            return this.key == anEntry.key && (this.value == null ? anEntry.value == null : this.value.equals(anEntry.value));
        }

        public Object getKey() {
            return new Integer(this.key);
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return this.key ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }
    }
}

