/*
 * Decompiled with CFR 0.152.
 */
package siox;

import fiji.util.gui.OverlayedImageCanvas;
import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.ShapeRoiHelper;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Panel;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.swing.BoxLayout;
import javax.swing.JRadioButton;
import org.siox.SioxSegmentator;
import siox.ControlJPanel;
import siox.ImageOverlay;
import siox.RoiOverlay;
import siox.SegmentationInfo;

public class SegmentationGUI
extends ImageWindow
implements ActionListener {
    private static final long serialVersionUID = -326288432966353440L;
    FloatProcessor confMatrix = null;
    private SioxSegmentator siox;
    private JRadioButton lastButton;
    protected Roi foregroundRoi;
    protected Roi backgroundRoi;
    protected RoiOverlay roiOverlay;
    protected Roi addRoi;
    protected Roi subRoi;
    protected ImageOverlay resultOverlay;
    protected ControlJPanel controlPanel;
    ImageProcessor ip;
    final Composite transparency050 = AlphaComposite.getInstance(3, 0.5f);
    final Composite transparency075 = AlphaComposite.getInstance(3, 0.75f);
    final Composite transparency100 = AlphaComposite.getInstance(3, 1.0f);

    public SegmentationGUI(ImagePlus imp) {
        super(imp, (ImageCanvas)new OverlayedImageCanvas(imp));
        while (this.ic.getWidth() > 800 && this.ic.getHeight() > 600) {
            IJ.run((ImagePlus)imp, (String)"Out", (String)"");
        }
        this.roiOverlay = new RoiOverlay();
        this.resultOverlay = new ImageOverlay();
        ((OverlayedImageCanvas)this.ic).addOverlay((OverlayedImageCanvas.Overlay)this.roiOverlay);
        ((OverlayedImageCanvas)this.ic).addOverlay((OverlayedImageCanvas.Overlay)this.resultOverlay);
        this.roiOverlay.setComposite(this.transparency050);
        this.resultOverlay.setComposite(this.transparency075);
        this.ip = imp.getProcessor();
        this.setTitle("SIOX Segmentation");
        Panel imagePanel = new Panel();
        imagePanel.add((Component)this.ic);
        this.controlPanel = new ControlJPanel(imp);
        this.controlPanel.bgJRadioButton.addActionListener(this);
        this.lastButton = this.controlPanel.fgJRadioButton;
        this.controlPanel.fgJRadioButton.addActionListener(this);
        this.controlPanel.segmentJButton.addActionListener(this);
        this.controlPanel.resetJButton.addActionListener(this);
        this.controlPanel.createMaskJButton.addActionListener(this);
        this.controlPanel.saveSegmentatorJButton.addActionListener(this);
        this.controlPanel.addJRadioButton.addActionListener(this);
        this.controlPanel.subJRadioButton.addActionListener(this);
        this.controlPanel.refineJButton.addActionListener(this);
        Panel all = new Panel();
        BoxLayout box = new BoxLayout(all, 0);
        all.setLayout(box);
        all.add(imagePanel);
        all.add(this.controlPanel);
        this.add(all);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.controlPanel.bgJRadioButton && this.lastButton != this.controlPanel.bgJRadioButton) {
            this.roiOverlay.setColor(Color.GREEN);
            this.foregroundRoi = this.setNewRoi(this.backgroundRoi, this.roiOverlay);
            this.lastButton = this.controlPanel.bgJRadioButton;
        } else if (e.getSource() == this.controlPanel.fgJRadioButton && this.lastButton != this.controlPanel.fgJRadioButton) {
            this.roiOverlay.setColor(Color.RED);
            this.backgroundRoi = this.setNewRoi(this.foregroundRoi, this.roiOverlay);
            this.lastButton = this.controlPanel.fgJRadioButton;
        } else if (e.getSource() == this.controlPanel.segmentJButton) {
            this.segment();
        } else if (e.getSource() == this.controlPanel.addJRadioButton && this.lastButton != this.controlPanel.addJRadioButton) {
            this.roiOverlay.setColor(Color.RED);
            this.subRoi = this.setNewRoi(this.addRoi, this.roiOverlay);
            this.lastButton = this.controlPanel.addJRadioButton;
        } else if (e.getSource() == this.controlPanel.subJRadioButton && this.lastButton != this.controlPanel.subJRadioButton) {
            this.roiOverlay.setColor(Color.GREEN);
            this.addRoi = this.setNewRoi(this.subRoi, this.roiOverlay);
            this.lastButton = this.controlPanel.subJRadioButton;
        } else if (e.getSource() == this.controlPanel.refineJButton) {
            this.refine();
        } else if (e.getSource() == this.controlPanel.resetJButton) {
            this.reset();
        } else if (e.getSource() == this.controlPanel.createMaskJButton) {
            this.createBinaryMask();
        } else if (e.getSource() == this.controlPanel.saveSegmentatorJButton) {
            this.saveSegmentator();
        }
    }

    private void saveSegmentator() {
        String currentDirectory;
        if (this.controlPanel.status != 6) {
            IJ.error((String)"No segmentator found!");
            return;
        }
        String string = currentDirectory = OpenDialog.getLastDirectory() == null ? OpenDialog.getDefaultDirectory() : OpenDialog.getLastDirectory();
        if (null == currentDirectory) {
            currentDirectory = ".";
        }
        SaveDialog sd = new SaveDialog("Save segmentator", currentDirectory, "segmentator-" + this.imp.getTitle(), ".siox");
        String filename = sd.getFileName();
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(sd.getDirectory() + filename);
            out = new ObjectOutputStream(fos);
            out.writeObject(new SegmentationInfo(this.siox.getBgSignature(), this.siox.getFgSignature(), this.controlPanel.smoothness.getValue(), this.controlPanel.multipart.isSelected() ? 4.0 : 0.0));
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void createBinaryMask() {
        if (null != this.confMatrix) {
            ByteProcessor result = (ByteProcessor)this.confMatrix.convertToByte(false);
            result.multiply(255.0);
            if (!Prefs.blackBackground) {
                result.invert();
            }
            new ImagePlus("Mask", (ImageProcessor)result).show();
        }
    }

    private void reset() {
        this.roiOverlay.setRoi(null);
        this.resultOverlay.setImage(null);
        this.confMatrix = null;
        this.controlPanel.status = 5;
        this.lastButton = this.controlPanel.fgJRadioButton.isSelected() ? this.controlPanel.fgJRadioButton : this.controlPanel.bgJRadioButton;
        this.roiOverlay.setColor(this.controlPanel.fgJRadioButton.isSelected() ? Color.RED : Color.GREEN);
        this.roiOverlay.setComposite(this.transparency050);
        if (this.controlPanel.bgJRadioButton.isSelected()) {
            this.imp.setRoi(this.backgroundRoi);
            this.roiOverlay.setRoi(this.foregroundRoi);
        } else {
            this.imp.setRoi(this.foregroundRoi);
            this.roiOverlay.setRoi(this.backgroundRoi);
        }
        this.controlPanel.updateComponentEnabling();
        this.imp.changes = true;
        this.imp.updateAndDraw();
    }

    synchronized Roi setNewRoi(Roi newRoi, RoiOverlay overlayToPaint) {
        Roi oldRoi = this.imp.getRoi();
        if (newRoi == null) {
            this.imp.killRoi();
        } else {
            this.imp.setRoi(newRoi);
        }
        overlayToPaint.setRoi(oldRoi);
        this.imp.changes = true;
        this.imp.updateAndDraw();
        return oldRoi;
    }

    private synchronized void refine() {
        Area area;
        AffineTransform trans;
        Shape shape;
        float alpha;
        if (this.controlPanel.status != 6) {
            return;
        }
        if (this.controlPanel.addJRadioButton.isSelected()) {
            this.addRoi = this.imp.getRoi();
        } else {
            this.subRoi = this.imp.getRoi();
        }
        if (null != this.addRoi) {
            alpha = (float)this.controlPanel.addThreshold.getValue() / 100.0f;
            shape = ShapeRoiHelper.getShape((ShapeRoi)new ShapeRoi(this.addRoi));
            trans = new AffineTransform();
            trans.translate(this.addRoi.getBounds().getX(), this.addRoi.getBounds().getY());
            area = new Area(shape);
            area.transform(trans);
            this.siox.subpixelRefine(area, "add", alpha, (float[])this.confMatrix.getPixels());
        }
        if (null != this.subRoi) {
            alpha = (float)this.controlPanel.subThreshold.getValue() / 100.0f;
            shape = ShapeRoiHelper.getShape((ShapeRoi)new ShapeRoi(this.subRoi));
            trans = new AffineTransform();
            trans.translate(this.subRoi.getBounds().getX(), this.subRoi.getBounds().getY());
            area = new Area(shape);
            area.transform(trans);
            this.siox.subpixelRefine(area, "subtract", alpha, (float[])this.confMatrix.getPixels());
        }
        this.updateResult();
    }

    private synchronized void segment() {
        Roi[] rois;
        if (this.controlPanel.bgJRadioButton.isSelected()) {
            this.backgroundRoi = this.imp.getRoi();
        } else {
            this.foregroundRoi = this.imp.getRoi();
        }
        if (this.foregroundRoi == null) {
            IJ.error((String)"Siox Segmentation", (String)"ERROR: no foreground selected!");
            return;
        }
        this.confMatrix = new FloatProcessor(this.imp.getWidth(), this.imp.getHeight());
        float[] confMatrixArray = (float[])this.confMatrix.getPixels();
        this.confMatrix.add(0.5);
        if (this.foregroundRoi != null) {
            this.confMatrix.setValue(1.0);
            this.confMatrix.fill(this.foregroundRoi);
        }
        if (this.backgroundRoi != null) {
            this.confMatrix.setValue(0.0);
            this.confMatrix.fill(this.backgroundRoi);
        } else {
            int i;
            int w = this.imp.getWidth();
            int h = this.imp.getHeight();
            for (i = 0; i < w; ++i) {
                if (confMatrixArray[i] < 0.8f) {
                    confMatrixArray[i] = 0.0f;
                }
                if (!(confMatrixArray[i + w * (h - 1)] < 0.8f)) continue;
                confMatrixArray[i + w * (h - 1)] = 0.0f;
            }
            for (i = 0; i < h; ++i) {
                if (confMatrixArray[w * i] < 0.8f) {
                    confMatrixArray[w * i] = 0.0f;
                }
                if (!(confMatrixArray[w - 1 + w * i] < 0.8f)) continue;
                confMatrixArray[w - 1 + w * i] = 0.0f;
            }
        }
        int[] pixels = (int[])this.ip.getPixels();
        int smoothes = this.controlPanel.smoothness.getValue();
        this.siox = new SioxSegmentator(this.imp.getWidth(), this.imp.getHeight(), null);
        boolean multipleObjects = this.controlPanel.multipart.isSelected();
        if (!multipleObjects && this.foregroundRoi instanceof ShapeRoi && (rois = ((ShapeRoi)this.foregroundRoi).getRois()).length > 1) {
            multipleObjects = true;
            this.controlPanel.multipart.setSelected(true);
        }
        boolean success = false;
        try {
            success = this.siox.segmentate(pixels, confMatrixArray, smoothes, multipleObjects ? 4.0 : 0.0);
        }
        catch (IllegalStateException ex) {
            IJ.error((String)"Siox Segmentation", (String)"ERROR: foreground signature does not exist.");
        }
        if (!success) {
            IJ.error((String)"Siox Segmentation", (String)"The segmentation failed!");
        }
        this.updateResult();
        this.controlPanel.status = 6;
        this.controlPanel.updateComponentEnabling();
        this.roiOverlay.setComposite(this.transparency100);
        this.controlPanel.subJRadioButton.setSelected(true);
        this.controlPanel.addJRadioButton.setSelected(false);
        this.lastButton = this.controlPanel.subJRadioButton;
    }

    private void updateResult() {
        this.imp.killRoi();
        this.roiOverlay.setRoi(null);
        ImageProcessor cp = this.confMatrix.convertToRGB();
        cp.multiply(0.00392156862745098);
        cp.copyBits(this.ip, 0, 0, 5);
        this.resultOverlay.setImage(cp);
        this.imp.changes = true;
        this.imp.updateAndDraw();
    }

    public void windowClosing(WindowEvent e) {
        ImagePlus img = new ImagePlus(this.imp.getTitle(), this.imp.getProcessor().duplicate());
        img.changes = this.imp.changes;
        img.show();
        this.imp.changes = false;
        super.windowClosing(e);
    }
}

