/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.plugin;

import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import mpicbg.ij.util.Util;
import mpicbg.models.PointMatch;
import mpicbg.util.Timer;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPointSampleList;
import net.imglib2.neighborsearch.NearestNeighborSearch;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;

public abstract class AbstractBlockMatching
implements PlugIn {
    protected static float scale = 1.0f;
    protected static int blockRadius = 50;
    protected static int searchRadius = 50;
    protected static float minR = 0.1f;
    protected static float rodR = 1.0f;
    protected static float maxCurvatureR = 1000.0f;
    protected static boolean useLocalSmoothnessFilter = true;
    protected static String[] modelStrings = new String[]{"Translation", "Rigid", "Similarity", "Affine"};
    protected static int localModelIndex = 1;
    protected static float localRegionSigma = 65.0f;
    protected static float maxLocalEpsilon = 12.0f;
    protected static float maxLocalTrust = 3.0f;
    protected static int meshResolution = 24;

    protected void addFields(GenericDialog gd) {
        gd.addMessage("Block Matching:");
        gd.addNumericField("layer_scale :", (double)scale, 2);
        gd.addNumericField("search_radius :", (double)searchRadius, 0, 6, "px");
        gd.addNumericField("block_radius :", (double)blockRadius, 0, 6, "px");
        gd.addNumericField("resolution :", (double)meshResolution, 0);
        gd.addMessage("Correlation Filters:");
        gd.addNumericField("minimal_PMCC_r :", (double)minR, 2);
        gd.addNumericField("maximal_curvature_ratio :", (double)maxCurvatureR, 2);
        gd.addNumericField("maximal_second_best_r/best_r :", (double)rodR, 2);
        gd.addMessage("Local Smoothness Filter:");
        gd.addCheckbox("use_local_smoothness_filter", useLocalSmoothnessFilter);
        gd.addChoice("approximate_local_transformation :", modelStrings, modelStrings[localModelIndex]);
        gd.addNumericField("local_region_sigma:", (double)localRegionSigma, 2, 6, "px");
        gd.addNumericField("maximal_local_displacement (absolute):", (double)maxLocalEpsilon, 2, 6, "px");
        gd.addNumericField("maximal_local_displacement (relative):", (double)maxLocalTrust, 2);
    }

    protected void readFields(GenericDialog gd) {
        scale = (float)gd.getNextNumber();
        searchRadius = (int)gd.getNextNumber();
        blockRadius = (int)gd.getNextNumber();
        meshResolution = (int)gd.getNextNumber();
        minR = (float)gd.getNextNumber();
        maxCurvatureR = (float)gd.getNextNumber();
        rodR = (float)gd.getNextNumber();
        useLocalSmoothnessFilter = gd.getNextBoolean();
        localModelIndex = gd.getNextChoiceIndex();
        localRegionSigma = (float)gd.getNextNumber();
        maxLocalEpsilon = (float)gd.getNextNumber();
        maxLocalTrust = (float)gd.getNextNumber();
    }

    protected static final FloatProcessor createMask(ColorProcessor source) {
        FloatProcessor mask = new FloatProcessor(source.getWidth(), source.getHeight());
        int maskColor = 65280;
        int[] sourcePixels = (int[])source.getPixels();
        int n = sourcePixels.length;
        float[] maskPixels = (float[])mask.getPixels();
        for (int i = 0; i < n; ++i) {
            int sourcePixel = sourcePixels[i] & 0xFFFFFF;
            maskPixels[i] = sourcePixel == 65280 ? 0.0f : 1.0f;
        }
        return mask;
    }

    protected static final RealPointSampleList<ARGBType> matches2ColorSamples(Iterable<PointMatch> matches) {
        RealPointSampleList samples = new RealPointSampleList(2);
        for (PointMatch match : matches) {
            double[] p = match.getP1().getL();
            double[] q = match.getP2().getW();
            double dx = (q[0] - p[0]) / (double)searchRadius;
            double dy = (q[1] - p[1]) / (double)searchRadius;
            int rgb = Util.colorVector((double)dx, (double)dy);
            samples.add(new RealPoint(p), (Object)new ARGBType(rgb));
        }
        return samples;
    }

    protected static final RealPointSampleList<ARGBType> matches2ColorSamples2(Iterable<PointMatch> matches) {
        RealPointSampleList samples = new RealPointSampleList(2);
        for (PointMatch match : matches) {
            double[] p = match.getP1().getL();
            double[] q = match.getP2().getW();
            double dx = (q[0] - p[0]) / (double)searchRadius;
            double dy = (q[1] - p[1]) / (double)searchRadius;
            int rgb = Util.colorVector((double)dx, (double)dy);
            samples.add(new RealPoint(q), (Object)new ARGBType(rgb));
        }
        return samples;
    }

    protected static final <T extends Type<T>> long drawNearestNeighbor(IterableInterval<T> target, NearestNeighborSearch<T> nnSearchSamples, NearestNeighborSearch<T> nnSearchMask) {
        Timer timer = new Timer();
        timer.start();
        Cursor c = target.localizingCursor();
        while (c.hasNext()) {
            c.fwd();
            nnSearchSamples.search((RealLocalizable)c);
            nnSearchMask.search((RealLocalizable)c);
            if (nnSearchSamples.getSquareDistance() <= nnSearchMask.getSquareDistance()) {
                ((Type)c.get()).set((Type)nnSearchSamples.getSampler().get());
                continue;
            }
            ((Type)c.get()).set((Type)nnSearchMask.getSampler().get());
        }
        return timer.stop();
    }
}

