/*
 * Decompiled with CFR 0.152.
 */
package ai;

import ai.BalancedRandomTree;
import java.util.concurrent.Callable;
import weka.core.Instances;
import weka.core.Utils;

public class VotesCollector
implements Callable<Double> {
    protected final BalancedRandomTree[] tree;
    protected final int instanceIdx;
    protected final Instances data;
    protected final boolean[][] inBag;

    public VotesCollector(BalancedRandomTree[] tree, int instanceIdx, Instances data, boolean[][] inBag) {
        this.tree = tree;
        this.instanceIdx = instanceIdx;
        this.data = data;
        this.inBag = inBag;
    }

    @Override
    public Double call() throws Exception {
        double[] classProbs = null;
        double regrValue = 0.0;
        classProbs = new double[this.data.numClasses()];
        for (int treeIdx = 0; treeIdx < this.tree.length; ++treeIdx) {
            if (this.inBag[treeIdx][this.instanceIdx]) continue;
            double[] curDist = this.tree[treeIdx].evaluate(this.data.instance(this.instanceIdx));
            for (int classIdx = 0; classIdx < curDist.length; ++classIdx) {
                int n = classIdx;
                classProbs[n] = classProbs[n] + curDist[classIdx];
            }
        }
        double vote = Utils.maxIndex((double[])classProbs);
        return vote;
    }
}

