/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation.metrics;

public class ClassificationStatistics {
    public double truePositives = 0.0;
    public double trueNegatives = 0.0;
    public double falsePositives = 0.0;
    public double falseNegatives = 0.0;
    public double metricValue = 0.0;
    public double precision = 0.0;
    public double recall = 0.0;
    public double fScore = 0.0;
    public double specificity = 0.0;

    public ClassificationStatistics(double truePositives, double trueNegatives, double falsePositives, double falseNegatives, double metricValue) {
        this.truePositives = truePositives;
        this.trueNegatives = trueNegatives;
        this.falsePositives = falsePositives;
        this.falseNegatives = falseNegatives;
        this.metricValue = metricValue;
        double totalNegatives = trueNegatives + falsePositives;
        this.specificity = totalNegatives > 0.0 ? trueNegatives / totalNegatives : 0.0;
        this.precision = falsePositives == 0.0 ? 1.0 : truePositives / (truePositives + falsePositives);
        this.recall = falseNegatives == 0.0 ? 1.0 : truePositives / (truePositives + falseNegatives);
        if (this.precision + this.recall > 0.0) {
            this.fScore = 2.0 * this.precision * this.recall / (this.precision + this.recall);
        }
    }
}

