/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.math;

import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.util.RealSum;

public class NormalizeImageFloat<T extends RealType<T>>
implements OutputAlgorithm<FloatType>,
Benchmark {
    private final Image<T> image;
    private Image<FloatType> outputImage = null;
    private String errorMsg = "";
    private long pTime = 0L;

    public static <T extends RealType<T>> double sumImage(Image<T> image) {
        RealSum sum = new RealSum();
        Cursor<T> cursor = image.createCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            sum.add((double)((RealType)cursor.getType()).getRealFloat());
        }
        cursor.close();
        return sum.getSum();
    }

    public NormalizeImageFloat(Image<T> imageInput) {
        this.image = imageInput;
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        double norm = NormalizeImageFloat.sumImage(this.image);
        int[] dims = this.image.getDimensions();
        ImageFactory<FloatType> factory = new ImageFactory<FloatType>(new FloatType(), this.image.getContainerFactory());
        if (norm == 0.0) {
            this.errorMsg = "Zero Sum Image";
            return false;
        }
        this.outputImage = factory.createImage(dims);
        LocalizableByDimCursor<FloatType> pushCursor = this.outputImage.createLocalizableByDimCursor();
        LocalizableCursor<T> pullCursor = this.image.createLocalizableCursor();
        while (pullCursor.hasNext()) {
            pullCursor.fwd();
            pushCursor.setPosition(pullCursor);
            ((FloatType)pushCursor.getType()).set((float)((double)((RealType)pullCursor.getType()).getRealFloat() / norm));
        }
        this.pTime = System.currentTimeMillis() - startTime;
        pullCursor.close();
        pushCursor.close();
        return true;
    }

    @Override
    public Image<FloatType> getResult() {
        return this.outputImage;
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMsg;
    }

    @Override
    public long getProcessingTime() {
        return this.pTime;
    }
}

