/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.transformation;

import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.type.Type;
import mpicbg.models.AffineModel2D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.Boundable;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.RigidModel2D;
import mpicbg.models.TranslationModel2D;
import mpicbg.models.TranslationModel3D;

public class ImageTransform<T extends Type<T>>
implements OutputAlgorithm<T> {
    protected final InvertibleCoordinateTransform transform;
    protected final Boundable transformAsBoundable;
    protected final Image<T> img;
    protected final int numDimensions;
    protected InterpolatorFactory<T> interpolatorFactory;
    protected final boolean isAffine;
    ImageFactory<T> outputImageFactory;
    final int[] newDim;
    final float[] offset;
    Image<T> transformed;
    String errorMessage = "";

    public <BT extends InvertibleCoordinateTransform & Boundable> ImageTransform(Image<T> img, BT transform, InterpolatorFactory<T> interpolatorFactory) {
        this.img = img;
        this.interpolatorFactory = interpolatorFactory;
        this.numDimensions = img.getNumDimensions();
        this.transform = transform;
        this.transformAsBoundable = transform;
        this.outputImageFactory = img.getImageFactory();
        this.isAffine = transform instanceof AffineModel3D || transform instanceof AffineModel2D || transform instanceof TranslationModel3D || transform instanceof TranslationModel2D || transform instanceof RigidModel2D;
        int[] dimensions = img.getDimensions();
        double[] min = new double[this.numDimensions];
        double[] max = new double[this.numDimensions];
        for (int i = 0; i < this.numDimensions; ++i) {
            max[i] = dimensions[i] - 1;
        }
        this.transformAsBoundable.estimateBounds(min, max);
        this.offset = new float[this.numDimensions];
        this.newDim = new int[this.numDimensions];
        for (int d = 0; d < this.numDimensions; ++d) {
            this.newDim[d] = (int)(max[d] - min[d] + 1.0);
            this.offset[d] = (float)min[d];
        }
    }

    public void setOutputImageFactory(ImageFactory<T> outputImageFactory) {
        this.outputImageFactory = outputImageFactory;
    }

    public void setInterpolatorFactory(InterpolatorFactory<T> interpolatorFactory) {
        this.interpolatorFactory = interpolatorFactory;
    }

    public ImageFactory<T> getOutputImageFactory() {
        return this.outputImageFactory;
    }

    public float[] getOffset() {
        return (float[])this.offset.clone();
    }

    public float getOffset(int dim) {
        return this.offset[dim];
    }

    public void setOffset(int dim, int size) {
        this.offset[dim] = size;
    }

    public void setOffset(float[] offset) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.offset[d] = offset[d];
        }
    }

    public InterpolatorFactory<T> getInterpolatorFactory() {
        return this.interpolatorFactory;
    }

    public int[] getNewImageSize() {
        return (int[])this.newDim.clone();
    }

    public float getNewImageSize(int dim) {
        return this.newDim[dim];
    }

    public void setNewImageSize(int dim, int size) {
        this.newDim[dim] = size;
    }

    public void setNewImageSize(int[] newDim) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.newDim[d] = newDim[d];
        }
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.img == null) {
            this.errorMessage = "AffineTransform: [Image<T> img] is null.";
            return false;
        }
        if (this.interpolatorFactory.getOutOfBoundsStrategyFactory() == null) {
            this.errorMessage = "AffineTransform: [OutOfBoundsStrategyFactory<T> of interpolatorFactory] is null.";
            return false;
        }
        if (this.interpolatorFactory == null) {
            this.errorMessage = "AffineTransform: [InterpolatorFactory<T> interpolatorFactory] is null.";
            return false;
        }
        if (this.transform == null) {
            this.errorMessage = "AffineTransform: [Transform3D transform] or [float[] transform] is null.";
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public Image<T> getResult() {
        return this.transformed;
    }

    @Override
    public boolean process() {
        if (!this.checkInput()) {
            return false;
        }
        this.transformed = this.outputImageFactory.createImage(this.newDim);
        LocalizableCursor<T> transformedIterator = this.transformed.createLocalizableCursor();
        Interpolator<T> interpolator = this.img.createInterpolator(this.interpolatorFactory);
        try {
            double[] tmp = new double[this.numDimensions];
            while (transformedIterator.hasNext()) {
                transformedIterator.fwd();
                for (int d = 0; d < this.numDimensions; ++d) {
                    tmp[d] = (float)transformedIterator.getPosition(d) + this.offset[d];
                }
                this.transform.applyInverseInPlace(tmp);
                interpolator.moveTo(tmp);
                transformedIterator.getType().set(interpolator.getType());
            }
        }
        catch (NoninvertibleModelException e) {
            transformedIterator.close();
            interpolator.close();
            this.transformed.close();
            this.errorMessage = "ImageTransform.process(): " + e.getMessage();
            return false;
        }
        transformedIterator.close();
        interpolator.close();
        return true;
    }
}

