/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.dynamic;

import mpicbg.imglib.container.dynamic.DynamicContainer;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.dynamic.DynamicLocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategy;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

public class DynamicLocalizableByDimOutOfBoundsCursor<T extends Type<T>>
extends DynamicLocalizableByDimCursor<T>
implements LocalizableByDimCursor<T> {
    final OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory;
    final OutOfBoundsStrategy<T> outOfBoundsStrategy;
    boolean isOutOfBounds = false;

    public DynamicLocalizableByDimOutOfBoundsCursor(DynamicContainer<T, ?> container, Image<T> image, T type, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(container, image, type);
        this.outOfBoundsStrategyFactory = outOfBoundsStrategyFactory;
        this.outOfBoundsStrategy = outOfBoundsStrategyFactory.createStrategy(this);
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return !this.isOutOfBounds && this.internalIndex < this.container.getNumPixels() - 1;
    }

    @Override
    public void reset() {
        if (this.outOfBoundsStrategy == null) {
            return;
        }
        this.isOutOfBounds = false;
        this.type.updateIndex(0);
        this.internalIndex = 0;
        this.type.updateContainer(this);
        this.accessor.updateIndex(this.internalIndex);
        this.internalIndex = -1;
        this.isClosed = false;
        this.position[0] = -1;
        for (int d = 1; d < this.numDimensions; ++d) {
            this.position[d] = 0;
        }
    }

    @Override
    public T getType() {
        if (this.isOutOfBounds) {
            return this.outOfBoundsStrategy.getType();
        }
        return (T)this.type;
    }

    @Override
    public void fwd() {
        if (!this.isOutOfBounds) {
            ++this.internalIndex;
            this.accessor.updateIndex(this.internalIndex);
            for (int d = 0; d < this.numDimensions; ++d) {
                if (this.position[d] >= this.dimensions[d] - 1) continue;
                int n = d;
                this.position[n] = this.position[n] + 1;
                for (int e = 0; e < d; ++e) {
                    this.position[e] = 0;
                }
                return;
            }
            this.isOutOfBounds = true;
            this.position[0] = this.position[0] + 1;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void fwd(int dim) {
        int n = dim;
        this.position[n] = this.position[n] + 1;
        if (this.isOutOfBounds) {
            if (this.position[dim] == 0) {
                this.setPosition(this.position);
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOundsFwd(dim);
            }
        } else if (this.position[dim] < this.dimensions[dim]) {
            this.internalIndex += this.step[dim];
            this.accessor.updateIndex(this.internalIndex);
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void move(int steps, int dim) {
        int n = dim;
        this.position[n] = this.position[n] + steps;
        if (this.isOutOfBounds) {
            if (this.position[dim] >= 0 && this.position[dim] < this.dimensions[dim]) {
                this.isOutOfBounds = false;
                for (int d = 0; d < this.numDimensions && !this.isOutOfBounds; ++d) {
                    if (this.position[d] >= 0 && this.position[d] < this.dimensions[d]) continue;
                    this.isOutOfBounds = true;
                }
                if (!this.isOutOfBounds) {
                    this.internalIndex = this.container.getPos(this.position);
                    this.accessor.updateIndex(this.internalIndex);
                } else {
                    this.outOfBoundsStrategy.notifyOutOfBOunds(steps, dim);
                }
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOunds(steps, dim);
            }
        } else if (this.position[dim] >= 0 && this.position[dim] < this.dimensions[dim]) {
            this.internalIndex += this.step[dim] * steps;
            this.accessor.updateIndex(this.internalIndex);
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void bck(int dim) {
        int n = dim;
        this.position[n] = this.position[n] - 1;
        if (this.isOutOfBounds) {
            if (this.position[dim] == this.dimensions[dim] - 1) {
                this.setPosition(this.position);
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOundsBck(dim);
            }
        } else if (this.position[dim] > -1) {
            this.internalIndex -= this.step[dim];
            this.accessor.updateIndex(this.internalIndex);
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void setPosition(int[] position) {
        boolean wasOutOfBounds = this.isOutOfBounds;
        this.isOutOfBounds = false;
        for (int d = 0; d < this.numDimensions; ++d) {
            this.position[d] = position[d];
            if (position[d] >= 0 && position[d] < this.dimensions[d]) continue;
            this.isOutOfBounds = true;
        }
        if (this.isOutOfBounds) {
            if (wasOutOfBounds) {
                this.outOfBoundsStrategy.notifyOutOfBOunds();
            } else {
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        } else {
            this.internalIndex = this.container.getPos(position);
            this.accessor.updateIndex(this.internalIndex);
        }
    }

    @Override
    public void setPosition(int position, int dim) {
        this.position[dim] = position;
        if (this.isOutOfBounds || this.internalIndex == -1) {
            this.setPosition(this.position);
        } else if (position < 0 || position >= this.dimensions[dim]) {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        } else {
            this.internalIndex = this.container.getPos(this.position);
            this.accessor.updateIndex(this.internalIndex);
        }
    }
}

