/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import org.scijava.ui.behaviour.util.RunnableAction;
import sc.fiji.labkit.ui.brush.FloodFillController;
import sc.fiji.labkit.ui.brush.LabelBrushController;
import sc.fiji.labkit.ui.brush.PlanarModeController;
import sc.fiji.labkit.ui.brush.SelectLabelController;

public class LabelToolsPanel
extends JPanel {
    private static final Color OPTIONS_BORDER = new Color(220, 220, 220);
    private static final Color OPTIONS_BACKGROUND = new Color(230, 230, 230);
    private static final String MOVE_TOOL_TIP = "<html><b>Move</b><br><small>Keyboard shortcuts:<br>- <b>Left Click</b> on the image and drag, to rotate the image.<br>- <b>Right Click</b> on the image, to move around.<br>- <b>Ctrl + Shift + Mouse Wheel</b> to zoom in and out.<br>- <b>Mouse Wheel</b> only, to scroll through a 3d image.<br>- Press <b>Ctrl + G</b> to deactivate drawing tools and activate this mode.</small></html>";
    private static final String DRAW_TOOL_TIP = "<html><b>Draw</b><br><small>Keyboard shortcuts:<br>- Hold down the <b>D</b> key and <b>Left Click</b> on the image to draw.<br>- Hold down the <b>D</b> key and use the <b>Mouse Wheel</b> to change the brush diameter.<br>- Or press <b>Ctrl + D</b> to activate the drawing tool.</small></html>";
    private static final String ERASE_TOOL_TIP = "<html><b>Erase</b><br><small>Keyboard shortcuts:<br>- Hold down the <b>E</b> key and <b>Left Click</b> on the image to erase.<br>- Hold down the <b>E</b> key and use the <b>Mouse Wheel</b> to change the brush diameter.<br>- Or press <b>Ctrl + E</b> to activate the eraser tool.</small></html>";
    private static final String FLOOD_FILL_TOOL_TIP = "<html><b>Flood Fill</b><br><small>Keyboard shortcuts:<br>- Hold down the <b>F</b> key and <b>Left Click</b> on the image to flood fill.<br>- Or press <b>Ctrl + F</b> to activate the flood fill tool.</small></html>";
    private static final String FLOOD_ERASE_TOOL_TIP = "<html><b>Remove Connected Component</b><br><small>Keyboard shortcuts:<br>- Hold down the <b>R</b> key and <b>Left Click</b> on the image to remove connected component.<br>- Or press <b>Ctrl + R</b> to activate the remove connected component tool.</small></html>";
    private static final String SELECT_LABEL_TOOL_TIP = "<html><b>Select Label</b><br><small>Keyboard shortcuts:<br>- Hold down the <b>Shift</b> key and <b>Left Click</b> on the image<br>  to select the label under the cursor.</small></html>";
    private final FloodFillController floodFillController;
    private final LabelBrushController brushController;
    private final SelectLabelController selectLabelController;
    private final PlanarModeController planarModeController;
    private JPanel brushOptionsPanel;
    private final ButtonGroup group = new ButtonGroup();
    private Mode mode = ignore -> {};

    public LabelToolsPanel(LabelBrushController brushController, FloodFillController floodFillController, SelectLabelController selectLabelController, PlanarModeController planarModeController) {
        this.brushController = brushController;
        this.floodFillController = floodFillController;
        this.selectLabelController = selectLabelController;
        this.planarModeController = planarModeController;
        this.setLayout((LayoutManager)new MigLayout("flowy, insets 0, gap 4pt, top", "[][][][][]", "[]push"));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        this.initActionButtons();
        this.add((Component)this.initOptionPanel(), "wrap, growy");
        this.add((Component)this.initPlanarModeButton(), "growy");
    }

    private void setMode(Mode mode) {
        this.mode.setActive(false);
        this.mode = mode;
        this.mode.setActive(true);
    }

    private void setVisibility(boolean brushVisible) {
        if (this.brushOptionsPanel != null) {
            this.brushOptionsPanel.setVisible(brushVisible);
        }
    }

    private void initActionButtons() {
        JToggleButton moveBtn = this.addActionButton(MOVE_TOOL_TIP, ignore -> {}, false, "/images/move.png", "MOVE_TOOL", "ctrl G");
        this.addActionButton(DRAW_TOOL_TIP, this.brushController::setBrushActive, true, "/images/draw.png", "DRAW_TOOL", "ctrl D");
        this.addActionButton(FLOOD_FILL_TOOL_TIP, this.floodFillController::setFloodFillActive, false, "/images/fill.png", "FILL_TOOL", "ctrl F");
        this.addActionButton(ERASE_TOOL_TIP, this.brushController::setEraserActive, true, "/images/erase.png", "ERASE_TOOL", "ctrl E");
        this.addActionButton(FLOOD_ERASE_TOOL_TIP, this.floodFillController::setRemoveBlobActive, false, "/images/flooderase.png", "FLOOD_ERASE_TOOL", "ctrl R");
        this.addActionButton(SELECT_LABEL_TOOL_TIP, this.selectLabelController::setActive, false, "/images/pipette.png");
        moveBtn.doClick();
    }

    private JPanel initOptionPanel() {
        JPanel optionPane = new JPanel();
        optionPane.setLayout((LayoutManager)new MigLayout("insets 0"));
        optionPane.add(this.initOverrideCheckBox());
        optionPane.add((Component)this.initBrushOptionPanel(), "al left");
        optionPane.setBackground(OPTIONS_BACKGROUND);
        optionPane.setBorder(BorderFactory.createLineBorder(OPTIONS_BORDER));
        return optionPane;
    }

    private JToggleButton initPlanarModeButton() {
        JToggleButton button = new JToggleButton();
        ImageIcon rotateIcon = this.getIcon("/images/rotate.png");
        ImageIcon planarIcon = this.getIcon("/images/planes.png");
        button.setIcon(rotateIcon);
        button.setFocusable(false);
        String ENABLE_TEXT = "Click to: Enable slice by slice editing of 3d images.";
        String DISABLE_TEXT = "Click to: Disable slice by slice editing and freely rotate 3d images.";
        button.addActionListener(ignore -> {
            boolean selected = button.isSelected();
            button.setIcon(selected ? planarIcon : rotateIcon);
            button.setToolTipText(selected ? DISABLE_TEXT : ENABLE_TEXT);
            this.planarModeController.setActive(selected);
            this.floodFillController.setPlanarMode(selected);
            this.brushController.setPlanarMode(selected);
        });
        button.setToolTipText(ENABLE_TEXT);
        return button;
    }

    private JToggleButton addActionButton(String toolTipText, Mode mode, boolean visibility, String iconPath, String activationKey, String key) {
        JToggleButton button = this.addActionButton(toolTipText, mode, visibility, iconPath);
        button.getInputMap(2).put(KeyStroke.getKeyStroke(key), activationKey);
        button.getActionMap().put(activationKey, new RunnableAction(activationKey, button::doClick));
        return button;
    }

    private JToggleButton addActionButton(String toolTipText, Mode mode, boolean visibility, String iconPath) {
        JToggleButton button = new JToggleButton();
        button.setIcon(this.getIcon(iconPath));
        button.setToolTipText(toolTipText);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setFocusable(false);
        button.addItemListener(ev -> {
            if (ev.getStateChange() == 1) {
                this.setMode(mode);
                this.setVisibility(visibility);
            }
        });
        this.group.add(button);
        this.add((Component)button, "wrap, top");
        return button;
    }

    private ImageIcon getIcon(String iconPath) {
        return new ImageIcon(this.getClass().getResource(iconPath));
    }

    private JPanel initBrushOptionPanel() {
        this.brushOptionsPanel = new JPanel();
        this.brushOptionsPanel.setLayout((LayoutManager)new MigLayout("insets 4pt, gap 2pt, wmax 300"));
        this.brushOptionsPanel.setOpaque(false);
        this.brushOptionsPanel.add((Component)new JLabel("Brush size:"), "grow");
        JSlider brushSizeSlider = this.initBrushSizeSlider();
        this.brushOptionsPanel.add((Component)brushSizeSlider, "grow");
        this.brushOptionsPanel.add((Component)this.initSliderValueLabel(brushSizeSlider), "right");
        return this.brushOptionsPanel;
    }

    private JCheckBox initOverrideCheckBox() {
        JCheckBox checkBox = new JCheckBox("allow overlapping labels");
        checkBox.setOpaque(false);
        checkBox.addItemListener(action -> {
            boolean overlapping = action.getStateChange() == 1;
            this.brushController.setOverlapping(overlapping);
            this.floodFillController.setOverlapping(overlapping);
        });
        return checkBox;
    }

    private JSlider initBrushSizeSlider() {
        JSlider brushSize = new JSlider(1, 50, (int)this.brushController.getBrushDiameter());
        brushSize.setFocusable(false);
        brushSize.setPaintTrack(true);
        brushSize.addChangeListener(e -> this.brushController.setBrushDiameter(brushSize.getValue()));
        brushSize.setOpaque(false);
        this.brushController.brushDiameterListeners().addListener(() -> {
            double diameter = this.brushController.getBrushDiameter();
            brushSize.setValue((int)diameter);
        });
        return brushSize;
    }

    private JLabel initSliderValueLabel(JSlider brushSize) {
        JLabel valLabel = new JLabel(String.valueOf(brushSize.getValue()));
        brushSize.addChangeListener(e -> valLabel.setText(String.valueOf(brushSize.getValue())));
        return valLabel;
    }

    private static interface Mode {
        public void setActive(boolean var1);
    }
}

