/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.scripts;

import bigwarp.transforms.NgffTransformations;
import java.util.concurrent.Callable;
import java.util.stream.IntStream;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultAxisType;
import net.imagej.axis.DefaultLinearAxis;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.imglib2.N5DisplacementField;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.janelia.saalfeldlab.n5.universe.N5Factory;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.CoordinateSystem;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.TransformUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransform;
import org.scijava.command.Command;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.UIService;

@Plugin(type=Command.class, menuPath="Plugins>Transform>Read Displacement Field")
public class ReadDisplacementField
implements Callable<Void>,
Command {
    public static final String NATIVE = "NATIVE";
    public static final String[] AXIS_LABELS = new String[]{"x", "y", "z"};
    @Parameter
    private UIService ui;
    @Parameter
    private DatasetService ds;
    @Parameter
    private LogService log;
    @Parameter
    private String n5Root;
    @Parameter
    private String n5Dataset;
    @Parameter(label="Thread count", required=true, min="1", max="999")
    private int nThreads = 1;
    private CalibratedAxis[] axes;
    private Axis[] csAxes;

    public void run() {
        this.call();
    }

    @Override
    public Void call() {
        this.process();
        return null;
    }

    public <T extends RealType<T> & NativeType<T>> void process() {
        RandomAccessibleInterval<T> dfieldRai = this.readDataAndMetadata();
        Dataset dataset = this.ds.create(dfieldRai);
        dataset.setName(this.n5Dataset);
        dataset.setAxes(this.axes);
        this.ui.show((Object)dataset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> readDataAndMetadata() {
        try (N5Reader n5 = new N5Factory().gsonBuilder(NgffTransformations.gsonBuilder()).openReader(this.n5Root);){
            if (this.isN5Field(n5, this.n5Dataset)) {
                RandomAccessibleInterval<T> randomAccessibleInterval = this.readN5(n5, this.n5Dataset);
                return randomAccessibleInterval;
            }
            if (!this.isNgffField(n5, this.n5Dataset)) throw new N5Exception("Could not read displacement field from: " + this.n5Root + "  " + this.n5Dataset);
            RandomAccessibleInterval<T> randomAccessibleInterval = this.readNgff(n5, this.n5Dataset);
            return randomAccessibleInterval;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new N5Exception("Could not read displacement field from: " + this.n5Root + "  " + this.n5Dataset);
    }

    private boolean isN5Field(N5Reader n5, String n5Dataset) {
        return n5.getAttribute(n5Dataset, "spacing", double[].class) != null;
    }

    private <Q extends RealType<Q> & NativeType<Q>, T extends RealType<T>> RandomAccessibleInterval<T> readN5(N5Reader n5, String n5Dataset) {
        RandomAccessibleInterval imgp;
        this.createAxesN5(n5, n5Dataset);
        DataType type = n5.getDatasetAttributes(n5Dataset).getDataType();
        boolean isQuantized = type != DataType.FLOAT64 && type != DataType.FLOAT32;
        RandomAccessibleInterval img = isQuantized ? N5DisplacementField.openQuantized((N5Reader)n5, (String)n5Dataset, (RealType)((RealType)N5Utils.type((DataType)type)), (RealType)new FloatType()) : N5DisplacementField.openRaw((N5Reader)n5, (String)n5Dataset, (RealType)new FloatType());
        int nd = img.numDimensions();
        if (nd == 4) {
            imgp = Views.moveAxis((RandomAccessibleInterval)img, (int)(nd - 2), (int)(nd - 1));
        } else if (nd == 3) {
            imgp = img;
        } else {
            throw new N5Exception("Dataset must be 3D or 4D, but had " + nd + " dimensions");
        }
        return imgp;
    }

    private <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> readNgff(N5Reader n5, String n5Dataset) {
        this.createAxesNgff(n5, n5Dataset);
        CachedCellImg img = N5Utils.open((N5Reader)n5, (String)n5Dataset);
        int nd = img.numDimensions();
        int[] p = IntStream.range(0, nd).toArray();
        p[0] = 2;
        p[2] = 0;
        AxisUtils.permute((Object[])this.axes, (Object[])this.axes, (int[])p);
        return Views.moveAxis((RandomAccessibleInterval)img, (int)0, (int)2);
    }

    private CalibratedAxis[] createAxesN5(N5Reader n5, String n5Dataset) {
        DatasetAttributes dsetAttrs = n5.getDatasetAttributes(n5Dataset);
        if (dsetAttrs == null) {
            throw new N5Exception("No dataset at" + n5Dataset);
        }
        double[] spacing = (double[])n5.getAttribute(n5Dataset, "spacing", double[].class);
        double[] offset = (double[])n5.getAttribute(n5Dataset, "offset", double[].class);
        int nd = dsetAttrs.getNumDimensions();
        this.axes = new CalibratedAxis[nd];
        int j = 0;
        for (int i = 0; i < nd; ++i) {
            if (i == 2) {
                this.axes[i] = new DefaultLinearAxis((AxisType)new DefaultAxisType("v", false), "px");
                continue;
            }
            this.axes[i] = new DefaultLinearAxis((AxisType)new DefaultAxisType(AXIS_LABELS[j], true), "px", spacing[j], offset[j]);
            ++j;
        }
        return this.axes;
    }

    private boolean isNgffField(N5Reader n5, String n5Dataset) {
        return n5.getAttribute(n5Dataset, "coordinateTransformations", CoordinateTransform[].class) != null;
    }

    private CalibratedAxis[] createAxesNgff(N5Reader n5, String n5Dataset) {
        CoordinateTransform[] cts = (CoordinateTransform[])n5.getAttribute(n5Dataset, "coordinateTransformations", CoordinateTransform[].class);
        CoordinateSystem[] css = (CoordinateSystem[])n5.getAttribute(n5Dataset, "coordinateSystems", CoordinateSystem[].class);
        this.csAxes = css[0].getAxes();
        AffineGet affine = TransformUtils.toAffine((CoordinateTransform)cts[0], (int)this.csAxes.length);
        int nd = this.csAxes.length;
        this.axes = new CalibratedAxis[nd];
        for (int i = 0; i < nd; ++i) {
            Axis csAxis = this.csAxes[i];
            this.axes[i] = csAxis.getType().equals("displacement") ? new DefaultLinearAxis((AxisType)new DefaultAxisType("v", false), "px") : new DefaultLinearAxis((AxisType)new DefaultAxisType(csAxis.getName(), true), csAxis.getUnit(), affine.get(i, i), affine.get(i, nd));
        }
        return this.axes;
    }
}

