/*
 * Decompiled with CFR 0.152.
 */
package nrrd;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Formatter;
import nrrd.NrrdAxisInfo;
import nrrd.NrrdHeader;

public class NrrdInfo {
    NrrdHeader nh;
    public static final int NRRD_DIM_MAX = 16;
    public static final int NRRD_SPACE_DIM_MAX = 8;
    public static final int NRRD_UNKNOWN = -1;
    public static final int NRRD_FALSE = 0;
    public static final int NRRD_TRUE = 1;
    public static final int NRRD_BIG_ENDIAN = 4321;
    public static final int NRRD_LITTLE_ENDIAN = 1234;
    String type;
    String encoding;
    int dim = -1;
    long[] sizes;
    long nsamples;
    long nbytes;
    int endian = -1;
    int lineSkip = 0;
    long byteSkip = 0L;
    boolean detachedHeader;
    public String primaryFileDirectory = null;
    public String primaryFileName = null;
    public File[] dataFiles = null;
    Object data;
    NrrdAxisInfo[] nai;
    String content;
    String sampleUnits;
    String contentType;
    String space;
    int spaceDim;
    String[] spaceUnits;
    double[] spaceOrigin;
    double[][] measurementFrame;
    double oldMin;
    double oldMax;
    private double[] spacings;
    private double[] thicknesses;
    private double[] axismins;
    private double[] axismaxs;
    private String[] centers;
    private String[] labels;
    private String[] kinds;
    private String[] units;
    private int dataFileSubDim = -1;
    private long dataFileByteSize;
    public static final String[] int8Types = new String[]{"char", "int8", "int8_t", "signed char"};
    public static final String[] uint8Types = new String[]{"uchar", "uint8", "uint8_t", "unsigned char"};
    public static final String[] int16Types = new String[]{"int16", "int16_t", "short", "short int", "signed short", "signed short int"};
    public static final String[] uint16Types = new String[]{"uint16", "uint16_t", "unsigned short", "unsigned short int", "ushort"};
    public static final String[] int32Types = new String[]{"int", "int32", "int32_t", "signed int"};
    public static final String[] uint32Types = new String[]{"uint", "uint32", "uint32_t", "unsigned int"};
    public static final String[] int64Types = new String[]{"int64", "int64_t", "long long", "long long int", "longlong", "signed long long", "signed long long int"};
    public static final String[] uint64Types = new String[]{"uint64", "uint64_t", "ulonglong", "unsigned long long", "unsigned long long int"};

    public NrrdInfo(NrrdHeader nh) {
        this.nh = nh;
    }

    public void parseHeader() throws Exception {
        try {
            String[] sa;
            long[] la;
            int[] ia;
            this.encoding = this.getStandardEncoding(this.getStringFieldChecked("encoding", 1, true)[0]);
            if (this.encoding == null) {
                throw new Exception("Unknown encoding: " + this.getStringField("type"));
            }
            this.type = this.getStandardType(this.getStringFieldChecked("type", 1, true)[0]);
            if (this.type == null) {
                throw new Exception("Unknown data type: " + this.getStringField("type"));
            }
            this.dim = this.getIntegerFieldChecked("dimension", 1, true)[0];
            if (this.dim < 1 || this.dim > 16) {
                throw new Exception("dim out of range:" + this.dim);
            }
            this.sizes = this.getLongFieldChecked("sizes", this.dim, true);
            int byteSize = this.type.equals("block") ? this.getIntegerFieldChecked("block size", 1, true)[0] : this.getByteSize(this.type);
            if (byteSize < 1) {
                throw new Exception("Inferred byte size less than 1; check type or block size specification");
            }
            this.nsamples = this.sizes[0];
            for (int i = 1; i < this.dim; ++i) {
                this.nsamples *= this.sizes[i];
            }
            if (this.nsamples < 1L) {
                throw new Exception("Invalid number of samples: " + this.nsamples + "; check sizes field");
            }
            this.nbytes = this.nsamples * (long)byteSize;
            if (!this.type.equals("block") && !this.encoding.equals("txt") && byteSize > 1) {
                String endianStr = this.getStringFieldChecked("endian", 1, true)[0];
                if (endianStr.equals("little")) {
                    this.endian = 1234;
                } else if (endianStr.equals("big")) {
                    this.endian = 4321;
                } else {
                    throw new Exception("Unknown endian specification: " + endianStr);
                }
            }
            if ((ia = this.getIntegerFieldChecked("line skip", 1, false)) != null) {
                this.lineSkip = ia[0];
            }
            if ((la = this.getLongFieldChecked("byte skip", 1, false)) != null) {
                this.byteSkip = la[0];
            }
            this.primaryFileDirectory = this.nh.directory;
            this.primaryFileName = this.nh.filename;
            if (this.nh.detachedHeader) {
                int i;
                String[] df = this.getStringField("data file");
                if (df == null) {
                    throw new Exception("Supposed to be a detached header file, but no data file field");
                }
                if (df.length == 1 || df.length == 2) {
                    if (df[0].equals("LIST")) {
                        if (this.nh.dataFiles == null || this.nh.dataFiles.size() == 0) {
                            throw new Exception("No data files listed after data file LIST line");
                        }
                        this.dataFileSubDim = df.length == 2 ? new Integer(df[1]) : this.dim - 1;
                        this.dataFiles = new File[this.nh.dataFiles.size()];
                        for (i = 0; i < this.dataFiles.length; ++i) {
                            this.dataFiles[i] = this.makeCheckedFile((String)this.nh.dataFiles.get(i));
                        }
                    } else {
                        this.dataFiles = new File[1];
                        this.dataFiles[0] = this.makeCheckedFile(df[0]);
                    }
                } else {
                    int dataFNStep;
                    int dataFNMax;
                    int dataFNMin;
                    String dataFNFormat = df[0];
                    try {
                        dataFNMin = new Integer(df[1]);
                        dataFNMax = new Integer(df[2]);
                        dataFNStep = new Integer(df[3]);
                        this.dataFileSubDim = df.length == 5 ? new Integer(df[4]) : this.dim - 1;
                    }
                    catch (NumberFormatException e) {
                        throw new Exception("Could not parse data file field; expected data file: <format> <min> <max> <step> [<subdim>]");
                    }
                    int numFiles = 1 + (dataFNMax - dataFNMin) / dataFNStep;
                    int num = dataFNMin;
                    this.dataFiles = new File[numFiles];
                    try {
                        for (int i2 = 0; i2 < numFiles; ++i2) {
                            Formatter formatter = new Formatter();
                            Formatter f = formatter.format(dataFNFormat, num);
                            this.dataFiles[i2] = this.makeCheckedFile(f.toString());
                            num += dataFNStep;
                            f.close();
                            formatter.close();
                        }
                    }
                    catch (IOException e) {
                        throw new IOException("Unable to find data files referred to by data file field");
                    }
                    catch (Exception e) {
                        throw new Exception("Unable to process format specifier data file fields with Java<1.5");
                    }
                }
                if (this.dataFileSubDim != -1) {
                    if (this.dataFileSubDim < 1 || this.dataFileSubDim > this.dim) {
                        throw new Exception("Detached header subdim specification must be in range [1," + this.dim + "]");
                    }
                    if (this.dataFileSubDim == this.dim) {
                        if ((long)this.dataFiles.length % this.nsamples != 0L) {
                            throw new Exception("Number of slabs indicated by \"data file\" (" + this.dataFiles.length + ") does not divide evenly into number of samples (" + this.nsamples + ")");
                        }
                        this.dataFileByteSize = this.nbytes / (long)this.dataFiles.length;
                    } else if (this.dataFileSubDim < this.dim - 1) {
                        i = this.dim - 1;
                        int nFiles = (int)this.sizes[i];
                        while (i >= this.dataFileSubDim) {
                            nFiles = (int)((long)nFiles * this.sizes[i]);
                        }
                        if (nFiles != this.dataFiles.length) {
                            throw new Exception("Number of data files indicated by \"data file\" (" + this.dataFiles.length + ") does not match product of dimension sizes >" + this.dataFileSubDim + " (ie " + nFiles + ")");
                        }
                    } else if (this.dataFiles.length > 1 && (long)this.dataFiles.length != this.sizes[this.dim - 1]) {
                        throw new Exception("Number of data files indicated by \"data file\" (" + this.dataFiles.length + ") does not match final dimension size " + this.sizes[this.dim - 1]);
                    }
                }
            }
            if ((sa = this.getStringFieldChecked("space", 1, false)) != null) {
                this.processSpace(sa[0]);
            }
            if (this.spaceDim < 1 && (ia = this.getIntegerFieldChecked("space dimension", 1, false)) != null) {
                this.spaceDim = ia[0];
            }
            String[] sd = null;
            if (this.spaceDim > 0) {
                sd = this.getStringFieldChecked("space directions", this.dim, true);
                this.spaceUnits = this.getStringFieldChecked("space units", this.spaceDim, false);
                sa = this.getStringFieldChecked("space origin", 1, false);
                if (sa != null) {
                    this.spaceOrigin = this.getVector(sa[0], this.spaceDim);
                }
                String[] mf = this.getStringFieldChecked("measurement frame", this.dim, false);
                this.processMeasurementFrame(mf);
            }
            this.spacings = this.getDoubleFieldChecked("spacings", this.dim, false);
            this.thicknesses = this.getDoubleFieldChecked("thicknesses", this.dim, false);
            this.axismins = this.getDoubleFieldChecked("axis mins", this.dim, false);
            this.axismaxs = this.getDoubleFieldChecked("axis maxs", this.dim, false);
            this.centers = this.getStringFieldChecked("centers", this.dim, false);
            this.labels = this.getStringFieldChecked("labels", this.dim, false);
            this.units = this.getStringFieldChecked("units", this.dim, false);
            this.kinds = this.getStringFieldChecked("kinds", this.dim, false);
            this.nai = new NrrdAxisInfo[this.dim];
            for (int i = 0; i < this.dim; ++i) {
                this.nai[i] = new NrrdAxisInfo();
                this.nai[i].size = this.sizes[i];
                if (sd != null) {
                    this.nai[i].setSpaceDirection(this.getVector(sd[i], this.spaceDim));
                }
                if (this.axismins != null) {
                    this.nai[i].setMin(this.axismins[i]);
                }
                if (this.axismaxs != null) {
                    this.nai[i].setMax(this.axismaxs[i]);
                }
                if (this.units != null) {
                    this.nai[i].setUnits(this.units[i]);
                }
                if (this.centers != null) {
                    this.nai[i].center = this.centers[i];
                }
                if (this.labels != null) {
                    this.nai[i].label = this.labels[i];
                }
                if (this.kinds == null) continue;
                this.nai[i].kind = this.kinds[i];
            }
        }
        catch (Exception e) {
            throw new Exception("nrrd: trouble parsing header for field: " + e);
        }
    }

    File makeCheckedFile(String path) throws IOException {
        File f = new File(path);
        if (f.getParent() == null) {
            f = new File(this.primaryFileDirectory, path);
        }
        if (!f.exists()) {
            throw new IOException("Unable to find file: " + path);
        }
        return f;
    }

    boolean processMeasurementFrame(String[] mf) throws Exception {
        if (mf == null) {
            return false;
        }
        this.measurementFrame = new double[this.spaceDim][this.spaceDim];
        try {
            for (int i = 0; i < this.spaceDim; ++i) {
                this.measurementFrame[i] = this.getVector(mf[i], this.spaceDim);
            }
        }
        catch (Exception e) {
            this.measurementFrame = null;
            throw new Exception("trouble parsing measurement frame:" + e);
        }
        return true;
    }

    double[] getVector(String vecStr, int vecLen) throws Exception {
        double[] da;
        if (vecStr.equals("none")) {
            return null;
        }
        if (vecStr.startsWith("(") && vecStr.endsWith(")")) {
            String[] sa = vecStr.substring(1, vecStr.length() - 1).split(",");
            if (vecLen != sa.length) {
                throw new Exception("Vector " + vecStr + " should have length: " + vecLen);
            }
            da = new double[vecLen];
            for (int i = 0; i < vecLen; ++i) {
                try {
                    if (sa[i].equals("nan")) {
                        da[i] = Double.NaN;
                        continue;
                    }
                    da[i] = new Double(sa[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new Exception("Can't parse component: " + sa[i] + " of vector: " + vecStr);
                }
            }
        } else {
            throw new Exception("String " + vecStr + " does not look like vector.");
        }
        return da;
    }

    int getByteSize(String stype) {
        if (stype.endsWith("int8")) {
            return 1;
        }
        if (stype.endsWith("int16")) {
            return 2;
        }
        if (stype.endsWith("int32") || stype.equals("float")) {
            return 4;
        }
        if (stype.endsWith("int64") || stype.equals("double")) {
            return 8;
        }
        return -1;
    }

    public String getStandardType(String stype) {
        if (stype.equals("float") || stype.equals("double") || stype.equals("block")) {
            return stype;
        }
        if (Arrays.binarySearch(int8Types, stype) >= 0) {
            return "int8";
        }
        if (Arrays.binarySearch(uint8Types, stype) >= 0) {
            return "uint8";
        }
        if (Arrays.binarySearch(int16Types, stype) >= 0) {
            return "int16";
        }
        if (Arrays.binarySearch(uint16Types, stype) >= 0) {
            return "uint16";
        }
        if (Arrays.binarySearch(int32Types, stype) >= 0) {
            return "int32";
        }
        if (Arrays.binarySearch(uint32Types, stype) >= 0) {
            return "uint32";
        }
        if (Arrays.binarySearch(int64Types, stype) >= 0) {
            return "int64";
        }
        if (Arrays.binarySearch(uint64Types, stype) >= 0) {
            return "uint64";
        }
        return null;
    }

    String getStandardEncoding(String senc) {
        if (senc.equals("raw") || senc.equals("hex")) {
            return senc;
        }
        if (senc.equals("txt") || senc.equals("text") || senc.equals("ascii")) {
            return "txt";
        }
        if (senc.equals("gz") || senc.equals("gzip")) {
            return "gz";
        }
        if (senc.equals("bz2") || senc.equals("bzip2")) {
            return "bz2";
        }
        return null;
    }

    boolean processSpace(String s) throws Exception {
        if (s == null) {
            return false;
        }
        if (s.equals("ras") || s.equals("right-anterior-superior")) {
            this.space = "right-anterior-superior";
            this.spaceDim = 3;
        } else if (s.equals("rast") || s.equals("right-anterior-superior-time")) {
            this.space = "right-anterior-superior-time";
            this.spaceDim = 4;
        } else if (s.equals("las") || s.equals("left-anterior-superior")) {
            this.space = "left-anterior-superior";
            this.spaceDim = 3;
        } else if (s.equals("last") || s.equals("left-anterior-superior-time")) {
            this.space = "left-anterior-superior-time";
            this.spaceDim = 4;
        } else if (s.equals("lps") || s.equals("left-posterior-superior")) {
            this.space = "left-posterior-superior";
            this.spaceDim = 3;
        } else if (s.equals("lpst") || s.equals("left-posterior-superior-time")) {
            this.space = "left-posterior-superior-time";
            this.spaceDim = 4;
        } else if (s.startsWith("scanner-xyz") || s.startsWith("3d-right-handed") || s.startsWith("3d-left-handed")) {
            this.space = s;
            this.spaceDim = s.endsWith("-time") ? 4 : 3;
        } else {
            throw new Exception("Unknown space: " + s);
        }
        return true;
    }

    public String[] getStringField(String key) {
        if (this.nh.fields.containsKey(key)) {
            return (String[])this.nh.fields.get(key);
        }
        return null;
    }

    public double[] getDoubleField(String key) {
        if (this.nh.fields.containsKey(key)) {
            String[] sa = (String[])this.nh.fields.get(key);
            double[] da = new double[sa.length];
            for (int i = 0; i < sa.length; ++i) {
                da[i] = sa[i].equals("nan") ? Double.NaN : new Double(sa[i]);
            }
            return da;
        }
        return null;
    }

    public long[] getLongField(String key) {
        if (this.nh.fields.containsKey(key)) {
            String[] sa = (String[])this.nh.fields.get(key);
            long[] la = new long[sa.length];
            for (int i = 0; i < sa.length; ++i) {
                la[i] = new Long(sa[i]);
            }
            return la;
        }
        return null;
    }

    public int[] getIntegerField(String key) {
        if (this.nh.fields.containsKey(key)) {
            String[] sa = (String[])this.nh.fields.get(key);
            int[] ia = new int[sa.length];
            for (int i = 0; i < sa.length; ++i) {
                ia[i] = new Integer(sa[i]);
            }
            return ia;
        }
        return null;
    }

    public String[] getStringFieldChecked(String key, int n, boolean required) throws Exception {
        String[] sa = this.getStringField(key);
        if (sa == null) {
            if (required) {
                throw new Exception("Required field: " + key + " is missing");
            }
            return null;
        }
        if (sa.length != n) {
            throw new Exception("Field: " + key + " must have exactly " + n + " values");
        }
        return sa;
    }

    public int[] getIntegerFieldChecked(String key, int n, boolean required) throws Exception {
        int[] ia = this.getIntegerField(key);
        if (ia == null) {
            if (required) {
                throw new Exception("Required field: " + key + " is missing");
            }
            return null;
        }
        if (ia.length != n) {
            throw new Exception("Field: " + key + " must have exactly " + n + " values");
        }
        return ia;
    }

    public long[] getLongFieldChecked(String key, int n, boolean required) throws Exception {
        long[] la = this.getLongField(key);
        if (la == null) {
            if (required) {
                throw new Exception("Required field: " + key + " is missing");
            }
            return null;
        }
        if (la != null && la.length != n) {
            throw new Exception("Field: " + key + " must have exactly " + n + " values");
        }
        return la;
    }

    public double[] getDoubleFieldChecked(String key, int n, boolean required) throws Exception {
        double[] da = this.getDoubleField(key);
        if (da == null) {
            if (required) {
                throw new Exception("Required field: " + key + " is missing");
            }
            return null;
        }
        if (da != null && da.length != n) {
            throw new Exception("Field: " + key + " must have exactly " + n + " values");
        }
        return da;
    }

    public static void main(String[] args) {
        System.out.println("Double nan " + new Double("NaN"));
    }
}

