/*
 * Decompiled with CFR 0.152.
 */
package vib.segment;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.ColorChooser;
import ij.gui.GenericDialog;
import java.awt.Canvas;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import vib.segment.CustomCanvas;

public class MaterialList
extends ScrollPane
implements ActionListener,
ItemListener {
    PopupMenu popup;
    ImagePlus labels;
    AmiraParameters params;
    CustomCanvas cc;
    Font font;
    int lineHeight;
    int lineWidth;
    List list;
    private boolean[] locked;
    MenuItem remove;
    MenuItem add;
    MenuItem rename;
    MenuItem color;
    CheckboxMenuItem lock;

    public MaterialList(CustomCanvas cc) {
        this.cc = cc;
        this.createPopup();
        this.font = new Font("Monospaced", 0, 12);
        this.lineHeight = this.font.getSize() + 1;
        this.lineWidth = 200;
        this.list = new List();
        this.add(this.list);
        this.locked = new boolean[0];
    }

    public MaterialList(ImagePlus ip, CustomCanvas cc) {
        this(cc);
        this.initFrom(ip);
    }

    public void releaseImage() {
        this.labels = null;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.list.setBackground(color);
    }

    private int getSelectedIndex() {
        return this.list.selectedIndex;
    }

    public void select(int index) {
        this.list.selectedIndex = index;
    }

    public int getItemCount() {
        return this.params.getMaterialCount();
    }

    public String getItem(int index) {
        return this.params.getMaterialName(index);
    }

    public String getSelectedItem() {
        return this.getItem(this.getSelectedIndex());
    }

    public int getIndexOf(String item) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!this.getItem(i).equals(item)) continue;
            return i;
        }
        return -1;
    }

    public void createPopup() {
        this.popup = new PopupMenu("");
        this.add = new MenuItem("Add Label");
        this.popup.add(this.add);
        this.remove = new MenuItem("Remove Label");
        this.rename = new MenuItem("Rename Label");
        this.popup.add(this.rename);
        this.color = new MenuItem("Change Color");
        this.popup.add(this.color);
        this.popup.addSeparator();
        this.lock = new CheckboxMenuItem("Locked");
        this.popup.add(this.lock);
        this.add.addActionListener(this);
        this.remove.addActionListener(this);
        this.rename.addActionListener(this);
        this.color.addActionListener(this);
        this.lock.addItemListener(this);
        this.add(this.popup);
    }

    public void initFrom(ImagePlus image) {
        this.labels = image;
        this.params = new AmiraParameters(image);
        if (this.params.getMaterialCount() == 0) {
            this.params.addMaterial("Exterior", 0.0, 0.0, 0.0);
            this.params.addMaterial("Interior", 1.0, 0.0, 0.0);
            this.params.setParameters(this.labels);
        }
        this.locked = new boolean[this.params.getMaterialCount()];
        if (this.list != null) {
            this.list.invalidate();
            this.list.repaint();
        }
        if (this.locked.length > 1) {
            this.select(1);
        }
    }

    public void setMaterials(String materials) {
        this.params = new AmiraParameters(materials);
        this.locked = new boolean[this.params.getMaterialCount()];
        if (this.list != null) {
            this.list.invalidate();
            this.list.repaint();
        }
    }

    public void addMaterial() {
        int num = this.getItemCount();
        this.params.addMaterial("Label" + ++num, 1.0, 0.0, 0.0);
        this.params.setParameters(this.labels);
        boolean[] newlocked = new boolean[num];
        System.arraycopy(this.locked, 0, newlocked, 0, this.locked.length);
        this.locked = newlocked;
        this.select(num - 1);
        this.doLayout();
        this.list.repaint();
    }

    public void delMaterial() {
        int selected = this.getSelectedIndex();
        if (selected < 1) {
            IJ.error((String)"Cannot delete first label!");
            return;
        }
        throw new RuntimeException("delete not yet implemented");
    }

    public void renameMaterial(String newName) {
        newName = newName.replace(' ', '_');
        this.params.editMaterial(this.currentMaterialID(), newName, -1.0, -1.0, -1.0);
        this.params.setParameters(this.labels);
        this.list.repaint();
    }

    private void renameMaterial() {
        GenericDialog gd = new GenericDialog("Rename");
        gd.addStringField("name", this.getSelectedItem());
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String newName = gd.getNextString();
        if (newName.indexOf(32) >= 0) {
            newName = newName.replace(' ', '_');
            IJ.showMessage((String)("Names cannot contain spaces; using '" + newName + "' instead!"));
        }
        this.renameMaterial(newName);
    }

    public void setColor(int r, int g, int b) {
        this.params.editMaterial(this.currentMaterialID(), null, (double)r / 255.0, (double)g / 255.0, (double)b / 255.0);
        this.params.setParameters(this.labels);
        this.labels.updateAndDraw();
        this.list.repaint();
        if (this.cc != null) {
            this.cc.setLabels(this.labels);
        }
    }

    private void setColor() {
        int id = this.currentMaterialID();
        double[] values = this.params.getMaterialColor(id);
        Color current = new Color((float)values[0], (float)values[1], (float)values[2]);
        String name = this.params.getMaterialName(id) + " Color";
        ColorChooser chooser = new ColorChooser(name, current, false);
        Color changed = chooser.getColor();
        if (changed != null) {
            this.setColor(changed.getRed(), changed.getGreen(), changed.getBlue());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.remove) {
            this.delMaterial();
        } else if (e.getSource() == this.add) {
            this.addMaterial();
        } else if (e.getSource() == this.rename) {
            this.renameMaterial();
        } else if (e.getSource() == this.color) {
            this.setColor();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.lock) {
            boolean b;
            this.locked[this.getSelectedIndex()] = b = this.lock.getState();
        }
    }

    public int currentMaterialID() {
        if (this.getSelectedIndex() == -1) {
            return -1;
        }
        return this.params.getMaterialID(this.getSelectedItem());
    }

    public double[] currentMaterialColor() {
        int mID = this.currentMaterialID();
        if (mID == -1) {
            return null;
        }
        return this.params.getMaterialColor(mID);
    }

    public int getDefaultMaterialID() {
        return this.params.getMaterialID(this.getItem(0));
    }

    public boolean isLocked(int matID) {
        return this.locked[this.getIndexOf(this.params.getMaterialName(matID))];
    }

    private class List
    extends Canvas {
        Color fgCol = Color.BLACK;
        Color bgCol = Color.LIGHT_GRAY;
        private int selectedIndex = 0;

        public List() {
            this.enableEvents(24L);
        }

        @Override
        public void setBackground(Color color) {
            this.bgCol = color;
        }

        @Override
        public void processMouseEvent(MouseEvent e) {
            int index;
            if (e.getID() == 502) {
                this.selectedIndex = e.getY() / MaterialList.this.lineHeight;
                this.repaint();
            }
            if (e.isPopupTrigger() && (index = e.getY() / MaterialList.this.lineHeight) < MaterialList.this.getItemCount()) {
                this.selectedIndex = index;
                this.repaint();
                MaterialList.this.lock.setState(MaterialList.this.locked[index]);
                MaterialList.this.popup.show(this, e.getX(), e.getY());
            }
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            if (e.getID() == 401) {
                int code = e.getKeyCode();
                if (code == 38 && this.selectedIndex > 0) {
                    this.ensureVisible(--this.selectedIndex, true);
                } else if (code == 40 && this.selectedIndex < MaterialList.this.getItemCount() - 1) {
                    this.ensureVisible(++this.selectedIndex, true);
                }
            }
        }

        public void ensureVisible(int index, boolean repaintAnyway) {
            Point p = MaterialList.this.getScrollPosition();
            Dimension d = MaterialList.this.getViewportSize();
            if (p.y + d.height < (index + 1) * MaterialList.this.lineHeight || p.y > index * MaterialList.this.lineHeight) {
                MaterialList.this.setScrollPosition(p.x, index * MaterialList.this.lineHeight);
                this.repaint();
            } else if (repaintAnyway) {
                this.repaint();
            }
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void paint(Graphics g) {
            g.setFont(MaterialList.this.font);
            for (int i = 0; i < MaterialList.this.getItemCount(); ++i) {
                g.setColor(i == this.selectedIndex ? this.fgCol : this.bgCol);
                g.fillRect(0, i * MaterialList.this.lineHeight, MaterialList.this.lineWidth, MaterialList.this.lineHeight);
                double[] c = MaterialList.this.params.getMaterialColor(i);
                g.setColor(new Color((float)c[0], (float)c[1], (float)c[2]));
                g.fillRect(1, i * MaterialList.this.lineHeight + 1, MaterialList.this.lineHeight - 2, MaterialList.this.lineHeight - 2);
                g.setColor(i == this.selectedIndex ? this.bgCol : this.fgCol);
                g.drawString(MaterialList.this.getItem(i), MaterialList.this.lineHeight, (i + 1) * MaterialList.this.lineHeight - 1);
            }
            int y = MaterialList.this.lineHeight * MaterialList.this.getItemCount();
            if (y < this.getHeight()) {
                g.setColor(this.bgCol);
                g.fillRect(0, y, MaterialList.this.lineWidth, this.getHeight() - y);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(MaterialList.this.lineWidth, MaterialList.this.getItemCount() * (MaterialList.this.font.getSize() + 1) + 1);
        }
    }
}

