/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.lang.invoke.MethodHandle;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.CharPtr;
import org.renjin.gcc.runtime.CharTypes;
import org.renjin.gcc.runtime.ObjectPtr;
import org.renjin.gcc.runtime.Ptr;

public class Stdlib {
    public static int strncmp(BytePtr x, BytePtr y, int n) {
        for (int i = 0; i < n; ++i) {
            byte bx = x.array[x.offset + i];
            byte by = y.array[y.offset + i];
            if (bx < by) {
                return -1;
            }
            if (bx <= by) continue;
            return 1;
        }
        return 0;
    }

    public static BytePtr strcpy(BytePtr destination, BytePtr source) {
        int length = source.nullTerminatedStringLength();
        System.arraycopy(source, source.offset, destination, destination.offset, length + 1);
        return destination;
    }

    public static int strlen(BytePtr x) {
        return x.nullTerminatedStringLength();
    }

    public static int printf(BytePtr format, Object ... arguments) {
        String outputString;
        try {
            outputString = Stdlib.doFormat(format, arguments);
        }
        catch (Exception e) {
            return -1;
        }
        System.out.println(outputString);
        return outputString.length();
    }

    public static int sprintf(BytePtr string, BytePtr format, Object ... arguments) {
        return Stdlib.snprintf(string, Integer.MAX_VALUE, format, arguments);
    }

    public static int snprintf(BytePtr string, int limit, BytePtr format, Object ... arguments) {
        String outputString;
        try {
            outputString = Stdlib.doFormat(format, arguments);
        }
        catch (Exception e) {
            return -1;
        }
        byte[] outputBytes = outputString.getBytes();
        int bytesToCopy = Math.min(outputBytes.length, limit - 1);
        if (bytesToCopy > 0) {
            System.arraycopy(outputBytes, 0, string.array, string.offset, bytesToCopy);
            string.array[string.offset + bytesToCopy] = 0;
        }
        return outputBytes.length;
    }

    private static String doFormat(BytePtr format, Object[] arguments) {
        Object[] convertedArgs = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            convertedArgs[i] = Stdlib.convertFormatArg(arguments[i]);
        }
        return String.format(format.nullTerminatedString(), convertedArgs);
    }

    private static Object convertFormatArg(Object argument) {
        if (argument instanceof BytePtr) {
            return ((BytePtr)argument).nullTerminatedString();
        }
        return argument;
    }

    public static void qsort(Ptr base, int nitems, int size, MethodHandle comparator) {
        throw new UnsupportedOperationException();
    }

    public static ObjectPtr<CharPtr> __ctype_b_loc() {
        return CharTypes.TABLE_PTR;
    }
}

