/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import mpicbg.ij.integral.Mean;

public class MSEBlockFlow
implements PlugIn {
    protected static int blockRadius = 8;
    protected static byte maxDistance = (byte)7;
    protected static boolean showColors = false;

    protected static final int pingPong(int a, int mod) {
        int x = a;
        int p = 2 * mod;
        if (x < 0) {
            x = -x;
        }
        if (x >= mod) {
            if (x <= p) {
                x = p - x;
            } else {
                try {
                    if ((x %= p) >= mod) {
                        x = p - x;
                    }
                }
                catch (ArithmeticException e) {
                    x = 0;
                }
            }
        }
        return x;
    }

    protected static final void colorCircle(ColorProcessor ip) {
        int r1 = Math.min(ip.getWidth(), ip.getHeight()) / 2;
        int r2 = r1 / 2;
        for (int y = 0; y < ip.getHeight(); ++y) {
            float dy = y - ip.getHeight() / 2;
            for (int x = 0; x < ip.getWidth(); ++x) {
                float dx = x - ip.getWidth() / 2;
                float l = (float)Math.sqrt(dx * dx + dy * dy);
                if (l > (float)r1 || l < (float)r2) {
                    ip.putPixel(x, y, 0);
                    continue;
                }
                ip.putPixel(x, y, MSEBlockFlow.colorVector(dx / l * (float)maxDistance, dy / l * (float)maxDistance));
            }
        }
    }

    private static final void algebraicToPolarAndColor(byte[] ipXPixels, byte[] ipYPixels, float[] ipRPixels, float[] ipPhiPixels, int[] ipColorPixels, double max) {
        int n = ipXPixels.length;
        for (int i = 0; i < n; ++i) {
            double x = (double)ipXPixels[i] / max;
            double y = (double)ipYPixels[i] / max;
            double r = Math.sqrt(x * x + y * y);
            double phi = Math.atan2(x / r, y / r);
            ipRPixels[i] = (float)r;
            ipPhiPixels[i] = (float)phi;
            if (r == 0.0) {
                ipColorPixels[i] = 0;
                continue;
            }
            double o = (phi + Math.PI) / Math.PI * 3.0;
            double red = o < 3.0 ? Math.min(1.0, Math.max(0.0, 2.0 - o)) * r : Math.min(1.0, Math.max(0.0, o - 4.0)) * r;
            if ((o += 2.0) >= 6.0) {
                o -= 6.0;
            }
            double green = o < 3.0 ? Math.min(1.0, Math.max(0.0, 2.0 - o)) * r : Math.min(1.0, Math.max(0.0, o - 4.0)) * r;
            if ((o += 2.0) >= 6.0) {
                o -= 6.0;
            }
            double blue = o < 3.0 ? Math.min(1.0, Math.max(0.0, 2.0 - o)) * r : Math.min(1.0, Math.max(0.0, o - 4.0)) * r;
            ipColorPixels[i] = ((int)(red * 255.0) << 8 | (int)(green * 255.0)) << 8 | (int)(blue * 255.0);
        }
    }

    private static final int colorVector(float xs, float ys) {
        double a;
        if ((a = Math.sqrt((xs /= (float)maxDistance) * xs + (ys /= (float)maxDistance) * ys)) == 0.0) {
            return 0;
        }
        double o = (Math.atan2((double)xs / a, (double)ys / a) + Math.PI) / Math.PI * 3.0;
        double r = o < 3.0 ? Math.min(1.0, Math.max(0.0, 2.0 - o)) * a : Math.min(1.0, Math.max(0.0, o - 4.0)) * a;
        if ((o += 2.0) >= 6.0) {
            o -= 6.0;
        }
        double g = o < 3.0 ? Math.min(1.0, Math.max(0.0, 2.0 - o)) * a : Math.min(1.0, Math.max(0.0, o - 4.0)) * a;
        if ((o += 2.0) >= 6.0) {
            o -= 6.0;
        }
        double b = o < 3.0 ? Math.min(1.0, Math.max(0.0, 2.0 - o)) * a : Math.min(1.0, Math.max(0.0, o - 4.0)) * a;
        return ((int)(r * 255.0) << 8 | (int)(g * 255.0)) << 8 | (int)(b * 255.0);
    }

    private static final void subtractShifted(FloatProcessor a, FloatProcessor b, FloatProcessor c, int xo, int yo) {
        float[] af = (float[])a.getPixels();
        float[] bf = (float[])b.getPixels();
        float[] cf = (float[])c.getPixels();
        int w = a.getWidth();
        int h = a.getHeight();
        for (int y = 0; y < h; ++y) {
            int yb = y + yo;
            if (yb < 0 || yb >= h) {
                yb = MSEBlockFlow.pingPong(yb, h - 1);
            }
            int yAdd = y * w;
            int ybAdd = yb * w;
            for (int x = 0; x < a.getWidth(); ++x) {
                int xb = x + xo;
                if (xb < 0 || xb >= w) {
                    xb = MSEBlockFlow.pingPong(xb, w - 1);
                }
                int i = yAdd + x;
                float d = bf[ybAdd + xb] - af[i];
                cf[i] = d * d;
            }
        }
    }

    private static final void opticFlow(FloatProcessor ip1, FloatProcessor ip2, FloatProcessor r, FloatProcessor phi, ColorProcessor of) {
        ByteProcessor ipX = new ByteProcessor(ip1.getWidth(), ip1.getHeight());
        ByteProcessor ipY = new ByteProcessor(ip1.getWidth(), ip1.getHeight());
        FloatProcessor ipD = new FloatProcessor(ip1.getWidth(), ip1.getHeight());
        FloatProcessor ipDMin = new FloatProcessor(ip1.getWidth(), ip1.getHeight());
        float[] ipDMinInitPixels = (float[])ipDMin.getPixels();
        for (int i = 0; i < ipDMinInitPixels.length; ++i) {
            ipDMinInitPixels[i] = Float.MAX_VALUE;
        }
        for (byte yo = (byte)(-maxDistance); yo <= maxDistance; yo = (byte)(yo + 1)) {
            for (byte xo = (byte)(-maxDistance); xo <= maxDistance; xo = (byte)(xo + 1)) {
                if (yo * yo + xo * xo > maxDistance * maxDistance) continue;
                MSEBlockFlow.subtractShifted(ip1, ip2, ipD, xo, yo);
                Mean mean = new Mean(ipD);
                mean.mean(blockRadius);
                float[] ipDPixels = (float[])ipD.getPixels();
                float[] ipDMinPixels = (float[])ipDMin.getPixels();
                byte[] ipXPixels = (byte[])ipX.getPixels();
                byte[] ipYPixels = (byte[])ipY.getPixels();
                for (int i = 0; i < ipDPixels.length; ++i) {
                    if (!(ipDPixels[i] < ipDMinPixels[i])) continue;
                    ipDMinPixels[i] = ipDPixels[i];
                    ipXPixels[i] = xo;
                    ipYPixels[i] = yo;
                }
            }
        }
        MSEBlockFlow.algebraicToPolarAndColor((byte[])ipX.getPixels(), (byte[])ipY.getPixels(), (float[])r.getPixels(), (float[])phi.getPixels(), (int[])of.getPixels(), maxDistance);
    }

    public final void run(String args) {
        if (IJ.versionLessThan((String)"1.41n")) {
            return;
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.error((String)"There are no images open");
            return;
        }
        GenericDialog gd = new GenericDialog("Generate optic flow");
        gd.addNumericField("block radius :", (double)blockRadius, 0, 6, "px");
        gd.addNumericField("maximal_distance :", (double)maxDistance, 0, 6, "px");
        gd.addCheckbox("show_color_map", showColors);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        blockRadius = (int)gd.getNextNumber();
        maxDistance = (byte)gd.getNextNumber();
        showColors = gd.getNextBoolean();
        if (showColors) {
            ColorProcessor ipColor = new ColorProcessor(imp.getWidth(), imp.getHeight());
            MSEBlockFlow.colorCircle(ipColor);
            ImagePlus impColor = new ImagePlus("Color", (ImageProcessor)ipColor);
            impColor.show();
        }
        ImageStack seq = imp.getStack();
        ImageStack seqOpticFlow = new ImageStack(imp.getWidth(), imp.getHeight(), seq.getSize() - 1);
        ImageStack seqFlowVectors = new ImageStack(imp.getWidth(), imp.getHeight(), 2 * seq.getSize() - 2);
        FloatProcessor ip2 = (FloatProcessor)seq.getProcessor(1).convertToFloat();
        ImagePlus impOpticFlow = null;
        CompositeImage impFlowVectors = null;
        for (int i = 1; i < seq.getSize(); ++i) {
            FloatProcessor ip1 = ip2;
            ip2 = (FloatProcessor)seq.getProcessor(i + 1).convertToFloat();
            IJ.log((String)("Processing slice " + i));
            FloatProcessor seqFlowVectorRSlice = new FloatProcessor(imp.getWidth(), imp.getHeight());
            FloatProcessor seqFlowVectorPhiSlice = new FloatProcessor(imp.getWidth(), imp.getHeight());
            ColorProcessor seqOpticFlowSlice = new ColorProcessor(imp.getWidth(), imp.getHeight());
            MSEBlockFlow.opticFlow(ip1, ip2, seqFlowVectorRSlice, seqFlowVectorPhiSlice, seqOpticFlowSlice);
            seqFlowVectors.setPixels(seqFlowVectorRSlice.getPixels(), 2 * i - 1);
            seqFlowVectors.setSliceLabel("r " + i, 2 * i - 1);
            seqFlowVectors.setPixels(seqFlowVectorPhiSlice.getPixels(), 2 * i);
            seqFlowVectors.setSliceLabel("phi " + i, 2 * i);
            seqOpticFlow.setPixels(seqOpticFlowSlice.getPixels(), i);
            seqOpticFlow.setSliceLabel("" + i, i);
            if (i == 1) {
                impOpticFlow = new ImagePlus(imp.getTitle() + " optic flow", seqOpticFlow);
                impOpticFlow.setOpenAsHyperStack(true);
                impOpticFlow.setCalibration(imp.getCalibration());
                impOpticFlow.setDimensions(1, 1, seq.getSize() - 1);
                impOpticFlow.show();
                ImagePlus notYetComposite = new ImagePlus(imp.getTitle() + " flow vectors", seqFlowVectors);
                notYetComposite.setOpenAsHyperStack(true);
                notYetComposite.setCalibration(imp.getCalibration());
                notYetComposite.setDimensions(2, 1, seq.getSize() - 1);
                impFlowVectors = new CompositeImage(notYetComposite, 3);
                impFlowVectors.setOpenAsHyperStack(true);
                impFlowVectors.setDimensions(2, 1, seq.getSize() - 1);
                impFlowVectors.show();
                impFlowVectors.setPosition(1, 1, 1);
                impFlowVectors.setDisplayRange(0.0, 1.0);
                impFlowVectors.setPosition(2, 1, 1);
                impFlowVectors.setDisplayRange(-Math.PI, Math.PI);
            }
            IJ.showProgress((int)i, (int)seq.getSize());
            impOpticFlow.setSlice(i);
            impFlowVectors.setPosition(1, 1, i);
            imp.setSlice(i + 1);
        }
    }
}

