/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.builder;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apposed.appose.Builder;
import org.apposed.appose.Environment;
import org.apposed.appose.builder.BaseBuilder;
import org.apposed.appose.builder.Uv;
import org.apposed.appose.scheme.Schemes;
import org.apposed.appose.util.FilePaths;
import org.apposed.appose.util.Platforms;

public final class UvBuilder
extends BaseBuilder<UvBuilder> {
    private String pythonVersion;
    private final List<String> packages = new ArrayList<String>();

    public UvBuilder() {
    }

    public UvBuilder(String source) throws IOException {
        this.file(source);
    }

    public UvBuilder(String source, String scheme) throws IOException {
        this.file(source);
        this.scheme = scheme;
    }

    public UvBuilder python(String version) {
        this.pythonVersion = version;
        return this;
    }

    public UvBuilder include(String ... packages) {
        this.packages.addAll(Arrays.asList(packages));
        return this;
    }

    @Override
    public String name() {
        return "uv";
    }

    @Override
    public Environment build() throws IOException {
        File envDir = this.envDir();
        if (new File(envDir, ".pixi").isDirectory()) {
            throw new IOException("Cannot use UvBuilder: environment already managed by Pixi at " + envDir);
        }
        if (new File(envDir, "conda-meta").isDirectory()) {
            throw new IOException("Cannot use UvBuilder: environment already managed by Mamba/Conda at " + envDir);
        }
        Uv uv = new Uv();
        uv.setOutputConsumer(msg -> this.outputSubscribers.forEach(sub -> sub.accept(msg)));
        uv.setErrorConsumer(msg -> this.errorSubscribers.forEach(sub -> sub.accept(msg)));
        uv.setDownloadProgressConsumer((cur, max) -> this.progressSubscribers.forEach(subscriber -> subscriber.accept("Downloading uv", (long)cur, (long)max)));
        uv.setEnvVars(this.envVars);
        uv.setFlags(this.flags);
        if (!this.channels.isEmpty()) {
            throw new UnsupportedOperationException("UvBuilder does not yet support programmatic index configuration. Please specify custom indices in your requirements.txt file using '--index-url' or '--extra-index-url' directives.");
        }
        try {
            uv.install();
            boolean isUvVenv = new File(envDir, "pyvenv.cfg").isFile();
            if (isUvVenv && this.sourceContent == null && this.packages.isEmpty()) {
                return this.createEnvironment(envDir);
            }
            if (this.sourceContent != null) {
                if (this.scheme == null) {
                    this.scheme = Schemes.fromContent(this.sourceContent).name();
                }
                if (!"requirements.txt".equals(this.scheme) && !"pyproject.toml".equals(this.scheme)) {
                    throw new IllegalArgumentException("UvBuilder only supports requirements.txt and pyproject.toml schemes, got: " + this.scheme);
                }
                if ("pyproject.toml".equals(this.scheme)) {
                    if (!envDir.exists() && !envDir.mkdirs()) {
                        throw new IOException("Failed to create environment directory: " + envDir);
                    }
                    File pyprojectFile = new File(envDir, "pyproject.toml");
                    Files.write(pyprojectFile.toPath(), this.sourceContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    uv.sync(envDir, this.pythonVersion);
                } else {
                    if (!isUvVenv) {
                        uv.createVenv(envDir, this.pythonVersion);
                    }
                    File reqsFile = new File(envDir, "requirements.txt");
                    Files.write(reqsFile.toPath(), this.sourceContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    uv.pipInstallFromRequirements(envDir, reqsFile.getAbsolutePath());
                }
            } else {
                if (!isUvVenv) {
                    uv.createVenv(envDir, this.pythonVersion);
                }
                if (!this.packages.isEmpty()) {
                    ArrayList<String> allPackages = new ArrayList<String>(this.packages);
                    if (!allPackages.contains("appose")) {
                        allPackages.add("appose");
                    }
                    uv.pipInstall(envDir, allPackages.toArray(new String[0]));
                }
            }
            return this.createEnvironment(envDir);
        }
        catch (InterruptedException | URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Environment wrap(File envDir) throws IOException {
        FilePaths.ensureDirectory(envDir);
        File pyprojectToml = new File(envDir, "pyproject.toml");
        if (pyprojectToml.exists() && pyprojectToml.isFile()) {
            this.sourceContent = new String(Files.readAllBytes(pyprojectToml.toPath()), StandardCharsets.UTF_8);
            this.scheme = "pyproject.toml";
        } else {
            File requirementsTxt = new File(envDir, "requirements.txt");
            if (requirementsTxt.exists() && requirementsTxt.isFile()) {
                this.sourceContent = new String(Files.readAllBytes(requirementsTxt.toPath()), StandardCharsets.UTF_8);
                this.scheme = "requirements.txt";
            }
        }
        this.base(envDir);
        return this.build();
    }

    @Override
    public UvBuilder channels(String ... indexes) {
        return (UvBuilder)super.channels(indexes);
    }

    private Environment createEnvironment(File envDir) {
        final String base = envDir.getAbsolutePath();
        File venvDir = new File(envDir, ".venv");
        File actualVenvDir = venvDir.exists() ? venvDir : envDir;
        String binDir = Platforms.isWindows() ? "Scripts" : "bin";
        final List<String> binPaths = Collections.singletonList(actualVenvDir.toPath().resolve(binDir).toString());
        final List launchArgs = Collections.emptyList();
        return new Environment(){

            @Override
            public String base() {
                return base;
            }

            @Override
            public List<String> binPaths() {
                return binPaths;
            }

            @Override
            public List<String> launchArgs() {
                return launchArgs;
            }

            @Override
            public Map<String, String> envVars() {
                return UvBuilder.this.envVars;
            }

            @Override
            public Builder<?> builder() {
                return UvBuilder.this;
            }
        };
    }
}

