/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.haralick;

import net.imagej.ops.Ops;
import net.imagej.ops.features.haralick.AbstractHaralickFeature;
import net.imagej.ops.features.haralick.helper.CoocMeanX;
import net.imagej.ops.features.haralick.helper.CoocMeanY;
import net.imagej.ops.features.haralick.helper.CoocStdX;
import net.imagej.ops.features.haralick.helper.CoocStdY;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Haralick.Correlation.class, label="Haralick: Correlation")
public class DefaultCorrelation<T extends RealType<T>>
extends AbstractHaralickFeature<T>
implements Ops.Haralick.Correlation {
    private UnaryFunctionOp<double[][], DoubleType> coocMeanXFunc;
    private UnaryFunctionOp<double[][], DoubleType> coocMeanYFunc;
    private UnaryFunctionOp<double[][], DoubleType> coocStdYFunc;
    private UnaryFunctionOp<double[][], DoubleType> coocStdXFunc;

    @Override
    public void initialize() {
        super.initialize();
        this.coocMeanXFunc = Functions.unary(this.ops(), CoocMeanX.class, DoubleType.class, double[][].class, new Object[0]);
        this.coocMeanYFunc = Functions.unary(this.ops(), CoocMeanY.class, DoubleType.class, double[][].class, new Object[0]);
        this.coocStdXFunc = Functions.unary(this.ops(), CoocStdX.class, DoubleType.class, double[][].class, new Object[0]);
        this.coocStdYFunc = Functions.unary(this.ops(), CoocStdY.class, DoubleType.class, double[][].class, new Object[0]);
    }

    @Override
    public void compute(IterableInterval<T> input, DoubleType output) {
        double[][] matrix = this.getCooccurrenceMatrix(input);
        int nrGrayLevels = matrix.length;
        double meanx = this.coocMeanXFunc.calculate(matrix).get();
        double meany = this.coocMeanYFunc.calculate(matrix).get();
        double stdx = this.coocStdXFunc.calculate(matrix).get();
        double stdy = this.coocStdYFunc.calculate(matrix).get();
        double sum = 0.0;
        for (int i = 0; i < nrGrayLevels; ++i) {
            for (int j = 0; j < nrGrayLevels; ++j) {
                sum += (double)(i * j) * matrix[i][j];
            }
        }
        output.set((sum - meanx * meany) / (stdx * stdy));
    }
}

