/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.io.FileOpener;
import ij.io.TiffDecoder;
import ij.io.TiffEncoder;
import ij.plugin.WandToolOptions;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.Display3D;
import ini.trakem2.display.DisplayCanvas;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.ImageData;
import ini.trakem2.display.Layer;
import ini.trakem2.display.MipMapImage;
import ini.trakem2.imaging.PatchStack;
import ini.trakem2.imaging.filters.FilterEditor;
import ini.trakem2.imaging.filters.IFilter;
import ini.trakem2.io.CoordinateTransformXML;
import ini.trakem2.io.ImageSaver;
import ini.trakem2.persistence.FSLoader;
import ini.trakem2.persistence.Loader;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.ProjectToolbar;
import ini.trakem2.utils.Search;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Future;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.shapelist.ShapeList;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.integer.UnsignedByteType;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.CoordinateTransformMesh;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.TransformMesh;
import mpicbg.trakem2.transform.CoordinateTransformList;
import mpicbg.trakem2.transform.ExportBestFlatImage;
import mpicbg.trakem2.transform.TransformMeshMapping;
import mpicbg.trakem2.transform.TransformMeshMappingWithMasks;

public final class Patch
extends Displayable
implements ImageData {
    private static final double SQRT2 = Math.sqrt(2.0);
    private int type = -1;
    private boolean false_color = false;
    private int channels = -1;
    private double min = 0.0;
    private double max = 255.0;
    private int o_width = 0;
    private int o_height = 0;
    private String current_path = null;
    private String original_path = null;
    private IFilter[] filters;
    private long ct_id = 0L;
    private long alpha_mask_id = 0L;
    protected int meshResolution = this.project.getProperty("mesh_resolution", 32);
    public static final DirectColorModel DCM = new DirectColorModel(24, 0xFF0000, 65280, 255);

    public int getMeshResolution() {
        return this.meshResolution;
    }

    public void setMeshResolution(int meshResolution) {
        if (!this.hasCoordinateTransform()) {
            this.meshResolution = meshResolution;
        } else {
            Rectangle box = this.getCoordinateTransformBoundingBox();
            this.at.translate(-box.x, -box.y);
            this.meshResolution = meshResolution;
            box = this.getCoordinateTransformBoundingBox();
            this.at.translate(box.x, box.y);
            this.width = box.width;
            this.height = box.height;
            this.updateInDatabase("transform+dimensions");
            this.updateBucket();
        }
    }

    public static final Patch createPatch(Project project, String filepath) throws Exception {
        ImagePlus imp = project.getLoader().openImagePlus(filepath);
        if (null == imp) {
            throw new Exception("Cannot create Patch: the image cannot be opened from filepath " + filepath);
        }
        if (imp.isComposite()) {
            throw new Exception("Cannot create Patch: composite images are not supported. Convert them to RGB first.");
        }
        if (imp.isHyperStack()) {
            throw new Exception("Cannot create Patch: hyperstacks are not supported.");
        }
        Patch p = new Patch(project, new File(filepath).getName(), 0.0, 0.0, imp);
        project.getLoader().addedPatchFrom(filepath, p);
        return p;
    }

    public Patch(Project project, String title, double x, double y, ImagePlus imp) {
        super(project, title, x, y);
        this.type = imp.getType();
        if (0 == this.type && imp.getProcessor().isColorLut()) {
            this.type = 3;
        }
        this.min = imp.getProcessor().getMin();
        this.max = imp.getProcessor().getMax();
        this.checkMinMax();
        this.o_width = imp.getWidth();
        this.o_height = imp.getHeight();
        this.width = this.o_width;
        this.height = this.o_height;
        project.getLoader().cache(this, imp);
        this.false_color = imp.getProcessor().isColorLut();
        this.addToDatabase();
    }

    public Patch(Project project, long id, String title, float width, float height, int o_width, int o_height, int type, boolean locked, double min, double max, AffineTransform at) {
        super(project, id, title, locked, at, width, height);
        this.type = type;
        this.min = min;
        this.max = max;
        this.width = width;
        this.height = height;
        this.o_width = o_width;
        this.o_height = o_height;
        this.checkMinMax();
    }

    public Patch(Project project, String title, float width, float height, int o_width, int o_height, int type, float alpha, Color color, boolean locked, double min, double max, AffineTransform at, String file_path) {
        this(project, project.getLoader().getNextId(), title, width, height, o_width, o_height, type, locked, min, max, at);
        this.alpha = Math.max(0.0f, Math.min(alpha, 1.0f));
        this.color = null == color ? Color.yellow : color;
        project.getLoader().addedPatchFrom(file_path, this);
    }

    public Patch(Project project, long id, HashMap<String, String> ht_attributes, HashMap<Displayable, String> ht_links) {
        super(project, id, ht_attributes, ht_links);
        project.getLoader().addedPatchFrom(ht_attributes.get("file_path"), this);
        boolean hasmin = false;
        boolean hasmax = false;
        String data = ht_attributes.get("type");
        if (null != data) {
            this.type = Integer.parseInt(data);
        }
        if (null != (data = ht_attributes.get("false_color"))) {
            this.false_color = Boolean.parseBoolean(data);
        }
        if (null != (data = ht_attributes.get("min"))) {
            this.min = Double.parseDouble(data);
            hasmin = true;
        }
        if (null != (data = ht_attributes.get("max"))) {
            this.max = Double.parseDouble(data);
            hasmax = true;
        }
        if (null != (data = ht_attributes.get("o_width"))) {
            this.o_width = Integer.parseInt(data);
        }
        if (null != (data = ht_attributes.get("o_height"))) {
            this.o_height = Integer.parseInt(data);
        }
        if (null != (data = ht_attributes.get("pps"))) {
            if (FSLoader.isRelativePath(data)) {
                data = project.getLoader().getParentFolder() + data;
            }
            project.getLoader().setPreprocessorScriptPathSilently(this, data);
        }
        if (null != (data = ht_attributes.get("original_path"))) {
            this.original_path = data;
        }
        if (null != (data = ht_attributes.get("mres"))) {
            this.meshResolution = Integer.parseInt(data);
        }
        if (null != (data = ht_attributes.get("ct_id"))) {
            this.ct_id = Long.parseLong(data);
        }
        if (null != (data = ht_attributes.get("alpha_mask_id"))) {
            this.alpha_mask_id = Long.parseLong(data);
        }
        if (0 == this.o_width || 0 == this.o_height) {
            try {
                Utils.log2("Restoring original width/height from file for id=" + id);
                Dimension dim = project.getLoader().getDimensions(this);
                this.o_width = dim.width;
                this.o_height = dim.height;
            }
            catch (Exception e) {
                Utils.log("Could not read source data width/height for patch " + this + "\n --> To fix it, close the project and add o_width=\"XXX\" o_height=\"YYY\"\n     to patch entry with oid=\"" + id + "\",\n     where o_width,o_height are the image dimensions as defined in the image file.");
                this.o_width = (int)this.width;
                this.o_height = (int)this.height;
                IJError.print(e);
            }
        }
        if (hasmin && hasmax) {
            this.checkMinMax();
        } else if (0 == this.type || 4 == this.type || 3 == this.type) {
            this.min = 0.0;
            this.max = 255.0;
        } else {
            ImageProcessor ip = this.getImageProcessor();
            if (null == ip) {
                this.min = 0.0;
                this.max = Patch.getMaxMax(this.type);
                Utils.log("WARNING could not restore min and max from image file for Patch #" + this.id + ", and they are not present in the XML file.");
            } else {
                ip.resetMinAndMax();
                this.setMinAndMax(ip.getMin(), ip.getMax());
            }
        }
    }

    public int getOWidth() {
        return this.o_width;
    }

    public int getOHeight() {
        return this.o_height;
    }

    public ImagePlus getImagePlus() {
        return this.project.getLoader().fetchImagePlus(this);
    }

    public ImageProcessor getImageProcessor() {
        return this.project.getLoader().fetchImageProcessor(this);
    }

    public Future<Boolean> updateMipMaps() {
        return this.project.getLoader().regenerateMipMaps(this);
    }

    public void updatePixelProperties(ImagePlus imp) {
        this.readProps(imp);
    }

    private void readProps(ImagePlus imp) {
        this.type = imp.getType();
        this.false_color = imp.getProcessor().isColorLut();
        if (imp.getWidth() != this.o_width || imp.getHeight() != this.o_height) {
            this.o_width = imp.getWidth();
            this.o_height = imp.getHeight();
            this.width = this.o_width;
            this.height = this.o_height;
            this.updateBucket();
        }
        ImageProcessor ip = imp.getProcessor();
        this.min = ip.getMin();
        this.max = ip.getMax();
        HashSet<String> keys = new HashSet<String>();
        keys.add("type");
        keys.add("dimensions");
        keys.add("min_and_max");
        this.updateInDatabase(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(ImagePlus new_imp) {
        Patch patch = this;
        synchronized (patch) {
            String path;
            if (null == new_imp) {
                return null;
            }
            if (this.isStack()) {
                for (Patch p : this.getStackPatches()) {
                    if (null != p.original_path) continue;
                    this.original_path = p.project.getLoader().getAbsolutePath(p);
                }
            } else if (null == this.original_path) {
                this.original_path = this.project.getLoader().getAbsolutePath(this);
            }
            if (null == (path = this.project.getLoader().setImageFile(this, new_imp))) {
                Utils.log2("setImageFile returned null!");
                return null;
            }
            if (this.isStack()) {
                for (Patch p : this.getStackPatches()) {
                    p.readProps(new_imp);
                    this.project.getLoader().regenerateMipMaps(p);
                }
            } else {
                this.readProps(new_imp);
                this.project.getLoader().regenerateMipMaps(this);
            }
        }
        Display.repaint(this.layer, (Displayable)this, 5);
        return this.project.getLoader().getAbsolutePath(this);
    }

    private void checkMinMax() {
        if (-1 == this.type) {
            Utils.log("ERROR -1 == type for patch " + this);
            return;
        }
        double max_max = Patch.getMaxMax(this.type);
        if (-1.0 == this.min && -1.0 == this.max) {
            this.min = 0.0;
            this.max = max_max;
        }
        switch (this.type) {
            case 0: 
            case 3: 
            case 4: {
                if (!(this.min < 0.0)) break;
                this.min = 0.0;
                Utils.log("WARNING set min to 0 for patch " + this + " of type " + this.type);
            }
        }
        if (this.max > max_max) {
            this.max = max_max;
            Utils.log("WARNING fixed max larger than maximum max for type " + this.type);
        }
        if (this.min > this.max) {
            this.min = this.max;
            Utils.log("WARNING fixed min larger than max for patch " + this);
        }
    }

    public void setMinAndMax(double min, double max) {
        this.min = min;
        this.max = max;
        this.checkMinMax();
        this.updateInDatabase("min_and_max");
        Utils.log2("Patch.setMinAndMax: min,max " + min + "," + max);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public int getType() {
        return this.type;
    }

    public Image createImage(ImagePlus imp) {
        return this.adjustChannels(this.channels, true, imp);
    }

    public Image createImage() {
        return this.adjustChannels(this.channels, true, null);
    }

    public int getChannelAlphas() {
        return this.channels;
    }

    private Image adjustChannels(int c, boolean force, ImagePlus imp) {
        ImageProcessor ip;
        if (null == imp) {
            imp = this.project.getLoader().fetchImagePlus(this);
        }
        if (null == (ip = imp.getProcessor())) {
            return null;
        }
        Image awt = null;
        if (4 == this.type) {
            if (imp.getType() != this.type) {
                ip = Utils.convertTo(ip, this.type, false);
            }
            if ((c & 0xFFFFFF) == 0xFFFFFF && !force) {
                awt = ip.createImage();
            } else {
                int[] pixels = (int[])ip.getPixels();
                float cr = (float)((c & 0xFF0000) >> 16) / 255.0f;
                float cg = (float)((c & 0xFF00) >> 8) / 255.0f;
                float cb = (float)(c & 0xFF) / 255.0f;
                int[] pix = new int[pixels.length];
                for (int i = pixels.length - 1; i > -1; --i) {
                    int p = pixels[i];
                    pix[i] = ((int)((float)((p & 0xFF0000) >> 16) * cr) << 16) + ((int)((float)((p & 0xFF00) >> 8) * cg) << 8) + (int)((float)(p & 0xFF) * cb);
                }
                int w = imp.getWidth();
                MemoryImageSource source = new MemoryImageSource(w, imp.getHeight(), (ColorModel)DCM, pix, 0, w);
                source.setAnimated(true);
                source.setFullBufferUpdates(true);
                awt = Toolkit.getDefaultToolkit().createImage(source);
            }
        } else {
            awt = ip.createImage();
        }
        this.channels = c;
        return awt;
    }

    private final void checkChannels(int channels, double magnification) {
        if (this.channels != channels && (4 == this.type || 3 == this.type)) {
            int old_channels = this.channels;
            this.channels = channels;
            this.project.getLoader().adjustChannels(this, old_channels);
        }
    }

    public final Image adjustChannels(Image awt) {
        if (-1 == this.channels || null == awt) {
            return awt;
        }
        BufferedImage bi = null;
        if (awt instanceof BufferedImage) {
            bi = (BufferedImage)awt;
        } else {
            bi = new BufferedImage(awt.getWidth(null), awt.getHeight(null), 2);
            bi.getGraphics().drawImage(awt, 0, 0, null);
        }
        float cr = (float)((this.channels & 0xFF0000) >> 16) / 255.0f;
        float cg = (float)((this.channels & 0xFF00) >> 8) / 255.0f;
        float cb = (float)(this.channels & 0xFF) / 255.0f;
        Utils.log2("w, h: " + bi.getWidth() + ", " + bi.getHeight());
        int[] pixels = bi.getRGB(0, 0, bi.getWidth(), bi.getHeight(), null, 0, 1);
        for (int i = 0; i < pixels.length; ++i) {
            int p = pixels[i];
            pixels[i] = ((int)((float)((p & 0xFF0000) >> 16) * cr) << 16) + ((int)((float)((p & 0xFF00) >> 8) * cg) << 8) + (int)((float)(p & 0xFF) * cb);
        }
        bi.setRGB(0, 0, bi.getWidth(), bi.getHeight(), pixels, 0, 1);
        return bi;
    }

    @Override
    public void paintOffscreen(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> layers) {
        this.paint(g, this.fetchImage(magnification, channels, true), srcRect);
    }

    @Override
    public void paint(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> _ignored) {
        this.paint(g, this.fetchImage(magnification, channels, false), srcRect);
    }

    private final MipMapImage fetchImage(double magnification, int channels, boolean wait_for_image) {
        this.checkChannels(channels, magnification);
        double sc = magnification * Math.max(Math.abs(this.at.getScaleX()), Math.max(Math.abs(this.at.getScaleY()), Math.max(Math.abs(this.at.getShearX()), Math.abs(this.at.getShearY()))));
        if (sc < 0.0) {
            sc = magnification;
        }
        return wait_for_image ? this.project.getLoader().fetchDataImage(this, sc) : this.project.getLoader().fetchImage(this, sc);
    }

    private void paint(Graphics2D g, Image image, Rectangle srcRect) {
        int iw = image.getWidth(null);
        int ih = image.getHeight(null);
        this.paint(g, new MipMapImage(image, this.width / (float)iw, this.height / (float)ih), srcRect);
    }

    private void paint(Graphics2D g, MipMapImage mipMap, Rectangle srcRect) {
        AffineTransform atp = new AffineTransform();
        atp.translate(0.5, 0.5);
        atp.concatenate(this.at);
        atp.scale(mipMap.scaleX, mipMap.scaleY);
        if (3 == this.project.getMipMapsMode()) {
            atp.translate(-0.5, -0.5);
        } else {
            atp.translate(-0.5 / mipMap.scaleX, -0.5 / mipMap.scaleY);
        }
        this.paintMipMap(g, mipMap, atp, srcRect);
    }

    @Override
    public void prePaint(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> _ignored) {
        MipMapImage mipMap;
        AffineTransform atp = new AffineTransform();
        atp.translate(0.5, 0.5);
        atp.concatenate(this.at);
        this.checkChannels(channels, magnification);
        double sc = magnification * Math.max(Math.abs(this.at.getScaleX()), Math.max(Math.abs(this.at.getScaleY()), Math.max(Math.abs(this.at.getShearX()), Math.abs(this.at.getShearY()))));
        if (sc < 0.0) {
            sc = magnification;
        }
        if (null == (mipMap = this.project.getLoader().getCachedClosestAboveImage(this, sc))) {
            mipMap = this.project.getLoader().getCachedClosestBelowImage(this, sc);
            if (null == mipMap) {
                mipMap = this.project.getLoader().fetchImage(this, sc / 4.0);
            }
            if (!Loader.isSignalImage(mipMap.image)) {
                Loader.preload(this, sc, true);
            }
        }
        atp.scale(mipMap.scaleX, mipMap.scaleY);
        if (3 == this.project.getMipMapsMode()) {
            atp.translate(-0.5, -0.5);
        } else {
            atp.translate(-0.5 / mipMap.scaleX, -0.5 / mipMap.scaleY);
        }
        this.paintMipMap(g, mipMap, atp, srcRect);
    }

    private final void paintMipMap(Graphics2D g, MipMapImage mipMap, AffineTransform atp, Rectangle srcRect) {
        Composite original_composite = g.getComposite();
        try {
            g.setComposite(this.getComposite(this.getCompositeMode()));
            g.drawImage(mipMap.image, atp, null);
        }
        catch (Throwable t) {
            g.setComposite(original_composite);
            Utils.log("Cannot paint Patch with composite type " + compositeModes[this.getCompositeMode()] + "\nReason:\n" + t.toString());
            g.drawImage(mipMap.image, atp, null);
        }
        g.setComposite(original_composite);
    }

    @Override
    public boolean isDeletable() {
        return 0.0f == this.width && 0.0f == this.height;
    }

    @Override
    public boolean remove(boolean check) {
        if (check && !Utils.check("Really remove " + this.toString() + " ?")) {
            return false;
        }
        if (this.isStack()) {
            GenericDialog gd = new GenericDialog("Stack!");
            gd.addMessage("Really delete the entire stack?");
            gd.addCheckbox("Delete layers if empty", true);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            boolean delete_empty_layers = gd.getNextBoolean();
            HashMap<Double, Patch> ht = new HashMap<Double, Patch>();
            this.getStackPatchesNR(ht);
            Utils.log2("Removing stack patches: " + ht.size());
            for (Patch p : ht.values()) {
                if (p.isOnlyLinkedTo(this.getClass())) continue;
                Utils.showMessage("At least one slice of the stack (z=" + p.getLayer().getZ() + ") is supporting other data.\nCan't delete.");
                return false;
            }
            ArrayList<Layer> layers_to_remove = new ArrayList<Layer>();
            for (Patch p : ht.values()) {
                if (!p.layer.remove(p) || !p.removeFromDatabase()) {
                    Utils.showMessage("Can't delete Patch " + p);
                    return false;
                }
                p.unlink();
                p.removeLinkedPropertiesFromOrigins();
                layers_to_remove.add(p.layer);
                if (p.layer.isEmpty()) {
                    Display.close(p.layer);
                    continue;
                }
                Display.repaint(p.layer);
            }
            if (delete_empty_layers) {
                for (Layer la : layers_to_remove) {
                    if (!la.isEmpty()) continue;
                    this.project.getLayerTree().remove(la, false);
                    Display.close(la);
                }
            }
            Search.remove(this);
            return true;
        }
        if (this.isOnlyLinkedTo(Patch.class, this.layer) && this.layer.remove(this) && this.removeFromDatabase()) {
            this.unlink();
            this.removeLinkedPropertiesFromOrigins();
            Search.remove(this);
            return true;
        }
        Utils.showMessage("Patch: can't remove! The image is linked and thus supports other data).");
        return false;
    }

    public final boolean isStack() {
        if (null == this.hs_linked || this.hs_linked.isEmpty()) {
            return false;
        }
        for (Displayable d : this.hs_linked) {
            if (d.getClass() != Patch.class || d.layer.getId() == this.layer.getId()) continue;
            return true;
        }
        return false;
    }

    public PatchStack makePatchStack() {
        Patch[] patch;
        TreeMap<Double, Patch> ht = new TreeMap<Double, Patch>();
        this.getStackPatchesNR(ht);
        int currentSlice = 1;
        if (ht.size() > 1) {
            patch = new Patch[ht.size()];
            int i = 0;
            Iterator<Patch> iterator = ht.values().iterator();
            while (iterator.hasNext()) {
                Patch p;
                patch[i] = p = iterator.next();
                if (p.id == this.id) {
                    currentSlice = i + 1;
                }
                ++i;
            }
        } else {
            patch = new Patch[]{this};
        }
        return new PatchStack(patch, currentSlice);
    }

    public ArrayList<Patch> getStackPatches() {
        TreeMap<Double, Patch> ht = new TreeMap<Double, Patch>();
        this.getStackPatchesNR(ht);
        return new ArrayList<Patch>(ht.values());
    }

    private void getStackPatchesNR(Map<Double, Patch> ht) {
        ArrayList<Patch> list1 = new ArrayList<Patch>();
        list1.add(this);
        ArrayList<Patch> list2 = new ArrayList<Patch>();
        while (list1.size() > 0) {
            list2.clear();
            for (Patch p : list1) {
                if (null == p.hs_linked) continue;
                for (Object ln : p.hs_linked) {
                    Patch pa;
                    if (ln.getClass() != Patch.class || ht.containsValue(pa = (Patch)ln)) continue;
                    ht.put(pa.layer.getZ(), pa);
                    list2.add(pa);
                }
            }
            list1.clear();
            list1.addAll(list2);
        }
    }

    @Override
    public void exportXML(StringBuilder sb_body, String indent, XMLOptions options) {
        String in = indent + "\t";
        String path = null;
        String path2 = null;
        if (options.export_images) {
            path = options.patches_dir + this.title;
            path2 = this.project.getLoader().exportImage(this, path, false);
        }
        sb_body.append(indent).append("<t2_patch\n");
        String rel_path = null;
        if (null != path && path.equals(path2)) {
            rel_path = path2;
            int i_slash = rel_path.lastIndexOf(47);
            if (i_slash > 0 && -1 != (i_slash = rel_path.lastIndexOf(47, i_slash - 1))) {
                rel_path = rel_path.substring(i_slash + 1);
            }
        } else {
            rel_path = path2;
        }
        if (null == rel_path) {
            String ob = this.project.getLoader().getPath(this);
            path2 = null == ob ? null : ob;
            rel_path = null == path2 ? this.title : path2;
        }
        super.exportXML(sb_body, in, options);
        String[] RGB = Utils.getHexRGBColor(this.color);
        int type = this.type;
        if (-1 == this.type) {
            Utils.log2("Retrieving type for p = " + this);
            ImagePlus imp = this.project.getLoader().fetchImagePlus(this);
            if (null != imp) {
                type = imp.getType();
            }
        }
        sb_body.append(in).append("type=\"").append(type).append("\"\n").append(in).append("file_path=\"").append(rel_path).append("\"\n").append(in).append("style=\"fill-opacity:").append(this.alpha).append(";stroke:#").append(RGB[0]).append(RGB[1]).append(RGB[2]).append(";\"\n").append(in).append("o_width=\"").append(this.o_width).append("\"\n").append(in).append("o_height=\"").append(this.o_height).append("\"\n");
        if (null != this.original_path) {
            sb_body.append(in).append("original_path=\"").append(this.original_path).append("\"\n");
        }
        sb_body.append(in).append("min=\"").append(this.min).append("\"\n");
        sb_body.append(in).append("max=\"").append(this.max).append("\"\n");
        String pps = this.getPreprocessorScriptPath();
        if (null != pps) {
            sb_body.append(in).append("pps=\"").append(this.project.getLoader().makeRelativePath(pps)).append("\"\n");
        }
        sb_body.append(in).append("mres=\"").append(this.meshResolution).append("\"\n");
        if (this.hasCoordinateTransform()) {
            sb_body.append(in).append("ct_id=\"").append(this.ct_id).append("\"\n");
        }
        if (this.hasAlphaMask()) {
            sb_body.append(in).append("alpha_mask_id=\"").append(this.alpha_mask_id).append("\"\n");
        }
        sb_body.append(indent).append(">\n");
        if (this.hasCoordinateTransform() && options.include_coordinate_transform) {
            char[] ct_chars = null;
            try {
                ct_chars = this.readCoordinateTransformFile();
            }
            catch (Exception e) {
                IJError.print(e);
            }
            if (null != ct_chars) {
                sb_body.append(ct_chars).append('\n');
            } else {
                Utils.log("ERROR: could not write the CoordinateTransform to the XML file!");
            }
        }
        if (null != this.filters && this.filters.length > 0) {
            for (IFilter f : this.filters) {
                sb_body.append(f.toXML(in));
            }
        }
        super.restXML(sb_body, in, options);
        sb_body.append(indent).append("</t2_patch>\n");
    }

    private static final double getMaxMax(int type) {
        int pow = 1;
        switch (type) {
            case 1: {
                pow = 2;
                break;
            }
            case 2: {
                pow = 4;
                break;
            }
            default: {
                return 255.0;
            }
        }
        return Math.pow(256.0, pow) - 1.0;
    }

    public static void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        String type = "t2_patch";
        if (hs.contains("t2_patch")) {
            return;
        }
        sb_header.append(indent).append("<!ELEMENT t2_filter EMPTY>\n");
        sb_header.append(indent).append("<!ELEMENT t2_patch (").append(Displayable.commonDTDChildren()).append(",ict_transform,ict_transform_list,t2_filter)>\n");
        Displayable.exportDTD("t2_patch", sb_header, hs, indent);
        sb_header.append(indent).append("<!ATTLIST ").append("t2_patch").append(" file_path").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_patch").append(" original_path").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_patch").append(" type").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_patch").append(" false_color").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_patch").append(" ct").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_patch").append(" o_width").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_patch").append(" o_height").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_patch").append(" min").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_patch").append(" max").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_patch").append(" o_width").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_patch").append(" o_height").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_patch").append(" pps").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_patch").append(" mres").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_patch").append(" ct_id").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_patch").append(" alpha_mask_id").append(" NMTOKEN #REQUIRED>\n");
    }

    @Override
    public Displayable clone(Project pr, boolean copy_id) {
        long nid = copy_id ? this.id : pr.getLoader().getNextId();
        Patch copy = new Patch(pr, nid, null != this.title ? this.title.toString() : null, this.width, this.height, this.o_width, this.o_height, this.type, false, this.min, this.max, (AffineTransform)this.at.clone());
        copy.false_color = this.false_color;
        copy.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        copy.alpha = this.alpha;
        copy.visible = true;
        copy.channels = this.channels;
        copy.min = this.min;
        copy.max = this.max;
        copy.ct_id = this.ct_id;
        copy.alpha_mask_id = this.alpha_mask_id;
        if (!copy_id || pr != this.project) {
            try {
                if (0L != copy.alpha_mask_id && !Utils.safeCopy(this.createAlphaMaskFilePath(this.alpha_mask_id), copy.createAlphaMaskFilePath(copy.alpha_mask_id))) {
                    Utils.log("ERROR: could not copy alpha mask file for patch #" + this.id);
                }
            }
            catch (IOException ioe) {
                IJError.print(ioe);
                Utils.log("ERROR: could not copy alpha mask file for patch #" + this.id);
            }
            try {
                if (0L != copy.ct_id && !Utils.safeCopy(this.createCTFilePath(this.ct_id), copy.createCTFilePath(copy.ct_id))) {
                    Utils.log("ERROR: could not copy coordinate transform file for patch #" + this.id);
                }
            }
            catch (IOException ioe) {
                IJError.print(ioe);
                Utils.log("ERROR: could not copy coordinate transform file for patch #" + this.id);
            }
        }
        copy.addToDatabase();
        pr.getLoader().addedPatchFrom(this.project.getLoader().getAbsolutePath(this), copy);
        String pspath = this.project.getLoader().getPreprocessorScriptPath(this);
        if (null != pspath) {
            pr.getLoader().setPreprocessorScriptPathSilently(copy, pspath);
        }
        if (null != this.filters) {
            copy.filters = FilterEditor.duplicate(this.filters);
        }
        return copy;
    }

    public TransformProperties getTransformPropertiesCopy() {
        return new TransformProperties(this);
    }

    @Override
    public boolean linkPatches() {
        Utils.log2("Patch class can't link other patches using Displayable.linkPatches()");
        return false;
    }

    @Override
    public void paintSnapshot(Graphics2D g, Layer layer, List<Layer> layers, Rectangle srcRect, double mag) {
        switch (layer.getParent().getSnapshotsMode()) {
            case 0: {
                if (!this.project.getLoader().isSnapPaintable(this.id)) {
                    this.paintAsBox(g);
                } else {
                    this.paint(g, srcRect, mag, false, this.channels, layer, layers);
                }
                return;
            }
            case 1: {
                this.paintAsBox(g);
                return;
            }
        }
    }

    protected static void crosslink(Collection<Displayable> patches, boolean overlapping_only) {
        if (null == patches) {
            return;
        }
        ArrayList<Patch> al = new ArrayList<Patch>();
        for (Displayable ob : patches) {
            if (!(ob instanceof Patch)) continue;
            al.add((Patch)ob);
        }
        int len = al.size();
        if (len < 2) {
            return;
        }
        Patch[] pa = new Patch[len];
        al.toArray(pa);
        for (int i = 0; i < pa.length; ++i) {
            for (int j = i + 1; j < pa.length; ++j) {
                if (overlapping_only && !pa[i].intersects(pa[j])) continue;
                pa[i].link(pa[j]);
            }
        }
    }

    public int getPixel(double mag, int x, int y) {
        int[] iArray = this.getPixel(x, y, mag);
        if (4 == this.type) {
            return (iArray[0] << 16) + (iArray[1] << 8) + iArray[2];
        }
        return iArray[0];
    }

    public int[] getPixel(double mag, int x, int y, int[] iArray) {
        int[] ia = this.getPixel(x, y, mag);
        if (null != iArray) {
            iArray[0] = ia[0];
            iArray[1] = ia[1];
            iArray[2] = ia[2];
            return iArray;
        }
        return ia;
    }

    public int[] getPixel(int x, int y, double mag) {
        if (this.project.getLoader().isUnloadable(this)) {
            return new int[4];
        }
        MipMapImage mipMap = this.project.getLoader().fetchImage(this, mag);
        if (Loader.isSignalImage(mipMap.image)) {
            return new int[4];
        }
        int w = mipMap.image.getWidth(null);
        Point2D.Double pd = this.inverseTransformPoint(x, y);
        int x2 = (int)(pd.x / mipMap.scaleX);
        int y2 = (int)(pd.y / mipMap.scaleY);
        int[] pvalue = new int[4];
        PixelGrabber pg = new PixelGrabber(mipMap.image, x2, y2, 1, 1, pvalue, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException ie) {
            return pvalue;
        }
        this.approximateTransferPixel(pvalue);
        return pvalue;
    }

    protected void approximateTransferPixel(int[] pvalue) {
        switch (this.type) {
            case 3: 
            case 4: {
                int c = pvalue[0];
                pvalue[0] = (c & 0xFF0000) >> 16;
                pvalue[1] = (c & 0xFF00) >> 8;
                pvalue[2] = c & 0xFF;
                break;
            }
            case 0: {
                pvalue[0] = pvalue[0] & 0xFF;
                break;
            }
            case 1: {
                pvalue[0] = pvalue[0] & 0xFF;
                pvalue[0] = (int)(this.min + (double)pvalue[0] * ((this.max - this.min) / 256.0));
                break;
            }
            case 2: {
                pvalue[0] = pvalue[0] & 0xFF;
                pvalue[0] = Float.floatToIntBits((float)(this.min + (double)pvalue[0] * ((this.max - this.min) / 256.0)));
            }
        }
    }

    public final String getFilePath() {
        if (null != this.current_path) {
            return this.current_path;
        }
        return this.project.getLoader().getAbsolutePath(this);
    }

    public final String getImageFilePath() {
        return this.project.getLoader().getImageFilePath(this);
    }

    public final String getCurrentPath() {
        return this.current_path;
    }

    public final void cacheCurrentPath(String path) {
        this.current_path = path;
    }

    public synchronized String getOriginalPath() {
        return this.original_path;
    }

    @Override
    protected void setAlpha(float alpha, boolean update) {
        if (this.isStack()) {
            HashMap<Double, Patch> ht = new HashMap<Double, Patch>();
            this.getStackPatchesNR(ht);
            for (Patch pa : ht.values()) {
                pa.alpha = alpha;
                pa.updateInDatabase("alpha");
                Display.repaint(pa.layer, (Displayable)pa, 5);
            }
            Display3D.setTransparency(this, alpha);
        } else {
            super.setAlpha(alpha, update);
        }
    }

    public void debug() {
        Utils.log2("Patch id=" + this.id + "\n\toriginal_path=" + this.original_path + "\n\tcurrent_path=" + this.current_path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean revert() {
        Patch patch = this;
        synchronized (patch) {
            if (null == this.original_path) {
                return false;
            }
            if (!new File(this.original_path).exists()) {
                Utils.log("CANNOT revert: Original file path does not exist: " + this.original_path + " for patch " + this.getTitle() + " #" + this.id);
                return false;
            }
            ImagePlus imp = this.project.getLoader().fetchOriginal(this);
            if (null == imp || null == this.set(imp)) {
                Utils.log("CANNOT REVERT: original image at path " + this.original_path + " fails to load, for patch " + this.getType() + " #" + this.id);
                return false;
            }
            if (this.isStack()) {
                for (Patch p : this.getStackPatches()) {
                    p.project.getLoader().addedPatchFrom(p.original_path, p);
                    p.project.getLoader().cacheImagePlus(p.id, imp);
                    p.project.getLoader().regenerateMipMaps(p);
                }
            } else {
                this.project.getLoader().addedPatchFrom(this.original_path, this);
                this.project.getLoader().cacheImagePlus(this.id, imp);
                this.project.getLoader().regenerateMipMaps(this);
            }
        }
        Display.repaint(this.layer, (Displayable)this, 0);
        Utils.showStatus("Reverted patch " + this.getTitle(), false);
        return true;
    }

    public void setCoordinateTransformSilently(mpicbg.trakem2.transform.CoordinateTransform ct) {
        try {
            if (0L == this.ct_id) {
                this.setNewCoordinateTransform(ct);
            } else {
                this.writeNewCoordinateTransform(ct, this.ct_id);
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
    }

    public final void setCoordinateTransform(mpicbg.trakem2.transform.CoordinateTransform ct) {
        Rectangle box;
        mpicbg.trakem2.transform.TransformMesh mesh;
        mpicbg.trakem2.transform.CoordinateTransform this_ct;
        if (this.isLinked()) {
            Utils.log("Cannot set coordinate transform: patch is linked!");
            return;
        }
        mpicbg.trakem2.transform.CoordinateTransform coordinateTransform = this_ct = this.hasCoordinateTransform() ? this.getCoordinateTransform() : null;
        if (null != this_ct) {
            mesh = new mpicbg.trakem2.transform.TransformMesh((CoordinateTransform)this_ct, this.meshResolution, (double)this.o_width, (double)this.o_height);
            box = mesh.getBoundingBox();
            this.at.translate(-box.x, -box.y);
            this.updateInDatabase("transform+dimensions");
        }
        try {
            this.setNewCoordinateTransform(ct);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this_ct = ct;
        this.updateInDatabase("ict_transform");
        if (null == this_ct) {
            this.width = this.o_width;
            this.height = this.o_height;
            this.updateBucket();
            return;
        }
        mesh = new mpicbg.trakem2.transform.TransformMesh((CoordinateTransform)this_ct, this.meshResolution, (double)this.o_width, (double)this.o_height);
        box = mesh.getBoundingBox();
        this.at.translate(box.x, box.y);
        this.width = box.width;
        this.height = box.height;
        this.updateInDatabase("transform+dimensions");
        this.updateBucket();
    }

    public final void appendCoordinateTransform(mpicbg.trakem2.transform.CoordinateTransform ct) {
        if (!this.hasCoordinateTransform()) {
            this.setCoordinateTransform(ct);
        } else {
            CoordinateTransformList ctl;
            mpicbg.trakem2.transform.CoordinateTransform this_ct = this.getCoordinateTransform();
            if (this_ct instanceof CoordinateTransformList) {
                ctl = (CoordinateTransformList)this_ct.copy();
            } else {
                ctl = new CoordinateTransformList();
                ctl.add((CoordinateTransform)this_ct);
            }
            ctl.add((CoordinateTransform)ct);
            this.setCoordinateTransform((mpicbg.trakem2.transform.CoordinateTransform)ctl);
        }
    }

    public final void preAppendCoordinateTransform(mpicbg.trakem2.transform.CoordinateTransform ct) {
        if (!this.hasCoordinateTransform()) {
            this.setCoordinateTransform(ct);
        } else {
            CoordinateTransformList ctl;
            if (ct instanceof CoordinateTransformList) {
                ctl = (CoordinateTransformList)ct.copy();
            } else {
                ctl = new CoordinateTransformList();
                ctl.add((CoordinateTransform)ct);
            }
            ctl.add((CoordinateTransform)this.getCoordinateTransform());
            this.setCoordinateTransform((mpicbg.trakem2.transform.CoordinateTransform)ctl);
        }
    }

    public final Rectangle getCoordinateTransformBoundingBox() {
        if (!this.hasCoordinateTransform()) {
            return new Rectangle(0, 0, this.o_width, this.o_height);
        }
        return Patch.getCoordinateTransformBoundingBox(this, this.getCoordinateTransform());
    }

    protected static final Rectangle getCoordinateTransformBoundingBox(Patch p, mpicbg.trakem2.transform.CoordinateTransform ct) {
        if (!p.hasCoordinateTransform()) {
            return new Rectangle(0, 0, p.o_width, p.o_height);
        }
        mpicbg.trakem2.transform.TransformMesh mesh = new mpicbg.trakem2.transform.TransformMesh((CoordinateTransform)ct, p.meshResolution, (double)p.o_width, (double)p.o_height);
        return mesh.getBoundingBox();
    }

    public final mpicbg.trakem2.transform.CoordinateTransform getCoordinateTransform() {
        return this.getCT();
    }

    public final mpicbg.trakem2.transform.CoordinateTransform getFullCoordinateTransform() {
        mpicbg.trakem2.transform.CoordinateTransform ctp = this.getCoordinateTransform();
        if (ctp == null) {
            mpicbg.trakem2.transform.AffineModel2D affine = new mpicbg.trakem2.transform.AffineModel2D();
            affine.set(this.at);
            return affine;
        }
        Rectangle box = this.getCoordinateTransformBoundingBox();
        AffineTransform at2 = new AffineTransform(this.at);
        at2.translate(-box.x, -box.y);
        mpicbg.trakem2.transform.AffineModel2D affine = new mpicbg.trakem2.transform.AffineModel2D();
        affine.set(at2);
        CoordinateTransformList ctl = new CoordinateTransformList();
        ctl.add((CoordinateTransform)ctp);
        ctl.add((CoordinateTransform)affine);
        return ctl;
    }

    public final PatchImage createCoordinateTransformedImage() {
        if (!this.hasCoordinateTransform()) {
            return null;
        }
        mpicbg.trakem2.transform.CoordinateTransform ct = this.getCoordinateTransform();
        ImageProcessor source = this.getImageProcessor();
        if (null == source) {
            return null;
        }
        mpicbg.trakem2.transform.TransformMesh mesh = new mpicbg.trakem2.transform.TransformMesh((CoordinateTransform)ct, this.meshResolution, (double)this.o_width, (double)this.o_height);
        Rectangle box = mesh.getBoundingBox();
        long b = 2 * this.o_width * this.o_height + 2 * box.width * box.height + 5 * this.o_width * this.o_height + 5 * box.width * box.height;
        this.project.getLoader().releaseToFit(b);
        TransformMeshMapping mapping = new TransformMeshMapping(mesh);
        TransformMeshMappingWithMasks.ImageProcessorWithMasks target = mapping.createMappedMaskedImageInterpolated(source, (ImageProcessor)this.getAlphaMask());
        target.ip.setColorModel(source.getColorModel());
        return new PatchImage(target.ip, (ByteProcessor)target.mask, target.outside, box, true);
    }

    public PatchImage createTransformedImage() {
        PatchImage pi = this.createCoordinateTransformedImage();
        if (null != pi) {
            return pi;
        }
        ImageProcessor ip = this.getImageProcessor();
        if (null == ip) {
            return null;
        }
        this.project.getLoader().releaseToFit(this.o_width, this.o_height, this.type, 3.0f);
        ImageProcessor copy = ip.duplicate();
        copy.setColorModel(ip.getColorModel());
        return new PatchImage(copy, this.getAlphaMask(), null, new Rectangle(0, 0, this.o_width, this.o_height), false);
    }

    public final boolean hasAlphaMask() {
        return 0L != this.alpha_mask_id;
    }

    public long getAlphaMaskId() {
        return this.alpha_mask_id;
    }

    public String getAlphaMaskFilePath() {
        return this.hasAlphaMask() ? this.createAlphaMaskFilePath(this.alpha_mask_id) : null;
    }

    public boolean hasAlphaChannel() {
        return this.hasCoordinateTransform() || this.hasAlphaMask();
    }

    public synchronized boolean setAlphaMask(ByteProcessor bp) throws IllegalArgumentException {
        if (null == bp) {
            this.alpha_mask_id = 0L;
            return true;
        }
        if (this.o_width != bp.getWidth() || this.o_height != bp.getHeight()) {
            throw new IllegalArgumentException("Need a mask of identical dimensions as the original image.");
        }
        long amID = this.project.getLoader().getNextBlobId();
        if (this.writeAlphaMask(bp, amID)) {
            this.alpha_mask_id = amID;
            return true;
        }
        Utils.log("Could NOT write the alpha mask file for patch #" + this.id);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ByteProcessor getAlphaMask() {
        if (0L == this.alpha_mask_id) {
            return null;
        }
        String path = this.createAlphaMaskFilePath(this.alpha_mask_id);
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new FileInputStream(path));
            ZipEntry ze = zis.getNextEntry();
            ImageProcessor mask = new FileOpener(new TiffDecoder((InputStream)zis, ze.getName()).getTiffInfo()[0]).open(false).getProcessor();
            if (mask.getWidth() != this.o_width || mask.getHeight() != this.o_height) {
                Utils.log2("Mask has improper dimensions: " + mask.getWidth() + " x " + mask.getHeight() + " for patch #" + this.id + " which is of " + this.o_width + " x " + this.o_height);
                ByteProcessor byteProcessor = null;
                return byteProcessor;
            }
            ByteProcessor byteProcessor = (ByteProcessor)(mask.getClass() == ByteProcessor.class ? mask : mask.convertToByte(false));
            return byteProcessor;
        }
        catch (Throwable t) {
            Utils.log2("Could not load alpha mask for patch #" + this.id + " from file " + path);
            IJError.print(t);
            ByteProcessor byteProcessor = null;
            return byteProcessor;
        }
        finally {
            try {
                if (null != zis) {
                    zis.close();
                }
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
    }

    private final String createAlphaMaskFilePath(long amID) {
        FSLoader l = (FSLoader)this.project.getLoader();
        return l.getMasksFolder() + FSLoader.createIdPath(Long.toString(amID), Long.toString(this.id), ".zip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized boolean writeAlphaMask(ByteProcessor bp, long amID) {
        RandomAccessFile ra = null;
        try {
            File f = new File(this.createAlphaMaskFilePath(amID));
            Utils.ensure(f);
            ra = new RandomAccessFile(f, "rw");
            ByteArrayOutputStream ba = new ByteArrayOutputStream(bp.getWidth() * bp.getHeight());
            ZipOutputStream zos = new ZipOutputStream(ba);
            ImagePlus imp = new ImagePlus("mask.tif", (ImageProcessor)bp);
            zos.putNextEntry(new ZipEntry(imp.getTitle()));
            TiffEncoder te = new TiffEncoder(imp.getFileInfo());
            te.write((OutputStream)zos);
            zos.flush();
            zos.closeEntry();
            zos.close();
            ra.write((byte[])ImageSaver.Bbuf.get(ba), 0, ba.size());
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            IJError.print(e);
        }
        finally {
            try {
                if (null != ra) {
                    ra.close();
                }
            }
            catch (Throwable t) {
                IJError.print(t);
            }
        }
        return false;
    }

    public boolean checkAlphaMaskFile() {
        if (0L == this.alpha_mask_id) {
            return true;
        }
        return new File(this.createAlphaMaskFilePath(this.alpha_mask_id)).exists();
    }

    public boolean paintsWithFalseColor() {
        return this.false_color;
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        Object source = ke.getSource();
        if (!(source instanceof DisplayCanvas)) {
            return;
        }
        DisplayCanvas dc = (DisplayCanvas)source;
        final Roi roi = dc.getFakeImagePlus().getRoi();
        final int mod = ke.getModifiers();
        switch (ke.getKeyCode()) {
            case 67: {
                if (0 == (mod ^ 9)) {
                    ImagePlus imp = this.getImagePlus();
                    if (null != imp) {
                        imp.copy(false);
                    }
                } else if (0 == mod || 0 == (mod ^ 1)) {
                    ImageProcessor ip;
                    CoordinateTransformList list = null;
                    if (this.hasCoordinateTransform()) {
                        list = new CoordinateTransformList();
                        list.add((CoordinateTransform)this.getCoordinateTransform());
                    }
                    if (0 == mod) {
                        mpicbg.trakem2.transform.AffineModel2D am = new mpicbg.trakem2.transform.AffineModel2D();
                        am.set(this.at);
                        if (null == list) {
                            list = new CoordinateTransformList();
                        }
                        list.add((CoordinateTransform)am);
                    }
                    if (null != list) {
                        mpicbg.trakem2.transform.TransformMesh mesh = new mpicbg.trakem2.transform.TransformMesh((CoordinateTransform)list, this.meshResolution, (double)this.o_width, (double)this.o_height);
                        TransformMeshMapping mapping = new TransformMeshMapping(mesh);
                        ip = mapping.createMappedImageInterpolated(this.getImageProcessor());
                    } else {
                        ip = this.getImageProcessor();
                    }
                    new ImagePlus(this.title, ip).copy(false);
                }
                ke.consume();
                break;
            }
            case 70: {
                if (null != roi && M.isAreaROI(roi)) {
                    Bureaucrat.createAndStart((Worker)new Worker.Task("Filling image mask"){

                        @Override
                        public void exec() {
                            Patch.this.getLayerSet().addDataEditStep(Patch.this);
                            if (0 == mod) {
                                Patch.this.addAlphaMask(roi, ProjectToolbar.getForegroundColorValue());
                            } else if (0 == (mod ^ 1)) {
                                try {
                                    Area localRoi = M.areaInInts(M.getArea(roi)).createTransformedArea(Patch.this.at.createInverse());
                                    Area invLocalRoi = new Area(new Rectangle(0, 0, Patch.this.getOWidth(), Patch.this.getOHeight()));
                                    invLocalRoi.subtract(localRoi);
                                    Patch.this.addAlphaMaskLocal(invLocalRoi, ProjectToolbar.getForegroundColorValue());
                                }
                                catch (NoninvertibleTransformException e) {
                                    IJError.print(e);
                                    return;
                                }
                            }
                            Patch.this.getLayerSet().addDataEditStep(Patch.this);
                            try {
                                Patch.this.updateMipMaps().get();
                            }
                            catch (Throwable t) {
                                IJError.print(t);
                            }
                            Display.repaint();
                        }
                    }, this.project);
                }
                ke.consume();
                break;
            }
            default: {
                super.keyPressed(ke);
            }
        }
    }

    @Override
    Class<?> getInternalDataPackageClass() {
        return DPPatch.class;
    }

    @Override
    Object getDataPackage() {
        return new DPPatch(this);
    }

    @Override
    public boolean contains(double x_p, double y_p) {
        if (!this.hasAlphaChannel()) {
            return super.contains(x_p, y_p);
        }
        if (this.project.getLoader().isUnloadable(this)) {
            return super.contains(x_p, y_p);
        }
        MipMapImage mipMap = this.project.getLoader().fetchImage(this, 0.12499);
        if (Loader.isSignalImage(mipMap.image)) {
            return super.contains(x_p, y_p);
        }
        int w = mipMap.image.getWidth(null);
        Point2D.Double pd = this.inverseTransformPoint(x_p, y_p);
        int x2 = (int)(pd.x / mipMap.scaleX);
        int y2 = (int)(pd.y / mipMap.scaleY);
        int[] pvalue = new int[1];
        PixelGrabber pg = new PixelGrabber(mipMap.image, x2, y2, 1, 1, pvalue, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException ie) {
            return super.contains(x_p, y_p);
        }
        return 0 != (pvalue[0] & 0xFF000000);
    }

    public void setPreprocessorScriptPath(String path) {
        String old_path = this.project.getLoader().getPreprocessorScriptPath(this);
        if (null == path && null == old_path) {
            return;
        }
        this.project.getLoader().setPreprocessorScriptPath(this, path);
        if (null != old_path || null != path) {
            ImagePlus imp = this.getImagePlus();
            int w = imp.getWidth();
            int h = imp.getHeight();
            imp = null;
            if (w != this.o_width || h != this.o_height) {
                int old_o_width = this.o_width;
                int old_o_height = this.o_height;
                this.o_width = w;
                this.o_height = h;
                double old_width = this.width;
                double old_height = this.height;
                this.width = (float)((double)this.width * ((double)this.o_width / (double)old_o_width));
                this.height = (float)((double)this.height * ((double)this.o_height / (double)old_o_height));
                AffineTransform aff = new AffineTransform();
                aff.translate((old_width - (double)this.width) / 2.0, (old_height - (double)this.height) / 2.0);
                this.updateInDatabase("dimensions");
                this.preTransform(aff, false);
            }
        }
    }

    public void addAlphaMask(Roi roi, int value) {
        if (null == roi || !M.isAreaROI(roi)) {
            return;
        }
        this.addAlphaMask(M.areaInInts(M.getArea(roi)), value);
    }

    public void addAlphaMask(Area aw, int value) {
        try {
            this.addAlphaMaskLocal(aw.createTransformedArea(this.at.createInverse()), value);
        }
        catch (NoninvertibleTransformException nite) {
            IJError.print(nite);
        }
    }

    public void addAlphaMaskLocal(Area aLocal, int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > 255) {
            value = 255;
        }
        mpicbg.trakem2.transform.CoordinateTransform ct = null;
        if (this.hasCoordinateTransform() && null == (ct = this.getCT())) {
            return;
        }
        Area a = new Area(new Rectangle(0, 0, (int)(this.width + 1.0f), (int)(this.height + 1.0f)));
        a.intersect(aLocal);
        if (M.isEmpty(a)) {
            Utils.log("ROI does not intersect the active image!");
            return;
        }
        ByteProcessor mask = this.getAlphaMask();
        int background = null != mask && 255 == value ? 0 : 255;
        ShapeList shapeList = new ShapeList(new int[]{(int)this.width, (int)this.height, 1}, (Type)new UnsignedByteType(background));
        shapeList.addShape((Shape)a, (Type)new UnsignedByteType(value), new int[]{0});
        mpicbg.imglib.image.Image shapeListImage = new mpicbg.imglib.image.Image((Container)shapeList, shapeList.getBackground(), "mask");
        ByteProcessor rmask = (ByteProcessor)ImageJFunctions.copyToImagePlus((mpicbg.imglib.image.Image)shapeListImage, (int)0).getProcessor();
        if (this.hasCoordinateTransform()) {
            mpicbg.trakem2.transform.TransformMesh mesh = new mpicbg.trakem2.transform.TransformMesh((CoordinateTransform)ct, this.meshResolution, (double)this.o_width, (double)this.o_height);
            TransformMeshMapping mapping = new TransformMeshMapping(mesh);
            rmask = (ByteProcessor)mapping.createInverseMappedImageInterpolated((ImageProcessor)rmask);
        }
        if (null == mask) {
            mask = rmask;
        } else {
            byte[] b1 = (byte[])mask.getPixels();
            byte[] b2 = (byte[])rmask.getPixels();
            for (int i = 0; i < b1.length; ++i) {
                if (background == (b2[i] & 0xFF)) continue;
                b1[i] = b2[i];
            }
        }
        this.setAlphaMask(mask);
    }

    public String getPreprocessorScriptPath() {
        return this.project.getLoader().getPreprocessorScriptPath(this);
    }

    public boolean isPreprocessed() {
        return null != this.getPreprocessorScriptPath() || null != this.filters;
    }

    @Override
    public Area getArea() {
        mpicbg.trakem2.transform.CoordinateTransform ct = null;
        if (this.hasAlphaMask()) {
            ByteProcessor alpha_mask = this.getAlphaMask();
            if (null == alpha_mask) {
                Utils.log2("Could not retrieve alpha mask for " + this);
            } else {
                if (this.hasCoordinateTransform()) {
                    ct = this.getCoordinateTransform();
                    mpicbg.trakem2.transform.TransformMesh mesh = new mpicbg.trakem2.transform.TransformMesh((CoordinateTransform)ct, this.meshResolution, (double)this.o_width, (double)this.o_height);
                    TransformMeshMapping mapping = new TransformMeshMapping(mesh);
                    alpha_mask = mapping.createMappedImage((ImageProcessor)alpha_mask);
                }
                alpha_mask.setThreshold(1.0, 255.0, 2);
                ImagePlus imp = new ImagePlus("", (ImageProcessor)alpha_mask);
                ThresholdToSelection tts = new ThresholdToSelection();
                tts.setup("", imp);
                tts.run((ImageProcessor)alpha_mask);
                Roi roi = imp.getRoi();
                if (null == roi) {
                    return new Area();
                }
                return M.getArea(roi).createTransformedArea(this.at);
            }
        }
        int[] x = new int[this.o_width + this.o_width + this.o_height + this.o_height];
        int[] y = new int[x.length];
        int next = 0;
        int i = 0;
        while (i <= this.o_width) {
            x[next] = i++;
            y[next] = 0;
            ++next;
        }
        i = 1;
        while (i <= this.o_height) {
            x[next] = this.o_width;
            y[next] = i++;
            ++next;
        }
        i = this.o_width - 1;
        while (i > -1) {
            x[next] = i--;
            y[next] = this.o_height;
            ++next;
        }
        i = this.o_height - 1;
        while (i > 0) {
            x[next] = 0;
            y[next] = i--;
            ++next;
        }
        if (this.hasCoordinateTransform() && null == ct) {
            ct = this.getCoordinateTransform();
        }
        if (null != ct) {
            CoordinateTransformList t = new CoordinateTransformList();
            t.add((CoordinateTransform)ct);
            mpicbg.trakem2.transform.TransformMesh mesh = new mpicbg.trakem2.transform.TransformMesh((CoordinateTransform)ct, this.meshResolution, (double)this.o_width, (double)this.o_height);
            Rectangle box = mesh.getBoundingBox();
            AffineTransform aff = new AffineTransform(this.at);
            aff.translate(-box.x, -box.y);
            mpicbg.trakem2.transform.AffineModel2D affm = new mpicbg.trakem2.transform.AffineModel2D();
            affm.set(aff);
            t.add((CoordinateTransform)affm);
            double[] f = new double[]{x[0], y[0]};
            t.applyInPlace(f);
            Path2D.Float path = new Path2D.Float(0, x.length + 1);
            path.moveTo(f[0], f[1]);
            for (int i2 = 1; i2 < x.length; ++i2) {
                f[0] = x[i2];
                f[1] = y[i2];
                t.applyInPlace(f);
                path.lineTo(f[0], f[1]);
            }
            path.closePath();
            return new Area(path);
        }
        return new Area(new Polygon(x, y, x.length)).createTransformedArea(this.at);
    }

    public static ImageProcessor makeFlatImage(int type, Layer layer, Rectangle srcRect, double scale, Collection<Patch> patches, Color background) {
        return Patch.makeFlatImage(type, layer, srcRect, scale, patches, background, true);
    }

    public static ImageProcessor makeFlatImage(int type, Layer layer, Rectangle srcRect, double scale, Collection<Patch> patches, Color background, boolean setMinAndMax) {
        ByteProcessor ip;
        int H;
        int W;
        if (scale < 1.0) {
            W = (int)((double)srcRect.width * scale);
            H = (int)((double)srcRect.height * scale);
        } else {
            W = srcRect.width;
            H = srcRect.height;
        }
        switch (type) {
            case 0: {
                ip = new ByteProcessor(W, H);
                break;
            }
            case 1: {
                ip = new ShortProcessor(W, H);
                break;
            }
            case 2: {
                ip = new FloatProcessor(W, H);
                break;
            }
            case 4: {
                ip = new ColorProcessor(W, H);
                break;
            }
            default: {
                Utils.logAll("Cannot create an image of type " + type + ".\nSupported types: 8-bit, 16-bit, 32-bit and RGB.");
                return null;
            }
        }
        if (null != background && Color.black != background) {
            ip.setColor(background);
            ip.fill();
        }
        mpicbg.trakem2.transform.AffineModel2D sc = null;
        if (scale < 1.0) {
            sc = new mpicbg.trakem2.transform.AffineModel2D();
            sc.set(scale, 0.0, 0.0, scale, 0.0, 0.0);
        }
        for (Patch p : patches) {
            CoordinateTransformList list = new CoordinateTransformList();
            AffineTransform at = new AffineTransform();
            at.translate(-srcRect.x, -srcRect.y);
            at.concatenate(p.getAffineTransform());
            if (p.hasCoordinateTransform()) {
                mpicbg.trakem2.transform.CoordinateTransform ct = p.getCoordinateTransform();
                list.add((CoordinateTransform)ct);
                Rectangle box = Patch.getCoordinateTransformBoundingBox(p, ct);
                at.translate(-box.x, -box.y);
            }
            mpicbg.trakem2.transform.AffineModel2D patch_affine = new mpicbg.trakem2.transform.AffineModel2D();
            patch_affine.set(at);
            list.add((CoordinateTransform)patch_affine);
            if (null != sc) {
                patch_affine.preConcatenate((AffineModel2D)sc);
            }
            CoordinateTransformMesh mesh = new CoordinateTransformMesh((CoordinateTransform)list, p.meshResolution, (double)p.getOWidth(), (double)p.getOHeight());
            mpicbg.ij.TransformMeshMapping mapping = new mpicbg.ij.TransformMeshMapping((TransformMesh)mesh);
            ImageProcessor pi = p.getImageProcessor();
            if (setMinAndMax) {
                pi = pi.duplicate();
                pi.setMinAndMax(p.min, p.max);
            }
            switch (type) {
                case 0: {
                    pi = pi.convertToByte(true);
                    break;
                }
                case 1: {
                    pi = pi.convertToShort(true);
                    break;
                }
                case 2: {
                    pi = pi.convertToFloat();
                    break;
                }
                default: {
                    pi = pi.convertToRGB();
                }
            }
            mapping.mapInterpolated(pi, (ImageProcessor)ip);
        }
        return ip;
    }

    @Deprecated
    public static final ImageProcessor makeFlatGrayImage(List<Patch> patches, Rectangle finalBox, int backgroundValue, double scale) {
        return new ExportBestFlatImage(patches, finalBox, backgroundValue, scale).makeFlatGrayImage();
    }

    public boolean maskBorder(int size) {
        return this.maskBorder(size, size, size, size);
    }

    public boolean maskBorder(int left, int top, int right, int bottom) {
        int w = this.o_width - right - left;
        int h = this.o_height - top - bottom;
        if (w < 0 || h < 0 || left > this.o_width || top > this.o_height) {
            Utils.log("Cannot cut border for patch " + this + " : border off image bounds.");
            return false;
        }
        try {
            ByteProcessor bp = this.getAlphaMask();
            if (null == bp) {
                bp = new ByteProcessor(this.o_width, this.o_height);
                bp.setRoi(new Roi(left, top, w, h));
                bp.setValue(255.0);
                bp.fill();
            } else {
                bp.setValue(0.0);
                for (Roi r : new Roi[]{new Roi(0, 0, this.o_width, top), new Roi(0, top, left, this.o_height - top - bottom), new Roi(0, this.o_height - bottom, this.o_width, bottom), new Roi(this.o_width - right, top, right, this.o_height - top - bottom)}) {
                    bp.setRoi(r);
                    bp.fill();
                }
            }
            this.setAlphaMask(bp);
        }
        catch (Exception e) {
            IJError.print(e);
            return false;
        }
        return true;
    }

    @Override
    protected Area getAreaForBucket(Layer l) {
        return new Area(this.getPerimeter());
    }

    @Override
    protected boolean isRoughlyInside(Layer l, Rectangle r) {
        return l == this.layer && r.intersects(this.getBoundingBox());
    }

    public boolean intersects(Displayable d, boolean sloppy) {
        if (sloppy) {
            return this.getBoundingBox().intersects(d.getBoundingBox());
        }
        if (this.hasAlphaChannel()) {
            if (!this.getBoundingBox().intersects(d.getBoundingBox())) {
                return false;
            }
            return M.intersects(this.getArea(), d.getAreaAt(this.layer));
        }
        return super.intersects(d);
    }

    @Override
    public boolean intersects(Displayable d) {
        return this.intersects(d, false);
    }

    public void appendFilters(IFilter[] fs) {
        int i;
        if (null == this.filters || 0 == this.filters.length) {
            this.filters = fs;
            return;
        }
        if (null == fs) {
            return;
        }
        IFilter[] c = new IFilter[this.filters.length + fs.length];
        for (i = 0; i < this.filters.length; ++i) {
            c[i] = this.filters[i];
        }
        for (i = this.filters.length; i < c.length; ++i) {
            c[i] = fs[i - this.filters.length];
        }
        this.filters = c;
    }

    public void setFilters(IFilter[] fs) {
        this.filters = fs;
    }

    public IFilter[] getFilters() {
        return this.filters;
    }

    public boolean hasCoordinateTransform() {
        return 0L != this.ct_id;
    }

    public long getCoordinateTransformId() {
        return this.ct_id;
    }

    public String getCoordinateTransformFilePath() {
        return this.hasCoordinateTransform() ? this.createCTFilePath(this.ct_id) : null;
    }

    private final String createCTFilePath(long ctID) {
        FSLoader l = (FSLoader)this.project.getLoader();
        return l.getCoordinateTransformsFolder() + FSLoader.createIdPath(Long.toString(ctID), Long.toString(this.id), ".ct");
    }

    private final mpicbg.trakem2.transform.CoordinateTransform getCT() {
        try {
            return this.fetchCoordinateTransform();
        }
        catch (Exception e) {
            IJError.print(e);
            throw new RuntimeException(e);
        }
    }

    public synchronized mpicbg.trakem2.transform.CoordinateTransform fetchCoordinateTransform() throws Exception {
        return this.hasCoordinateTransform() ? CoordinateTransformXML.parse(this.createCTFilePath(this.ct_id)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized char[] readCoordinateTransformFile() throws Exception {
        File f = new File(this.createCTFilePath(this.ct_id));
        char[] c = new char[(int)f.length()];
        Reader reader = null;
        try {
            int r;
            reader = new BufferedReader(new FileReader(f), 32768);
            for (int s = 0; s < c.length && -1 != (r = reader.read(c, s, c.length - s)); s += r) {
            }
            char[] cArray = c;
            return cArray;
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
    }

    protected synchronized boolean setNewCoordinateTransform(mpicbg.trakem2.transform.CoordinateTransform ct) throws Exception {
        if (null == ct) {
            this.ct_id = 0L;
            return true;
        }
        long ctID = this.project.getLoader().getNextBlobId();
        if (this.writeNewCoordinateTransform(ct, ctID)) {
            this.ct_id = ctID;
            return true;
        }
        Utils.log("Could NOT write the CoordinateTransform file for patch #" + this.id);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean writeNewCoordinateTransform(mpicbg.trakem2.transform.CoordinateTransform ct, long ctID) throws Exception {
        RandomAccessFile ra = null;
        try {
            File f = new File(this.createCTFilePath(ctID));
            Utils.ensure(f);
            ra = new RandomAccessFile(f, "rw");
            ra.write(ct.toXML("\t\t\t\t").getBytes());
            boolean bl = true;
            return bl;
        }
        finally {
            if (null != ra) {
                try {
                    ra.close();
                }
                catch (Exception e) {
                    IJError.print(e);
                }
            }
        }
    }

    public boolean checkCoordinateTransformFile() {
        if (0L == this.ct_id) {
            return true;
        }
        return new File(this.createCTFilePath(this.ct_id)).exists();
    }

    public double[] toPixelCoordinate(double world_x, double world_y) throws NoninvertibleTransformException {
        return Patch.toPixelCoordinate(world_x, world_y, this.at, this.hasCoordinateTransform() ? this.getCoordinateTransform() : null, this.meshResolution, this.o_width, this.o_height);
    }

    public static final double[] toPixelCoordinate(double world_x, double world_y, AffineTransform aff, mpicbg.trakem2.transform.CoordinateTransform ct, int meshResolution, int o_width, int o_height) throws NoninvertibleTransformException {
        double[] d = new double[]{world_x, world_y};
        aff.inverseTransform(d, 0, d, 0, 1);
        if (null != ct) {
            double[] f = new double[]{d[0], d[1]};
            InvertibleCoordinateTransform t = InvertibleCoordinateTransform.class.isAssignableFrom(ct.getClass()) ? (InvertibleCoordinateTransform)ct : new mpicbg.trakem2.transform.TransformMesh((CoordinateTransform)ct, meshResolution, (double)o_width, (double)o_height);
            try {
                t.applyInverseInPlace(f);
            }
            catch (NoninvertibleModelException noninvertibleModelException) {
                // empty catch block
            }
            d[0] = f[0];
            d[1] = f[1];
        }
        return d;
    }

    public AffineTransform getLocalAffine(double wx, double wy) {
        AffineTransform affine = new AffineTransform(this.at);
        if (this.hasCoordinateTransform()) {
            mpicbg.trakem2.transform.CoordinateTransform ct = this.getCoordinateTransform();
            double[] w = new double[]{wx, wy};
            try {
                this.at.inverseTransform(w, 0, w, 0, 1);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
            mpicbg.trakem2.transform.TransformMesh mesh = new mpicbg.trakem2.transform.TransformMesh((CoordinateTransform)ct, this.meshResolution, (double)this.o_width, (double)this.o_height);
            AffineModel2D triangle = mesh.closestTargetAffine(new double[]{w[0], w[1]});
            affine.concatenate(triangle.createAffine());
        }
        return affine;
    }

    public double getLocalScale(double wx, double wy) {
        AffineTransform affine = this.getLocalAffine(wx, wy);
        double a = affine.getScaleX();
        double b = affine.getShearX();
        double c = affine.getShearY();
        double d = affine.getScaleY();
        double l1x = a + b;
        double l1y = c + d;
        double l2x = a - b;
        double l2y = c - d;
        double l1 = Math.sqrt(l1x * l1x + l1y * l1y) / SQRT2;
        double l2 = Math.sqrt(l2x * l2x + l2y * l2y) / SQRT2;
        return (l1 + l2) / 2.0;
    }

    @Override
    public void mousePressed(MouseEvent me, Layer la, final int x_p, final int y_p, double mag) {
        int tool = ProjectToolbar.getToolId();
        final DisplayCanvas canvas = (DisplayCanvas)me.getSource();
        if (18 == tool) {
            if (null == canvas) {
                return;
            }
            Bureaucrat.createAndStart((Worker)new Worker.Task("Magic Wand ROI"){

                @Override
                public void exec() {
                    PatchImage pai = Patch.this.createTransformedImage();
                    pai.target.setMinAndMax(Patch.this.min, Patch.this.max);
                    ImagePlus patchImp = new ImagePlus("", pai.target.convertToByte(true));
                    double[] fp = new double[]{x_p, y_p};
                    try {
                        Patch.this.at.createInverse().transform(fp, 0, fp, 0, 1);
                    }
                    catch (NoninvertibleTransformException e) {
                        IJError.print(e);
                        return;
                    }
                    int npoints = IJ.doWand((ImagePlus)patchImp, (int)((int)fp[0]), (int)((int)fp[1]), (double)WandToolOptions.getTolerance(), (String)WandToolOptions.getMode());
                    if (npoints > 0) {
                        System.out.println("npoints " + npoints);
                        Roi roi = patchImp.getRoi();
                        if (null != roi) {
                            Area aroi = M.getArea(roi);
                            aroi.transform(Patch.this.at);
                            canvas.getFakeImagePlus().setRoi((Roi)new ShapeRoi((Shape)aroi));
                        }
                    }
                }
            }, this.project);
        }
    }

    public boolean clearIntensityMap() {
        boolean cleared = this.project.getLoader().clearIntensityMap(this);
        if (cleared) {
            this.project.getLoader().decacheImagePlus(this.getId());
        }
        return cleared;
    }

    static /* synthetic */ IFilter[] access$702(Patch x0, IFilter[] x1) {
        x0.filters = x1;
        return x1;
    }

    private static final class DPPatch
    extends Displayable.DataPackage {
        final double min;
        final double max;
        final long ct_id;
        final long alpha_mask_id;
        final IFilter[] filters;
        final boolean false_color;

        DPPatch(Patch patch) {
            super(patch);
            this.min = patch.min;
            this.max = patch.max;
            this.ct_id = patch.ct_id;
            this.alpha_mask_id = patch.alpha_mask_id;
            this.filters = null == patch.filters ? null : FilterEditor.duplicate(patch.filters);
            this.false_color = patch.false_color;
        }

        @Override
        final boolean to2(Displayable d) {
            super.to1(d);
            Patch p = (Patch)d;
            boolean mipmaps = false;
            if (p.min != this.min || p.max != this.max || p.ct_id != this.ct_id || p.alpha_mask_id != this.alpha_mask_id) {
                mipmaps = true;
            }
            if (!mipmaps) {
                if (null != this.filters && null == p.filters) {
                    mipmaps = true;
                } else if (null == this.filters && null != p.filters) {
                    mipmaps = true;
                } else if (null != this.filters && null != p.filters) {
                    if (this.filters.length != p.filters.length) {
                        mipmaps = true;
                    } else {
                        for (int i = 0; i < this.filters.length; ++i) {
                            if (this.filters[i].equals(p.filters[i])) continue;
                            mipmaps = false;
                            break;
                        }
                    }
                }
            }
            p.min = this.min;
            p.max = this.max;
            p.ct_id = this.ct_id;
            p.alpha_mask_id = this.alpha_mask_id;
            Patch.access$702(p, null == this.filters ? null : FilterEditor.duplicate(this.filters));
            p.false_color = this.false_color;
            if (mipmaps) {
                p.project.getLoader().regenerateMipMaps(p);
            }
            return true;
        }
    }

    public static final class PatchImage {
        public final ImageProcessor target;
        public final ByteProcessor mask;
        public final ByteProcessor outside;
        public final Rectangle box;
        public final boolean coordinate_transformed;

        private PatchImage(ImageProcessor target, ByteProcessor mask, ByteProcessor outside, Rectangle box, boolean coordinate_transformed) {
            this.target = target;
            this.mask = mask;
            this.outside = outside;
            this.box = box;
            this.coordinate_transformed = coordinate_transformed;
        }

        public final ByteProcessor getMask() {
            return this.mask == null ? (this.outside == null ? null : this.outside) : this.mask;
        }

        public final Image createImage(double min, double max) {
            ImageProcessor ip = this.target;
            ip.setMinAndMax(min, max);
            ByteProcessor alpha_mask = this.mask;
            ByteProcessor outside_mask = this.outside;
            if (null == alpha_mask) {
                alpha_mask = outside_mask;
            }
            if (null != alpha_mask) {
                return ImageSaver.createARGBImagePre(Loader.embedAlphaPre((int[])ip.convertToRGB().getPixels(), (byte[])alpha_mask.getPixels(), null == outside_mask ? null : (byte[])outside_mask.getPixels()), ip.getWidth(), ip.getHeight());
            }
            return ip.createImage();
        }
    }

    public static final class TransformProperties {
        public final Rectangle bounds;
        public final AffineTransform at;
        public final mpicbg.trakem2.transform.CoordinateTransform ct;
        public final int meshResolution;
        public final int o_width;
        public final int o_height;
        public final Area area;

        public TransformProperties(Patch p) {
            this.at = new AffineTransform(p.at);
            this.ct = p.getCoordinateTransform();
            this.meshResolution = p.getMeshResolution();
            this.bounds = p.getBoundingBox(null);
            this.o_width = p.o_width;
            this.o_height = p.o_height;
            this.area = p.getArea();
        }
    }
}

