/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging.filters;

import ij.process.ImageProcessor;
import ini.trakem2.imaging.filters.IFilter;
import java.util.Map;

public class NormalizeLocalContrast
implements IFilter {
    protected int brx = 500;
    protected int bry = 500;
    protected float stds = 3.0f;
    protected boolean cent = true;
    protected boolean stret = true;

    public NormalizeLocalContrast() {
    }

    public NormalizeLocalContrast(int blockRadiusX, int blockRadiusY, float stdDevs, boolean center, boolean stretch) {
        this.set(blockRadiusX, blockRadiusY, stdDevs, center, stretch);
    }

    private final void set(int blockRadiusX, int blockRadiusY, float stdDevs, boolean center, boolean stretch) {
        this.brx = blockRadiusX;
        this.bry = blockRadiusY;
        this.stds = stdDevs;
        this.cent = center;
        this.stret = stretch;
    }

    public NormalizeLocalContrast(Map<String, String> params) {
        try {
            this.set(Integer.parseInt(params.get("brx")), Integer.parseInt(params.get("bry")), Float.parseFloat(params.get("stds")), Boolean.parseBoolean(params.get("stret")), Boolean.parseBoolean(params.get("cent")));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Could not create LocalContrast filter!", nfe);
        }
    }

    @Override
    public ImageProcessor process(ImageProcessor ip) {
        try {
            mpicbg.ij.plugin.NormalizeLocalContrast.run((ImageProcessor)ip, (int)this.brx, (int)this.bry, (float)this.stds, (boolean)this.cent, (boolean)this.stret);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ip;
    }

    @Override
    public String toXML(String indent) {
        return indent + "<t2_filter class=\"" + this.getClass().getName() + "\" brx=\"" + this.brx + "\" bry=\"" + this.bry + "\" stds=\"" + this.stds + "\" cent=\"" + this.cent + "\" stret=\"" + this.stret + "\" />\n";
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o.getClass() == NormalizeLocalContrast.class) {
            NormalizeLocalContrast c = (NormalizeLocalContrast)o;
            return this.brx == c.brx && this.bry == c.bry && this.stds == c.stds && this.cent == c.cent && this.stret == c.stret;
        }
        return false;
    }
}

