/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.persistence;

import ij.ImagePlus;
import ij.io.FileSaver;
import ij.process.ImageProcessor;
import ini.trakem2.Project;
import ini.trakem2.display.DLabel;
import ini.trakem2.display.Display;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Patch;
import ini.trakem2.parallel.CountingTaskFactory;
import ini.trakem2.parallel.Process;
import ini.trakem2.tree.LayerThing;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.tree.TemplateThing;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import mpicbg.trakem2.transform.ExportUnsignedShort;
import mpicbg.trakem2.transform.ExportedTile;

public class ProjectTiler {
    public static final Project createRetiledSibling(Project srcProject, String targetDirectory, int tileWidth, int tileHeight, final int exportImageType, boolean onlyVisibleImages, int nExportThreads, boolean createMipMaps) throws Exception {
        String targetDir;
        String dataDir;
        File fDataDir;
        switch (exportImageType) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Can only accept GRAY8, GRAY16 or COLOR_RGB as values for 'exportImageType'!");
            }
        }
        File fdir = new File(targetDirectory);
        if (fdir.exists()) {
            if (!fdir.isDirectory() || !fdir.canWrite()) {
                throw new IllegalArgumentException("Invalid directory: not a directory or cannot write to: " + targetDirectory);
            }
        } else if (!fdir.mkdirs()) {
            throw new IllegalArgumentException("Cannot create directory at: " + targetDirectory);
        }
        if (!(!(fDataDir = new File(dataDir = (targetDir = Utils.fixDir(targetDirectory)) + "data/")).exists() || fDataDir.isDirectory() && fDataDir.canWrite())) {
            throw new IllegalArgumentException("Cannot create or write to 'data' directory in the targetDirectory at: " + targetDir);
        }
        fDataDir.mkdir();
        final Project newProject = Project.newFSProject("blank", null, targetDir, false);
        LayerSet newLayerSet = newProject.getRootLayerSet();
        newLayerSet.setCalibration(srcProject.getRootLayerSet().getCalibrationCopy());
        if (!createMipMaps) {
            Utils.log("MipMaps are DISABLED:\n --> When done, right-click and choose 'Display - Properties...' and enable mipmaps,\n     and then run 'Project - Regenerate all mipmaps'\n");
            newProject.getLoader().setMipMapsRegeneration(false);
            Utils.log("mipmaps enabled? " + newProject.getLoader().isMipMapsRegenerationEnabled());
        }
        newProject.resetRootTemplateThing(srcProject.getRootTemplateThing().clone(newProject, true), null);
        for (TemplateThing tt : newProject.getRootTemplateThing().getUniqueTypes(new HashMap<String, TemplateThing>()).values()) {
            newProject.addUniqueType(tt);
        }
        ArrayList<Layer> srcLayers = srcProject.getRootLayerSet().getLayers();
        ArrayList<Layer> newLayers = new ArrayList<Layer>();
        for (Layer srcLayer : srcLayers) {
            Layer newLayer = new Layer(newProject, srcLayer.getId(), srcLayer.getZ(), srcLayer.getThickness());
            newLayer.addToDatabase();
            newLayerSet.add(newLayer);
            newLayers.add(newLayer);
            newProject.getRootLayerThing().addChild(new LayerThing(newProject.getRootLayerThing().getChildTemplate("layer"), newProject, newLayer));
        }
        newProject.getLayerTree().rebuild();
        newLayerSet.setDimensions(srcProject.getRootLayerSet().getLayerWidth(), srcProject.getRootLayerSet().getLayerHeight(), 7);
        Display.updateLayerScroller(newLayerSet);
        Display.update(newLayerSet);
        newProject.resetRootTemplateThing(srcProject.getRootTemplateThing().clone(newProject, false), null);
        int numThreads = Math.max(1, Math.min(nExportThreads, Runtime.getRuntime().availableProcessors()));
        int i = 0;
        for (final Layer srcLayer : srcLayers) {
            Utils.log("Processing layer " + (i + 1) + "/" + srcLayers.size() + " -- " + new Date());
            final int layerIndex = i++;
            final String dir = dataDir + "/" + layerIndex + "/";
            new File(dir).mkdir();
            Layer newLayer = (Layer)newLayers.get(layerIndex);
            ArrayList patches = new ArrayList();
            if (1 == exportImageType) {
                Process.progressive(ExportUnsignedShort.exportTiles(srcLayer, tileWidth, tileHeight, onlyVisibleImages), new CountingTaskFactory<Callable<ExportedTile>, Patch>(){

                    @Override
                    public Patch process(Callable<ExportedTile> c, int index) {
                        try {
                            ExportedTile t = c.call();
                            String title = layerIndex + "-" + index;
                            String path = dir + title + ".tif.zip";
                            ImagePlus imp = new ImagePlus(title, (ImageProcessor)t.sp);
                            if (!new FileSaver(imp).saveAsZip(path)) {
                                throw new Exception("Could not save tile: " + path);
                            }
                            Patch patch = new Patch(newProject, title, t.x, t.y, imp);
                            patch.setLocked(true);
                            newProject.getLoader().addedPatchFrom(path, patch);
                            return patch;
                        }
                        catch (Exception e) {
                            IJError.print(e);
                            return null;
                        }
                    }
                }, patches, numThreads);
            } else {
                Process.progressive(ProjectTiler.tileSequence(srcLayer, tileWidth, tileHeight, onlyVisibleImages), new CountingTaskFactory<Rectangle, Patch>(){

                    @Override
                    public Patch process(Rectangle bounds, int index) {
                        try {
                            ImagePlus imp = srcLayer.getProject().getLoader().getFlatImage(srcLayer, bounds, 1.0, -1, exportImageType, Patch.class, null, false, Color.black);
                            String title = layerIndex + "-" + index;
                            imp.setTitle(title);
                            String path = dir + title + ".tif.zip";
                            if (!new FileSaver(imp).saveAsZip(path)) {
                                throw new Exception("Could not save tile: " + path);
                            }
                            Patch patch = new Patch(newProject, title, bounds.x, bounds.y, imp);
                            patch.setLocked(true);
                            newProject.getLoader().addedPatchFrom(path, patch);
                            return patch;
                        }
                        catch (Exception e) {
                            IJError.print(e);
                            return null;
                        }
                    }
                }, patches, numThreads);
            }
            for (Patch p : patches) {
                newLayer.add(p);
            }
        }
        ProjectThing root = srcProject.getRootProjectThing();
        if (null != root.getChildren() && !root.getChildren().isEmpty()) {
            ProjectThing source_pt = srcProject.getRootProjectThing().getChildren().get(0);
            boolean transfer_mode = false;
            ProjectThing landing_parent = newProject.getRootProjectThing();
            srcProject.getProjectTree().rawSendToSiblingProject(source_pt, 0, newProject, landing_parent);
        }
        i = 0;
        for (Layer srcLayer : srcLayers) {
            for (DLabel srcLabel : srcLayer.getAll(DLabel.class)) {
                ((Layer)newLayers.get(i++)).add(srcLabel.clone(newProject, false));
            }
        }
        if (createMipMaps) {
            LinkedList fus = new LinkedList();
            int batch = Runtime.getRuntime().availableProcessors();
            for (Layer newLayer : newLayers) {
                for (Patch p : newLayer.getAll(Patch.class)) {
                    fus.add(p.updateMipMaps());
                    if (fus.size() <= batch * 3) continue;
                    while (fus.size() > batch) {
                        try {
                            fus.removeFirst().get();
                        }
                        catch (Exception e) {
                            IJError.print(e);
                        }
                    }
                }
            }
            Utils.wait(fus);
        }
        newProject.saveAs(targetDir + "exported.xml", false);
        return newProject;
    }

    public static final Iterable<Rectangle> tileSequence(final Layer srcLayer, final int tileWidth, final int tileHeight, final boolean onlyVisibleImages) {
        return new Iterable<Rectangle>(){

            @Override
            public Iterator<Rectangle> iterator() {
                return new Iterator<Rectangle>(){
                    final Rectangle box;
                    final int nRows;
                    final int nCols;
                    Rectangle tileBounds;
                    int row;
                    int col;
                    {
                        this.box = srcLayer.getMinimalBoundingBox(Patch.class, onlyVisibleImages).intersection(srcLayer.getParent().get2DBounds());
                        this.nRows = (int)Math.ceil((double)this.box.width / (double)tileWidth);
                        this.nCols = (int)Math.ceil((double)this.box.height / (double)tileHeight);
                        this.tileBounds = null;
                        this.row = 0;
                        this.col = 0;
                        this.findNext();
                    }

                    private void findNext() {
                        boolean content;
                        this.tileBounds = null;
                        do {
                            if (this.nRows == this.row) {
                                this.tileBounds = null;
                                break;
                            }
                            this.tileBounds = new Rectangle(this.box.x + this.col * tileWidth, this.box.y + this.row * tileHeight, tileWidth, tileHeight);
                            content = srcLayer.find(Patch.class, this.tileBounds, onlyVisibleImages).size() > 0;
                            ++this.col;
                            if (this.nCols != this.col) continue;
                            this.col = 0;
                            ++this.row;
                        } while (!content);
                    }

                    @Override
                    public boolean hasNext() {
                        return null != this.tileBounds;
                    }

                    @Override
                    public Rectangle next() {
                        Rectangle r = new Rectangle(this.tileBounds);
                        this.findNext();
                        return r;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

