/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.tree;

import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.tree.AbstractTreeTransferHandler;
import ini.trakem2.tree.DNDTree;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.tree.ProjectTree;
import ini.trakem2.tree.TemplateThing;
import ini.trakem2.tree.TemplateTree;
import ini.trakem2.tree.Thing;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DefaultTreeTransferHandler
extends AbstractTreeTransferHandler {
    Project project;

    public DefaultTreeTransferHandler(Project project, DNDTree tree, int action) {
        super(tree, action, true);
        this.project = project;
    }

    @Override
    public boolean canPerformAction(DNDTree target, DefaultMutableTreeNode dragged_node, int action, Point location) {
        if (null == dragged_node) {
            return false;
        }
        if (target instanceof TemplateTree) {
            return false;
        }
        if (dragged_node.getUserObject() instanceof ProjectThing && ((ProjectThing)dragged_node.getUserObject()).getObject() instanceof Project) {
            return false;
        }
        TreePath pathTarget = target.getPathForLocation(location.x, location.y);
        if (pathTarget == null) {
            target.setSelectionPath(null);
            return false;
        }
        target.setSelectionPath(pathTarget);
        DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)pathTarget.getLastPathComponent();
        Object parent_ob = parent_node.getUserObject();
        Thing child_thing = (Thing)dragged_node.getUserObject();
        if ((2 == action || 1 == action) && parent_ob instanceof ProjectThing) {
            ProjectThing parent_thing = (ProjectThing)parent_ob;
            if (!parent_thing.uniquePathExists(child_thing.getType()) && !parent_thing.canHaveAsChild(child_thing)) {
                return false;
            }
            return parent_node != dragged_node.getParent() && !dragged_node.isNodeDescendant(parent_node);
        }
        return false;
    }

    @Override
    public synchronized boolean executeDrop(DNDTree target, DefaultMutableTreeNode dragged_node, DefaultMutableTreeNode new_parent_node, int action) {
        try {
            if (!(target instanceof ProjectTree)) {
                return false;
            }
            Thing dragged_thing = null;
            Object ob = dragged_node.getUserObject();
            if (null == ob || !(ob instanceof Thing)) {
                return false;
            }
            dragged_thing = (Thing)ob;
            ProjectThing new_parent_thing = null;
            Object obp = new_parent_node.getUserObject();
            if (null != obp && obp instanceof ProjectThing) {
                new_parent_thing = (ProjectThing)obp;
            }
            if (null == new_parent_thing) {
                Utils.log("WARNING: null parent element while dragging and dropping.");
                return false;
            }
            if (new_parent_thing.getType().equals("profile_list") && null != new_parent_thing.getChildren() && new_parent_thing.getChildren().size() > 0) {
                Utils.showMessage("Add new profiles by duplicating and linking existing ones.\nAlternatively, start a new profile_list.");
                return false;
            }
            this.project.getRootLayerSet().addChangeTreesStep();
            Runnable after = new Runnable(){

                @Override
                public void run() {
                    DefaultTreeTransferHandler.this.project.getRootLayerSet().addChangeTreesStep();
                }
            };
            if (2 == action || action == 1) {
                if (dragged_thing instanceof TemplateThing) {
                    TemplateThing tt = (TemplateThing)dragged_thing;
                    if (!Project.isBasicType(dragged_thing.getType()) && !new_parent_thing.canHaveAsChild(dragged_thing) && new_parent_thing.uniquePathExists(dragged_thing.getType())) {
                        ArrayList<TemplateThing> al = new_parent_thing.getTemplatePathTo(dragged_thing.getType());
                        al.remove(0);
                        al.remove(al.size() - 1);
                        if (0 == al.size()) {
                            return false;
                        }
                        ProjectThing a_parent = new_parent_thing;
                        DefaultMutableTreeNode a_parent_node = new_parent_node;
                        for (TemplateThing t : al) {
                            String type = t.getType();
                            ArrayList<ProjectThing> al_c = a_parent.findChildrenOfType(type);
                            if (0 == al_c.size()) {
                                ProjectThing a_pt = a_parent.createChild(type);
                                DefaultMutableTreeNode a_node = ProjectTree.makeNode(a_pt);
                                ((DefaultTreeModel)target.getModel()).insertNodeInto(a_node, a_parent_node, a_parent_node.getChildCount());
                                a_parent = a_pt;
                                a_parent_node = a_node;
                                continue;
                            }
                            a_parent = al_c.get(0);
                            a_parent_node = DNDTree.findNode(a_parent, target);
                        }
                        new_parent_node = a_parent_node;
                        new_parent_thing = a_parent;
                    }
                    if (1 == action) {
                        if (Project.isBasicType(tt.getType()) && null == Display.getFront()) {
                            return false;
                        }
                        ArrayList<ProjectThing> nc = new_parent_thing.createChildren(tt.getType(), 1, true);
                        target.addLeafs(nc, after);
                        return true;
                    }
                    ProjectThing new_thing = new_parent_thing.createChild(tt.getType());
                    if (null == new_thing) {
                        return false;
                    }
                    DefaultMutableTreeNode new_node = ProjectTree.makeNode(new_thing);
                    if (null == new_node) {
                        return false;
                    }
                    ((DefaultTreeModel)target.getModel()).insertNodeInto(new_node, new_parent_node, new_parent_node.getChildCount());
                    TreePath treePath = new TreePath(new_node.getPath());
                    target.scrollPathToVisible(treePath);
                    target.setSelectionPath(treePath);
                    new_parent_thing.addChild(new_thing);
                    DNDTree.expandNode(target, new_parent_node);
                    DNDTree.expandNode(this.project.getTemplateTree(), dragged_node);
                    after.run();
                    return true;
                }
                if (2 == action && dragged_thing instanceof ProjectThing) {
                    if (!new_parent_thing.canHaveAsChild(dragged_thing)) {
                        return false;
                    }
                    ProjectThing p_dragged_thing = (ProjectThing)dragged_thing;
                    ProjectThing old_parent = (ProjectThing)p_dragged_thing.getParent();
                    if (null != old_parent) {
                        if (!old_parent.removeChild(p_dragged_thing)) {
                            return false;
                        }
                    } else {
                        Utils.log("WARNING: the parent of the source node is null when drag and drop!");
                        return false;
                    }
                    if (!new_parent_thing.addChild(p_dragged_thing)) {
                        old_parent.addChild(p_dragged_thing);
                        return false;
                    }
                    dragged_node.removeFromParent();
                    ((DefaultTreeModel)target.getModel()).insertNodeInto(dragged_node, new_parent_node, new_parent_node.getChildCount());
                    TreePath treePath = new TreePath(dragged_node.getPath());
                    target.scrollPathToVisible(treePath);
                    target.setSelectionPath(treePath);
                    DNDTree.expandNode(target, new_parent_node);
                    after.run();
                    return true;
                }
            }
        }
        catch (Exception e) {
            IJError.print(e);
            return false;
        }
        return false;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.project = null;
    }
}

