/*
 * Decompiled with CFR 0.152.
 */
package lenscorrection;

import java.util.Collection;
import lenscorrection.NonLinearTransform;
import mpicbg.models.AbstractAffineModel2D;
import mpicbg.models.AbstractModel;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

public class PolynomialModel2D
extends AbstractModel<PolynomialModel2D> {
    private NonLinearTransform nlt = new NonLinearTransform();
    private AbstractAffineModel2D<?> affine = null;
    private float lambda = 0.0f;

    public AbstractAffineModel2D<?> getAffine() {
        return this.affine;
    }

    public void setAffine(AbstractAffineModel2D<?> affine) {
        this.affine = affine;
    }

    public void setAffine(Class<? extends AbstractAffineModel2D<?>> affineClass) throws Exception {
        this.affine = affineClass.newInstance();
    }

    public int getOrder() {
        return this.nlt.getDimension();
    }

    public void setOrder(int order) {
        this.nlt.setDimension(order);
    }

    public float getLambda() {
        return this.lambda;
    }

    public void setLambda(float lambda) {
        this.lambda = lambda;
    }

    public PolynomialModel2D copy() {
        PolynomialModel2D clone = new PolynomialModel2D();
        clone.nlt = this.nlt.copy();
        clone.affine = (AbstractAffineModel2D)this.affine.copy();
        clone.lambda = this.lambda;
        return clone;
    }

    public <P extends PointMatch> void fit(Collection<P> pointMatches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        if (pointMatches.size() < this.getMinNumMatches()) {
            throw new NotEnoughDataPointsException(pointMatches.size() + " data points are not enough to estimate a 2d polynomial of order " + this.nlt.getDimension() + ", at least " + this.getMinNumMatches() + " data points required.");
        }
        this.affine.fit(pointMatches);
        double[][] h1 = new double[pointMatches.size()][2];
        double[][] h2 = new double[pointMatches.size()][2];
        int i = 0;
        for (PointMatch match : pointMatches) {
            double[] tmp1 = (double[])match.getP1().getL().clone();
            this.affine.applyInPlace(tmp1);
            double[] tmp2 = match.getP2().getW();
            h1[i] = new double[]{tmp1[0], tmp1[1]};
            h2[i] = new double[]{tmp2[0], tmp2[1]};
            ++i;
        }
        this.nlt.fit(h1, h2, this.lambda);
    }

    public int getMinNumMatches() {
        return Math.max(this.affine.getMinNumMatches(), this.nlt.getMinNumMatches());
    }

    public void set(PolynomialModel2D m) {
        this.nlt.set(m.nlt);
        this.affine = (AbstractAffineModel2D)m.affine.copy();
        this.lambda = m.lambda;
    }

    public String toString() {
        return "affine: " + this.affine.toString() + "; polynomial: " + this.nlt.toString();
    }

    public double[] apply(double[] location) {
        double[] l = (double[])location.clone();
        this.applyInPlace(l);
        return l;
    }

    public void applyInPlace(double[] location) {
        this.affine.applyInPlace(location);
        this.nlt.applyInPlace(location);
    }
}

