/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.google.cloud.storage.Storage;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.imglib2.util.Pair;
import org.apache.commons.lang3.function.TriFunction;
import org.janelia.saalfeldlab.googlecloud.GoogleCloudUtils;
import org.janelia.saalfeldlab.n5.KeyValueAccess;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5KeyValueReader;
import org.janelia.saalfeldlab.n5.N5KeyValueWriter;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.hdf5.N5HDF5Reader;
import org.janelia.saalfeldlab.n5.hdf5.N5HDF5Writer;
import org.janelia.saalfeldlab.n5.s3.AmazonS3Utils;
import org.janelia.saalfeldlab.n5.universe.KeyValueAccessBackend;
import org.janelia.saalfeldlab.n5.universe.StorageFormat;
import org.janelia.saalfeldlab.n5.zarr.ZarrKeyValueReader;
import org.janelia.saalfeldlab.n5.zarr.ZarrKeyValueWriter;

public class N5Factory
implements Serializable {
    static final N5Factory FACTORY = new N5Factory();
    private static final long serialVersionUID = -6823715427289454617L;
    static final Pattern HTTPS_SCHEME = Pattern.compile("http(s)?", 2);
    static final Pattern FILE_SCHEME = Pattern.compile("file", 2);
    private int[] hdf5DefaultBlockSize = new int[]{64, 64, 64, 1, 1};
    private boolean hdf5OverrideBlockSize = false;
    private GsonBuilder gsonBuilder = new GsonBuilder();
    private boolean cacheAttributes = true;
    private String zarrDimensionSeparator = ".";
    private boolean zarrMapN5DatasetAttributes = true;
    private boolean zarrMergeAttributes = true;
    private String googleCloudProjectId = null;
    private boolean googleCloudCreateBucket = false;
    private String s3Region = null;
    private AWSCredentials s3Credentials = null;
    private ClientConfiguration s3ClientConfiguration = null;
    private boolean s3Anonymous = true;
    private String s3Endpoint;
    private StorageFormat preferredStorageFormat = null;

    public N5Factory hdf5DefaultBlockSize(int ... blockSize) {
        this.hdf5DefaultBlockSize = blockSize;
        return this;
    }

    public N5Factory hdf5OverrideBlockSize(boolean override) {
        this.hdf5OverrideBlockSize = override;
        return this;
    }

    public N5Factory gsonBuilder(GsonBuilder gsonBuilder) {
        this.gsonBuilder = gsonBuilder;
        return this;
    }

    public N5Factory cacheAttributes(boolean cacheAttributes) {
        this.cacheAttributes = cacheAttributes;
        return this;
    }

    public N5Factory zarrDimensionSeparator(String separator) {
        this.zarrDimensionSeparator = separator;
        return this;
    }

    public N5Factory zarrMapN5Attributes(boolean mapAttributes) {
        this.zarrMapN5DatasetAttributes = mapAttributes;
        return this;
    }

    public N5Factory zarrMergeAttributes(boolean mergeAttributes) {
        this.zarrMergeAttributes = mergeAttributes;
        return this;
    }

    public N5Factory googleCloudCreateBucket(boolean createBucket) {
        this.googleCloudCreateBucket = createBucket;
        return this;
    }

    public N5Factory googleCloudProjectId(String projectId) {
        this.googleCloudProjectId = projectId;
        return this;
    }

    public N5Factory s3UseCredentials() {
        this.s3Anonymous = false;
        return this;
    }

    public N5Factory s3UseCredentials(AWSCredentials credentials) {
        this.s3Credentials = credentials;
        return this;
    }

    public N5Factory s3ClientConfiguration(ClientConfiguration clientConfiguration) {
        this.s3ClientConfiguration = clientConfiguration;
        return this;
    }

    public N5Factory preferredStorageFormat(StorageFormat format) {
        this.preferredStorageFormat = format;
        return this;
    }

    @Deprecated
    public N5Factory s3RetryWithCredentials() {
        return this;
    }

    public N5Factory s3Endpoint(String s3Endpoint) {
        this.s3Endpoint = s3Endpoint;
        return this;
    }

    public N5Factory s3Region(String s3Region) {
        this.s3Region = s3Region;
        return this;
    }

    protected AmazonS3 createS3(String uri) {
        try {
            return AmazonS3Utils.createS3((String)uri, (String)this.s3Endpoint, (AWSCredentialsProvider)AmazonS3Utils.getS3Credentials((AWSCredentials)this.s3Credentials, (boolean)this.s3Anonymous), (ClientConfiguration)this.s3ClientConfiguration, (String)this.s3Region);
        }
        catch (Throwable e) {
            throw new N5Exception("Could not create s3 client from uri: " + uri, e);
        }
    }

    protected Storage createGoogleCloudStorage() {
        return GoogleCloudUtils.createGoogleCloudStorage((String)this.googleCloudProjectId);
    }

    @Nullable
    public KeyValueAccess getKeyValueAccess(URI uri) {
        return KeyValueAccessBackend.getKeyValueAccess(uri, this);
    }

    @Deprecated
    public N5Reader openFSReader(String path) {
        return this.openN5ContainerWithStorageFormat(StorageFormat.N5, path, this::openReader);
    }

    @Deprecated
    public N5Reader openZarrReader(String path) {
        return this.openN5ContainerWithStorageFormat(StorageFormat.ZARR, path, this::openReader);
    }

    @Deprecated
    public N5Reader openHDF5Reader(String path) {
        return this.openN5ContainerWithStorageFormat(StorageFormat.HDF5, path, (format, uri) -> this.openReader((StorageFormat)((Object)format), null, (URI)uri));
    }

    public N5Reader openGoogleCloudReader(String uri) throws URISyntaxException {
        return this.openN5ContainerWithBackend(KeyValueAccessBackend.GOOGLE_CLOUD, uri, this::openReader);
    }

    public N5Reader openAWSS3Reader(String uri) throws URISyntaxException {
        return this.openN5ContainerWithBackend(KeyValueAccessBackend.AWS, uri, this::openReader);
    }

    public N5Reader openFileSystemReader(String uri) throws URISyntaxException {
        return this.openN5ContainerWithBackend(KeyValueAccessBackend.FILE, uri, this::openReader);
    }

    public N5Reader openReader(String uri) {
        Pair<StorageFormat, URI> storageAndUri = StorageFormat.parseUri(uri);
        StorageFormat format = (StorageFormat)((Object)storageAndUri.getA());
        URI asUri = (URI)storageAndUri.getB();
        return this.openReader(format, asUri);
    }

    public N5Reader openReader(StorageFormat format, String uri) {
        return this.openReader(format, N5Factory.parseUriFromString(uri));
    }

    public N5Reader openReader(StorageFormat format, URI uri) {
        return this.openN5Container(format, uri, this::openReader);
    }

    StorageFormat[] orderedStorageFormats() {
        return (StorageFormat[])Arrays.stream(StorageFormat.values()).sorted((l, r) -> {
            if (l == this.preferredStorageFormat) {
                return -1;
            }
            return l.compareTo(r);
        }).toArray(StorageFormat[]::new);
    }

    private N5Reader openReader(@Nullable StorageFormat storage, @Nullable KeyValueAccess access, URI location) {
        if (storage == null) {
            for (StorageFormat format : this.orderedStorageFormats()) {
                try {
                    return this.openReader(format, access, location);
                }
                catch (Throwable throwable) {
                }
            }
            throw new N5Exception("Unable to open " + location + " as N5Reader");
        }
        String containerPath = location.toString();
        switch (storage) {
            case N5: {
                return new N5KeyValueReader(access, containerPath, this.gsonBuilder, this.cacheAttributes);
            }
            case ZARR: {
                return new ZarrKeyValueReader(access, containerPath, this.gsonBuilder, this.zarrMapN5DatasetAttributes, this.zarrMergeAttributes, this.cacheAttributes);
            }
            case HDF5: {
                return new N5HDF5Reader(containerPath, this.hdf5OverrideBlockSize, this.gsonBuilder, this.hdf5DefaultBlockSize);
            }
        }
        return null;
    }

    @Deprecated
    public N5Writer openFSWriter(String path) {
        return this.openN5ContainerWithStorageFormat(StorageFormat.N5, path, this::openWriter);
    }

    @Deprecated
    public N5Writer openZarrWriter(String path) {
        return this.openN5ContainerWithStorageFormat(StorageFormat.ZARR, path, this::openWriter);
    }

    @Deprecated
    public N5Writer openHDF5Writer(String path) {
        return this.openN5ContainerWithStorageFormat(StorageFormat.HDF5, path, (format, uri) -> this.openWriter((StorageFormat)((Object)format), null, (URI)uri));
    }

    public N5Writer openGoogleCloudWriter(String uri) throws URISyntaxException {
        return (N5Writer)this.openN5ContainerWithBackend(KeyValueAccessBackend.GOOGLE_CLOUD, uri, this::openWriter);
    }

    public N5Writer openAWSS3Writer(String uri) throws URISyntaxException {
        return (N5Writer)this.openN5ContainerWithBackend(KeyValueAccessBackend.AWS, uri, this::openWriter);
    }

    public N5Writer openWriter(String uri) {
        Pair<StorageFormat, URI> storageAndUri = StorageFormat.parseUri(uri);
        StorageFormat format = (StorageFormat)((Object)storageAndUri.getA());
        URI asUri = (URI)storageAndUri.getB();
        return this.openWriter(format, asUri);
    }

    public N5Writer openWriter(StorageFormat format, String uri) {
        return this.openWriter(format, N5Factory.parseUriFromString(uri));
    }

    public N5Writer openWriter(StorageFormat format, URI uri) {
        return (N5Writer)this.openN5Container(format, uri, this::openWriter);
    }

    public N5Writer openWriter(@Nullable StorageFormat storage, @Nullable KeyValueAccess access, URI location) {
        if (storage == null) {
            for (StorageFormat format : this.orderedStorageFormats()) {
                try {
                    return this.openWriter(format, access, location);
                }
                catch (Throwable throwable) {
                }
            }
            throw new N5Exception("Unable to open " + location + " as N5Writer");
        }
        String containerLocation = location.toString();
        switch (storage) {
            case ZARR: {
                return new ZarrKeyValueWriter(access, containerLocation, this.gsonBuilder, this.zarrMapN5DatasetAttributes, this.zarrMergeAttributes, this.zarrDimensionSeparator, this.cacheAttributes);
            }
            case N5: {
                return new N5KeyValueWriter(access, containerLocation, this.gsonBuilder, this.cacheAttributes);
            }
            case HDF5: {
                return new N5HDF5Writer(containerLocation, this.hdf5OverrideBlockSize, this.gsonBuilder, this.hdf5DefaultBlockSize);
            }
        }
        return null;
    }

    private <T extends N5Reader> T openN5ContainerWithStorageFormat(StorageFormat format, String uri, BiFunction<StorageFormat, URI, T> openWithFormat) {
        URI asUri = (URI)StorageFormat.parseUri(uri).getB();
        return (T)((N5Reader)openWithFormat.apply(format, asUri));
    }

    private <T extends N5Reader> T openN5ContainerWithBackend(KeyValueAccessBackend backend, String containerUri, TriFunction<StorageFormat, KeyValueAccess, URI, T> openWithBackend) {
        Pair<StorageFormat, URI> formatAndUri = StorageFormat.parseUri(containerUri);
        URI uri = (URI)formatAndUri.getB();
        KeyValueAccess kva = backend.apply(uri, this);
        StorageFormat format = (StorageFormat)((Object)formatAndUri.getA());
        format = format != null ? format : StorageFormat.guessStorageFromKeys(uri, kva);
        return (T)((N5Reader)openWithBackend.apply((Object)format, (Object)kva, (Object)uri));
    }

    private <T extends N5Reader> T openN5Container(StorageFormat storageFormat, URI uri, TriFunction<StorageFormat, KeyValueAccess, URI, T> openWithKva) {
        KeyValueAccess kva = this.getKeyValueAccess(uri);
        if (kva == null) {
            throw new N5Exception("Cannot get KeyValueAccess at " + uri);
        }
        StorageFormat format = storageFormat != null ? storageFormat : StorageFormat.guessStorageFromKeys(uri, kva);
        return (T)((N5Reader)openWithKva.apply((Object)format, (Object)kva, (Object)uri));
    }

    public static N5Writer createWriter(String containerUri) {
        return FACTORY.openWriter(containerUri);
    }

    public static N5Reader createReader(String containerUri) {
        return FACTORY.openReader(containerUri);
    }

    static URI parseUriFromString(String uri) {
        try {
            return URI.create(uri);
        }
        catch (Throwable throwable) {
            try {
                return Paths.get(uri, new String[0]).toUri();
            }
            catch (Throwable throwable2) {
                try {
                    return N5URI.encodeAsUri((String)uri);
                }
                catch (URISyntaxException e) {
                    throw new N5Exception((Throwable)e);
                }
            }
        }
    }
}

