/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple.ops;

import java.io.PrintStream;
import org.ejml.concurrency.EjmlConcurrency;
import org.ejml.data.Complex_F64;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.CommonOps_MT_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.dense.row.mult.VectorVectorMult_DDRM;
import org.ejml.ops.MatrixIO;
import org.ejml.simple.SimpleOperations;

public class SimpleOperations_DDRM
implements SimpleOperations<DMatrixRMaj> {
    @Override
    public void set(DMatrixRMaj A, int row, int column, double value) {
        A.set(row, column, value);
    }

    @Override
    public void set(DMatrixRMaj A, int row, int column, double real, double imaginary) {
        throw new IllegalArgumentException("Does not support imaginary values");
    }

    @Override
    public double get(DMatrixRMaj A, int row, int column) {
        return A.get(row, column);
    }

    @Override
    public void get(DMatrixRMaj A, int row, int column, Complex_F64 value) {
        value.real = A.get(row, column);
        value.imaginary = 0.0;
    }

    @Override
    public void fill(DMatrixRMaj A, double value) {
        CommonOps_DDRM.fill((DMatrixD1)A, (double)value);
    }

    @Override
    public void transpose(DMatrixRMaj input, DMatrixRMaj output) {
        if (EjmlConcurrency.useConcurrent((Matrix)input)) {
            CommonOps_MT_DDRM.transpose((DMatrixRMaj)input, (DMatrixRMaj)output);
        } else {
            CommonOps_DDRM.transpose((DMatrixRMaj)input, (DMatrixRMaj)output);
        }
    }

    @Override
    public void mult(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj output) {
        if (EjmlConcurrency.useConcurrent((Matrix)A)) {
            CommonOps_MT_DDRM.mult((DMatrix1Row)A, (DMatrix1Row)B, (DMatrix1Row)output);
        } else {
            CommonOps_DDRM.mult((DMatrix1Row)A, (DMatrix1Row)B, (DMatrix1Row)output);
        }
    }

    @Override
    public void multTransA(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj output) {
        if (EjmlConcurrency.useConcurrent((Matrix)A)) {
            CommonOps_MT_DDRM.multTransA((DMatrix1Row)A, (DMatrix1Row)B, (DMatrix1Row)output);
        } else {
            CommonOps_DDRM.multTransA((DMatrix1Row)A, (DMatrix1Row)B, (DMatrix1Row)output);
        }
    }

    @Override
    public void kron(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj output) {
        CommonOps_DDRM.kron((DMatrixRMaj)A, (DMatrixRMaj)B, (DMatrixRMaj)output);
    }

    @Override
    public void plus(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj output) {
        CommonOps_DDRM.add((DMatrixD1)A, (DMatrixD1)B, (DMatrixD1)output);
    }

    @Override
    public void minus(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj output) {
        CommonOps_DDRM.subtract((DMatrixD1)A, (DMatrixD1)B, (DMatrixD1)output);
    }

    @Override
    public void minus(DMatrixRMaj A, double b, DMatrixRMaj output) {
        CommonOps_DDRM.subtract((DMatrixD1)A, (double)b, (DMatrixD1)output);
    }

    @Override
    public void plus(DMatrixRMaj A, double b, DMatrixRMaj output) {
        CommonOps_DDRM.add((DMatrixD1)A, (double)b, (DMatrixD1)output);
    }

    @Override
    public void plus(DMatrixRMaj A, double beta, DMatrixRMaj b, DMatrixRMaj output) {
        CommonOps_DDRM.add((DMatrixD1)A, (double)beta, (DMatrixD1)b, (DMatrixD1)output);
    }

    @Override
    public void plus(double alpha, DMatrixRMaj A, double beta, DMatrixRMaj b, DMatrixRMaj output) {
        CommonOps_DDRM.add((double)alpha, (DMatrixD1)A, (double)beta, (DMatrixD1)b, (DMatrixD1)output);
    }

    @Override
    public double dot(DMatrixRMaj A, DMatrixRMaj v) {
        return VectorVectorMult_DDRM.innerProd((DMatrixD1)A, (DMatrixD1)v);
    }

    @Override
    public void scale(DMatrixRMaj A, double val, DMatrixRMaj output) {
        CommonOps_DDRM.scale((double)val, (DMatrixD1)A, (DMatrixD1)output);
    }

    @Override
    public void divide(DMatrixRMaj A, double val, DMatrixRMaj output) {
        CommonOps_DDRM.divide((DMatrixD1)A, (double)val, (DMatrixD1)output);
    }

    @Override
    public boolean invert(DMatrixRMaj A, DMatrixRMaj output) {
        return CommonOps_DDRM.invert((DMatrixRMaj)A, (DMatrixRMaj)output);
    }

    @Override
    public void setIdentity(DMatrixRMaj A) {
        CommonOps_DDRM.setIdentity((DMatrix1Row)A);
    }

    @Override
    public void pseudoInverse(DMatrixRMaj A, DMatrixRMaj output) {
        CommonOps_DDRM.pinv((DMatrixRMaj)A, (DMatrixRMaj)output);
    }

    @Override
    public boolean solve(DMatrixRMaj A, DMatrixRMaj X, DMatrixRMaj B) {
        return CommonOps_DDRM.solve((DMatrixRMaj)A, (DMatrixRMaj)B, (DMatrixRMaj)X);
    }

    @Override
    public void zero(DMatrixRMaj A) {
        A.zero();
    }

    @Override
    public double normF(DMatrixRMaj A) {
        return NormOps_DDRM.normF((DMatrixD1)A);
    }

    @Override
    public double conditionP2(DMatrixRMaj A) {
        return NormOps_DDRM.conditionP2((DMatrixRMaj)A);
    }

    @Override
    public double determinant(DMatrixRMaj A) {
        return CommonOps_DDRM.det((DMatrixRMaj)A);
    }

    @Override
    public double trace(DMatrixRMaj A) {
        return CommonOps_DDRM.trace((DMatrix1Row)A);
    }

    @Override
    public void setRow(DMatrixRMaj A, int row, int startColumn, double ... values) {
        for (int i = 0; i < values.length; ++i) {
            A.set(row, startColumn + i, values[i]);
        }
    }

    @Override
    public void setColumn(DMatrixRMaj A, int column, int startRow, double ... values) {
        for (int i = 0; i < values.length; ++i) {
            A.set(startRow + i, column, values[i]);
        }
    }

    @Override
    public void extract(DMatrixRMaj src, int srcY0, int srcY1, int srcX0, int srcX1, DMatrixRMaj dst, int dstY0, int dstX0) {
        CommonOps_DDRM.extract((DMatrix)src, (int)srcY0, (int)srcY1, (int)srcX0, (int)srcX1, (DMatrix)dst, (int)dstY0, (int)dstX0);
    }

    @Override
    public DMatrixRMaj diag(DMatrixRMaj A) {
        DMatrixRMaj output;
        if (MatrixFeatures_DDRM.isVector((Matrix)A)) {
            int N = Math.max(A.numCols, A.numRows);
            output = new DMatrixRMaj(N, N);
            CommonOps_DDRM.diag((DMatrixRMaj)output, (int)N, (double[])A.data);
        } else {
            int N = Math.min(A.numCols, A.numRows);
            output = new DMatrixRMaj(N, 1);
            CommonOps_DDRM.extractDiag((DMatrixRMaj)A, (DMatrixRMaj)output);
        }
        return output;
    }

    @Override
    public boolean hasUncountable(DMatrixRMaj M) {
        return MatrixFeatures_DDRM.hasUncountable((DMatrixD1)M);
    }

    @Override
    public void changeSign(DMatrixRMaj a) {
        CommonOps_DDRM.changeSign((DMatrixD1)a);
    }

    @Override
    public double elementMaxAbs(DMatrixRMaj A) {
        return CommonOps_DDRM.elementMaxAbs((DMatrixD1)A);
    }

    @Override
    public double elementMinAbs(DMatrixRMaj A) {
        return CommonOps_DDRM.elementMinAbs((DMatrixD1)A);
    }

    @Override
    public double elementSum(DMatrixRMaj A) {
        return CommonOps_DDRM.elementSum((DMatrixD1)A);
    }

    @Override
    public void elementMult(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj output) {
        CommonOps_DDRM.elementMult((DMatrixD1)A, (DMatrixD1)B, (DMatrixD1)output);
    }

    @Override
    public void elementDiv(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj output) {
        CommonOps_DDRM.elementDiv((DMatrixD1)A, (DMatrixD1)B, (DMatrixD1)output);
    }

    @Override
    public void elementPower(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj output) {
        CommonOps_DDRM.elementPower((DMatrixD1)A, (DMatrixD1)B, (DMatrixD1)output);
    }

    @Override
    public void elementPower(DMatrixRMaj A, double b, DMatrixRMaj output) {
        CommonOps_DDRM.elementPower((DMatrixD1)A, (double)b, (DMatrixD1)output);
    }

    @Override
    public void elementExp(DMatrixRMaj A, DMatrixRMaj output) {
        CommonOps_DDRM.elementExp((DMatrixD1)A, (DMatrixD1)output);
    }

    @Override
    public void elementLog(DMatrixRMaj A, DMatrixRMaj output) {
        CommonOps_DDRM.elementLog((DMatrixD1)A, (DMatrixD1)output);
    }

    @Override
    public boolean isIdentical(DMatrixRMaj A, DMatrixRMaj B, double tol) {
        return MatrixFeatures_DDRM.isIdentical((DMatrixD1)A, (DMatrixD1)B, (double)tol);
    }

    @Override
    public void print(PrintStream out, Matrix mat, String format) {
        MatrixIO.print((PrintStream)out, (DMatrix)((DMatrixRMaj)mat), (String)format);
    }
}

