/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.jogamp.java3d.AuralAttributesRetained;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.ConeSoundRetained;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.J3dStructure;
import org.jogamp.java3d.MediaContainer;
import org.jogamp.java3d.NodeRetained;
import org.jogamp.java3d.PointSoundRetained;
import org.jogamp.java3d.SoundRetained;
import org.jogamp.java3d.SoundscapeRetained;
import org.jogamp.java3d.UnorderList;
import org.jogamp.java3d.UpdateTargets;
import org.jogamp.java3d.View;
import org.jogamp.java3d.ViewPlatformRetained;
import org.jogamp.java3d.VirtualUniverse;

class SoundStructure
extends J3dStructure {
    UnorderList nonViewScopedSounds = new UnorderList(SoundRetained.class);
    HashMap viewScopedSounds = new HashMap();
    UnorderList nonViewScopedSoundscapes = new UnorderList(SoundscapeRetained.class);
    HashMap viewScopedSoundscapes = new HashMap();
    UnorderList viewPlatforms = new UnorderList(ViewPlatformRetained.class);
    BoundingSphere tempSphere = new BoundingSphere();
    BoundingSphere vpsphere = new BoundingSphere();
    ArrayList objList = new ArrayList();
    ArrayList xformChangeList = new ArrayList();
    ArrayList switchChangeLeafNodes = new ArrayList();
    ArrayList switchChangeLeafMasks = new ArrayList();
    boolean transformMsg = false;
    UpdateTargets targets = null;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    SoundStructure(VirtualUniverse u) {
        super(u, 512);
    }

    @Override
    void processMessages(long referenceTime) {
        Object[] messages = this.getMessages(referenceTime);
        int nMsg = this.getNumMessage();
        if (nMsg <= 0) {
            return;
        }
        for (int i = 0; i < nMsg; ++i) {
            J3dMessage m = messages[i];
            switch (m.type) {
                case 0: {
                    this.insertNodes(m);
                    break;
                }
                case 1: {
                    this.removeNodes(m);
                    break;
                }
                case 38: {
                    this.changeNodeAttrib(m);
                    break;
                }
                case 45: {
                    this.changeNodeState(m);
                    break;
                }
                case 39: 
                case 40: {
                    this.changeNodeAttrib(m);
                    break;
                }
                case 3: {
                    this.transformMsg = true;
                    break;
                }
                case 27: {
                    if (!this.universe.transformStructure.getLazyUpdate()) break;
                    this.transformMsg = true;
                    break;
                }
                case 56: {
                    this.updateViewSpecificGroupChanged(m);
                }
            }
            m.decRefcount();
        }
        if (this.transformMsg) {
            this.targets = this.universe.transformStructure.getTargetList();
            this.updateTransformChange(this.targets, referenceTime);
            this.transformMsg = false;
            this.targets = null;
        }
        Arrays.fill(messages, 0, nMsg, null);
    }

    void insertNodes(J3dMessage m) {
        Object[] nodes = (Object[])m.args[0];
        ArrayList viewScopedNodes = (ArrayList)m.args[3];
        ArrayList scopedNodesViewList = (ArrayList)m.args[4];
        for (int i = 0; i < nodes.length; ++i) {
            Object node = nodes[i];
            if (node instanceof SoundRetained) {
                this.addNonScopedSound((SoundRetained)node);
            }
            if (!(node instanceof SoundscapeRetained)) continue;
            this.addNonSoundscape((SoundscapeRetained)node);
        }
        if (viewScopedNodes != null) {
            int size = viewScopedNodes.size();
            for (int i = 0; i < size; ++i) {
                View view;
                int k;
                NodeRetained node = (NodeRetained)viewScopedNodes.get(i);
                ArrayList vl = (ArrayList)scopedNodesViewList.get(i);
                int vsize = vl.size();
                if (node instanceof SoundRetained) {
                    ((SoundRetained)node).isViewScoped = true;
                    for (k = 0; k < vsize; ++k) {
                        view = (View)vl.get(k);
                        this.addScopedSound((SoundRetained)node, view);
                    }
                    continue;
                }
                if (!(node instanceof SoundscapeRetained)) continue;
                ((SoundscapeRetained)node).isViewScoped = true;
                for (k = 0; k < vsize; ++k) {
                    view = (View)vl.get(k);
                    this.addScopedSoundscape((SoundscapeRetained)node, view);
                }
            }
        }
    }

    void addScopedSound(SoundRetained mirSound, View view) {
        ArrayList<SoundRetained> l = (ArrayList<SoundRetained>)this.viewScopedSounds.get(view);
        if (l == null) {
            l = new ArrayList<SoundRetained>();
            this.viewScopedSounds.put(view, l);
        }
        l.add(mirSound);
    }

    void addNonScopedSound(SoundRetained mirSound) {
        this.nonViewScopedSounds.add(mirSound);
    }

    void addScopedSoundscape(SoundscapeRetained soundscape, View view) {
        ArrayList<SoundscapeRetained> l = (ArrayList<SoundscapeRetained>)this.viewScopedSoundscapes.get(view);
        if (l == null) {
            l = new ArrayList<SoundscapeRetained>();
            this.viewScopedSoundscapes.put(view, l);
        }
        l.add(soundscape);
    }

    void addNonSoundscape(SoundscapeRetained soundscape) {
        this.nonViewScopedSoundscapes.add(soundscape);
    }

    @Override
    void removeNodes(J3dMessage m) {
        Object[] nodes = (Object[])m.args[0];
        ArrayList viewScopedNodes = (ArrayList)m.args[3];
        ArrayList scopedNodesViewList = (ArrayList)m.args[4];
        for (int i = 0; i < nodes.length; ++i) {
            Object node = nodes[i];
            if (node instanceof SoundRetained) {
                this.deleteNonScopedSound((SoundRetained)node);
            }
            if (!(node instanceof SoundscapeRetained)) continue;
            this.deleteNonScopedSoundscape((SoundscapeRetained)node);
        }
        if (viewScopedNodes != null) {
            int size = viewScopedNodes.size();
            for (int i = 0; i < size; ++i) {
                View view;
                int k;
                NodeRetained node = (NodeRetained)viewScopedNodes.get(i);
                ArrayList vl = (ArrayList)scopedNodesViewList.get(i);
                int vsize = vl.size();
                if (node instanceof SoundRetained) {
                    ((SoundRetained)node).isViewScoped = false;
                    for (k = 0; k < vsize; ++k) {
                        view = (View)vl.get(k);
                        this.deleteScopedSound((SoundRetained)node, view);
                    }
                    continue;
                }
                if (!(node instanceof SoundscapeRetained)) continue;
                ((SoundscapeRetained)node).isViewScoped = false;
                for (k = 0; k < vsize; ++k) {
                    view = (View)vl.get(k);
                    this.deleteScopedSoundscape((SoundscapeRetained)node, view);
                }
            }
        }
    }

    void deleteNonScopedSound(SoundRetained sound) {
        if (!this.nonViewScopedSounds.isEmpty()) {
            int index = this.nonViewScopedSounds.indexOf(sound);
            this.nonViewScopedSounds.remove(index);
        }
    }

    void deleteNonScopedSoundscape(SoundscapeRetained soundscape) {
        boolean error = this.nonViewScopedSoundscapes.remove(soundscape);
    }

    void deleteScopedSound(SoundRetained sound, View view) {
        ArrayList l = (ArrayList)this.viewScopedSounds.get(view);
        if (!l.isEmpty()) {
            int index = l.indexOf(sound);
            l.remove(index);
        }
        if (l.isEmpty()) {
            this.viewScopedSounds.remove(view);
        }
    }

    void deleteScopedSoundscape(SoundscapeRetained soundscape, View view) {
        ArrayList l = (ArrayList)this.viewScopedSoundscapes.get(view);
        if (!l.isEmpty()) {
            int index = l.indexOf(soundscape);
            l.remove(index);
        }
        if (l.isEmpty()) {
            this.viewScopedSoundscapes.remove(view);
        }
    }

    void changeNodeAttrib(J3dMessage m) {
        Object node = m.args[0];
        Object value = m.args[1];
        if (node instanceof SoundRetained) {
            int attribDirty = (Integer)value;
            if ((attribDirty & 0x20) > 0) {
                // empty if block
            }
            if ((attribDirty & 1) > 0) {
                this.loadSound((SoundRetained)node, true);
            }
            ((SoundRetained)node).updateMirrorObject(m.args);
        }
        if (node instanceof SoundscapeRetained) {
            ((SoundscapeRetained)node).updateTransformChange();
        }
    }

    void changeNodeState(J3dMessage m) {
        Object node = m.args[0];
        Object value = m.args[1];
        if (node instanceof SoundRetained) {
            int stateDirty = (Integer)value;
            if ((stateDirty & 1) > 0) {
                this.loadSound((SoundRetained)node, false);
            }
            if ((stateDirty & 0x20) > 0) {
                this.enableSound((SoundRetained)node);
            }
            ((SoundRetained)node).updateMirrorObject(m.args);
        }
    }

    boolean intersect(Bounds region) {
        if (region == null) {
            return false;
        }
        ViewPlatformRetained[] vpLists = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i = this.viewPlatforms.arraySize() - 1; i >= 0; --i) {
            vpLists[i].schedSphere.getWithLock(this.tempSphere);
            if (!this.tempSphere.intersect(region)) continue;
            return true;
        }
        return false;
    }

    void loadSound(SoundRetained sound, boolean forceLoad) {
        MediaContainer mediaContainer = sound.getSoundData();
        ViewPlatformRetained[] vpLists = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i = this.viewPlatforms.arraySize() - 1; i >= 0; --i) {
            View[] views = vpLists[i].getViewList();
            for (int j = views.length - 1; j >= 0; --j) {
                View v = views[j];
                v.soundScheduler.loadSound(sound, forceLoad);
            }
        }
    }

    void enableSound(SoundRetained sound) {
        ViewPlatformRetained[] vpLists = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i = this.viewPlatforms.arraySize() - 1; i >= 0; --i) {
            View[] views = vpLists[i].getViewList();
            for (int j = views.length - 1; j >= 0; --j) {
                View v = views[j];
                v.soundScheduler.enableSound(sound);
            }
        }
    }

    void muteSound(SoundRetained sound) {
        ViewPlatformRetained[] vpLists = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i = this.viewPlatforms.arraySize() - 1; i >= 0; --i) {
            View[] views = vpLists[i].getViewList();
            for (int j = views.length - 1; j >= 0; --j) {
                View v = views[j];
                v.soundScheduler.muteSound(sound);
            }
        }
    }

    void pauseSound(SoundRetained sound) {
        ViewPlatformRetained[] vpLists = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i = this.viewPlatforms.arraySize() - 1; i >= 0; --i) {
            View[] views = vpLists[i].getViewList();
            for (int j = views.length - 1; j >= 0; --j) {
                View v = views[j];
                v.soundScheduler.pauseSound(sound);
            }
        }
    }

    void processSwitchChanged(J3dMessage m) {
    }

    UnorderList getSoundList(View view) {
        ArrayList l = (ArrayList)this.viewScopedSounds.get(view);
        if (l == null) {
            return this.nonViewScopedSounds;
        }
        UnorderList newS = (UnorderList)this.nonViewScopedSounds.clone();
        int size = l.size();
        for (int i = 0; i < size; ++i) {
            newS.add(l.get(i));
        }
        return newS;
    }

    UnorderList getSoundscapeList(View view) {
        ArrayList l = (ArrayList)this.viewScopedSoundscapes.get(view);
        if (l == null) {
            return this.nonViewScopedSoundscapes;
        }
        UnorderList newS = (UnorderList)this.nonViewScopedSoundscapes.clone();
        int size = l.size();
        for (int i = 0; i < size; ++i) {
            newS.add(l.get(i));
        }
        return newS;
    }

    void updateTransformChange(UpdateTargets targets, long referenceTime) {
        UnorderList arrList = targets.targetList[3];
        if (arrList != null) {
            int size = arrList.size();
            Object[] nodesArr = arrList.toArray(false);
            for (int j = 0; j < size; ++j) {
                Object[] nodes = (Object[])nodesArr[j];
                for (int i = 0; i < nodes.length; ++i) {
                    if (nodes[i] instanceof ConeSoundRetained) {
                        this.xformChangeList.add(nodes[i]);
                        ConeSoundRetained cnSndNode = (ConeSoundRetained)nodes[i];
                        cnSndNode.updateTransformChange();
                        continue;
                    }
                    if (nodes[i] instanceof PointSoundRetained) {
                        this.xformChangeList.add(nodes[i]);
                        PointSoundRetained ptSndNode = (PointSoundRetained)nodes[i];
                        ptSndNode.updateTransformChange();
                        continue;
                    }
                    if (nodes[i] instanceof SoundRetained) {
                        this.xformChangeList.add(nodes[i]);
                        SoundRetained sndNode = (SoundRetained)nodes[i];
                        sndNode.updateTransformChange();
                        continue;
                    }
                    if (nodes[i] instanceof SoundscapeRetained) {
                        this.xformChangeList.add(nodes[i]);
                        SoundscapeRetained sndScapeNode = (SoundscapeRetained)nodes[i];
                        sndScapeNode.updateTransformChange();
                        continue;
                    }
                    if (!(nodes[i] instanceof AuralAttributesRetained)) continue;
                    this.xformChangeList.add(nodes[i]);
                }
            }
        }
    }

    void debugPrint(String message) {
    }

    boolean isSoundScopedToView(Object obj, View view) {
        ArrayList l;
        SoundRetained s = (SoundRetained)obj;
        return !s.isViewScoped || (l = (ArrayList)this.viewScopedSounds.get(view)).contains(s);
    }

    boolean isSoundscapeScopedToView(Object obj, View view) {
        ArrayList l;
        SoundscapeRetained s = (SoundscapeRetained)obj;
        return !s.isViewScoped || (l = (ArrayList)this.viewScopedSoundscapes.get(view)).contains(s);
    }

    void updateViewSpecificGroupChanged(J3dMessage m) {
        Object obj;
        int i;
        int size;
        int component = (Integer)m.args[0];
        Object[] objAry = (Object[])m.args[1];
        ArrayList soundList = null;
        ArrayList soundsScapeList = null;
        if ((component & 2) != 0 || (component & 1) != 0) {
            View view = (View)objAry[0];
            ArrayList leafList = (ArrayList)objAry[2];
            size = leafList.size();
            if (size > 0) {
                for (i = 0; i < size; ++i) {
                    obj = leafList.get(i);
                    if (obj instanceof SoundRetained) {
                        if (soundList == null && (soundList = (ArrayList)this.viewScopedSounds.get(view)) == null) {
                            soundList = new ArrayList();
                            this.viewScopedSounds.put(view, soundList);
                        }
                        soundList.add(obj);
                        continue;
                    }
                    if (!(obj instanceof SoundscapeRetained)) continue;
                    if (soundsScapeList == null && (soundsScapeList = (ArrayList)this.viewScopedSoundscapes.get(view)) == null) {
                        soundsScapeList = new ArrayList();
                        this.viewScopedSoundscapes.put(view, soundsScapeList);
                    }
                    soundsScapeList.add(obj);
                }
            }
        }
        if ((component & 4) != 0 || (component & 1) != 0) {
            ArrayList leafList;
            View view;
            if ((component & 4) != 0) {
                view = (View)objAry[0];
                leafList = (ArrayList)objAry[2];
            } else {
                view = (View)objAry[4];
                leafList = (ArrayList)objAry[6];
            }
            size = leafList.size();
            if (size > 0) {
                for (i = 0; i < size; ++i) {
                    obj = leafList.get(i);
                    if (obj instanceof SoundRetained) {
                        if (soundList == null) {
                            soundList = (ArrayList)this.viewScopedSounds.get(view);
                        }
                        soundList.remove(obj);
                    }
                    if (!(obj instanceof SoundscapeRetained)) continue;
                    if (soundsScapeList == null) {
                        soundsScapeList = (ArrayList)this.viewScopedSoundscapes.get(view);
                    }
                    soundsScapeList.remove(obj);
                }
                if (soundList != null && soundList.size() == 0) {
                    this.viewScopedSounds.remove(view);
                }
                if (soundsScapeList != null && soundsScapeList.size() == 0) {
                    this.viewScopedSoundscapes.remove(view);
                }
            }
        }
    }

    @Override
    void cleanup() {
    }
}

