/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.img;

import java.util.Set;
import net.imglib2.Dirty;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.img.CellLoader;
import net.imglib2.cache.img.SingleCellArrayImg;
import net.imglib2.img.basictypeaccess.AccessFlags;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.img.basictypeaccess.CharAccess;
import net.imglib2.img.basictypeaccess.DoubleAccess;
import net.imglib2.img.basictypeaccess.FloatAccess;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.ShortAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.util.Fraction;

public class LoadedCellCacheLoader<T extends NativeType<T>, A extends ArrayDataAccess<A>>
implements CacheLoader<Long, Cell<A>> {
    private final CellGrid grid;
    private final Fraction entitiesPerPixel;
    private final T type;
    private final A creator;
    private final ArrayDataAccessWrapper<A, ?> wrapper;
    private final CellLoader<T> loader;

    public LoadedCellCacheLoader(CellGrid grid, T type, A creator, ArrayDataAccessWrapper<A, ?> wrapper, CellLoader<T> loader) {
        this.grid = grid;
        this.entitiesPerPixel = type.getEntitiesPerPixel();
        this.type = type;
        this.creator = creator;
        this.wrapper = wrapper;
        this.loader = loader;
    }

    @Override
    public Cell<A> get(Long key) throws Exception {
        long index = key;
        long[] cellMin = new long[this.grid.numDimensions()];
        CellGrid.CellDimensionsAndSteps dimsAndSteps = this.grid.getCellDimensions(index, cellMin);
        long numEntities = this.entitiesPerPixel.mulCeil((long)dimsAndSteps.numPixels());
        ArrayDataAccess array = (ArrayDataAccess)this.creator.createArray((int)numEntities);
        SingleCellArrayImg img = new SingleCellArrayImg(dimsAndSteps.dimensions(), cellMin, this.wrapper.wrap(array), this.wrapper.wrapDirty(array), this.type);
        this.loader.load(img);
        return new Cell(dimsAndSteps, cellMin, (Object)array);
    }

    public static <T extends NativeType<T>, A extends ArrayDataAccess<A>> LoadedCellCacheLoader<T, A> get(CellGrid grid, CellLoader<T> loader, T type, Set<AccessFlags> flags) {
        return LoadedCellCacheLoader.get(grid, loader, type, type.getNativeTypeFactory().getPrimitiveType(), flags);
    }

    public static <T extends NativeType<T>, A extends ArrayDataAccess<A>> LoadedCellCacheLoader<T, A> get(CellGrid grid, CellLoader<T> loader, T type, PrimitiveType primitiveType, Set<AccessFlags> flags) {
        ArrayDataAccess creator = ArrayDataAccessFactory.get((PrimitiveType)primitiveType, flags);
        ArrayDataAccessWrapper<A, ?> wrapper = LoadedCellCacheLoader.getWrapper(primitiveType, flags);
        return new LoadedCellCacheLoader<T, ArrayDataAccess>(grid, type, creator, wrapper, loader);
    }

    static <A extends ArrayDataAccess<A>> ArrayDataAccessWrapper<A, ?> getWrapper(PrimitiveType primitiveType, Set<AccessFlags> flags) {
        boolean dirty = flags.contains(AccessFlags.DIRTY);
        switch (primitiveType) {
            case BYTE: {
                return dirty ? new ByteAccessWrapper() : new PassThrough();
            }
            case CHAR: {
                return dirty ? new CharAccessWrapper() : new PassThrough();
            }
            case DOUBLE: {
                return dirty ? new DoubleAccessWrapper() : new PassThrough();
            }
            case FLOAT: {
                return dirty ? new FloatAccessWrapper() : new PassThrough();
            }
            case INT: {
                return dirty ? new IntAccessWrapper() : new PassThrough();
            }
            case LONG: {
                return dirty ? new LongAccessWrapper() : new PassThrough();
            }
            case SHORT: {
                return dirty ? new ShortAccessWrapper() : new PassThrough();
            }
        }
        return null;
    }

    static class LongAccessWrapper<A extends ArrayDataAccess<A> & LongAccess>
    implements ArrayDataAccessWrapper<A, LongArray> {
        LongAccessWrapper() {
        }

        @Override
        public LongArray wrap(A access) {
            return new LongArray((long[])access.getCurrentStorageArray());
        }

        @Override
        public Dirty wrapDirty(A access) {
            return (Dirty)access;
        }
    }

    static class ShortAccessWrapper<A extends ArrayDataAccess<A> & ShortAccess>
    implements ArrayDataAccessWrapper<A, ShortArray> {
        ShortAccessWrapper() {
        }

        @Override
        public ShortArray wrap(A access) {
            return new ShortArray((short[])access.getCurrentStorageArray());
        }

        @Override
        public Dirty wrapDirty(A access) {
            return (Dirty)access;
        }
    }

    static class IntAccessWrapper<A extends ArrayDataAccess<A> & IntAccess>
    implements ArrayDataAccessWrapper<A, IntArray> {
        IntAccessWrapper() {
        }

        @Override
        public IntArray wrap(A access) {
            return new IntArray((int[])access.getCurrentStorageArray());
        }

        @Override
        public Dirty wrapDirty(A access) {
            return (Dirty)access;
        }
    }

    static class FloatAccessWrapper<A extends ArrayDataAccess<A> & FloatAccess>
    implements ArrayDataAccessWrapper<A, FloatArray> {
        FloatAccessWrapper() {
        }

        @Override
        public FloatArray wrap(A access) {
            return new FloatArray((float[])access.getCurrentStorageArray());
        }

        @Override
        public Dirty wrapDirty(A access) {
            return (Dirty)access;
        }
    }

    static class DoubleAccessWrapper<A extends ArrayDataAccess<A> & DoubleAccess>
    implements ArrayDataAccessWrapper<A, DoubleArray> {
        DoubleAccessWrapper() {
        }

        @Override
        public DoubleArray wrap(A access) {
            return new DoubleArray((double[])access.getCurrentStorageArray());
        }

        @Override
        public Dirty wrapDirty(A access) {
            return (Dirty)access;
        }
    }

    static class CharAccessWrapper<A extends ArrayDataAccess<A> & CharAccess>
    implements ArrayDataAccessWrapper<A, CharArray> {
        CharAccessWrapper() {
        }

        @Override
        public CharArray wrap(A access) {
            return new CharArray((char[])access.getCurrentStorageArray());
        }

        @Override
        public Dirty wrapDirty(A access) {
            return (Dirty)access;
        }
    }

    static class ByteAccessWrapper<A extends ArrayDataAccess<A> & ByteAccess>
    implements ArrayDataAccessWrapper<A, ByteArray> {
        ByteAccessWrapper() {
        }

        @Override
        public ByteArray wrap(A access) {
            return new ByteArray((byte[])access.getCurrentStorageArray());
        }

        @Override
        public Dirty wrapDirty(A access) {
            return (Dirty)access;
        }
    }

    static class PassThrough<A extends ArrayDataAccess<A>>
    implements ArrayDataAccessWrapper<A, A> {
        PassThrough() {
        }

        @Override
        public A wrap(A access) {
            return access;
        }

        @Override
        public Dirty wrapDirty(A access) {
            return new Dirty(){

                public boolean isDirty() {
                    return false;
                }

                public void setDirty() {
                }

                public void setDirty(boolean dirty) {
                }
            };
        }
    }

    public static interface ArrayDataAccessWrapper<A extends ArrayDataAccess<A>, W extends ArrayDataAccess<W>> {
        public W wrap(A var1);

        public Dirty wrapDirty(A var1);
    }
}

