/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Conv;
import edu.mines.jtk.dsp.FftFilter;
import edu.mines.jtk.util.ArrayMath;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FftFilterTest
extends TestCase {
    private Random _random = new Random();
    private static final float TOLERANCE = 1.1920929E-4f;

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(FftFilterTest.class);
        TestRunner.run((Test)suite);
    }

    public void test1Random() {
        int ntest = 1000;
        int nmin = 1;
        int nmax = 8;
        for (int itest = 0; itest < ntest; ++itest) {
            int nx;
            int nh = nmin + this._random.nextInt(1 + nmax - nmin);
            int ny = nx = nmin + this._random.nextInt(1 + nmax - nmin);
            int nz = nx;
            int kh = this._random.nextInt(nh);
            float[] h = ArrayMath.randfloat(nh);
            float[] x = ArrayMath.randfloat(nx);
            float[] y = ArrayMath.randfloat(ny);
            float[] z = ArrayMath.randfloat(nz);
            FftFilter ff = new FftFilter(kh, h);
            ff.apply(x, y);
            Conv.conv(nh, -kh, h, nx, 0, x, nz, 0, z);
            FftFilterTest.assertEquals(z, y);
        }
    }

    public void test2Random() {
        int ntest = 1000;
        int nmin = 1;
        int nmax = 8;
        for (int itest = 0; itest < ntest; ++itest) {
            int nh1 = nmin + this._random.nextInt(1 + nmax - nmin);
            int nh2 = nmin + this._random.nextInt(1 + nmax - nmin);
            int nx1 = nmin + this._random.nextInt(1 + nmax - nmin);
            int nx2 = nmin + this._random.nextInt(1 + nmax - nmin);
            int ny1 = nx1;
            int ny2 = nx2;
            int nz1 = nx1;
            int nz2 = nx2;
            int kh1 = this._random.nextInt(nh1);
            int kh2 = this._random.nextInt(nh2);
            float[][] h = ArrayMath.randfloat(nh1, nh2);
            float[][] x = ArrayMath.randfloat(nx1, nx2);
            float[][] y = ArrayMath.randfloat(ny1, ny2);
            float[][] z = ArrayMath.randfloat(nz1, nz2);
            FftFilter ff = new FftFilter(kh1, kh2, h);
            ff.apply(x, y);
            Conv.conv(nh1, nh2, -kh1, -kh2, h, nx1, nx2, 0, 0, x, nz1, nz2, 0, 0, z);
            FftFilterTest.assertEquals(z, y);
        }
    }

    public void test3Random() {
        int ntest = 100;
        int nmin = 1;
        int nmax = 8;
        for (int itest = 0; itest < ntest; ++itest) {
            int nh1 = nmin + this._random.nextInt(1 + nmax - nmin);
            int nh2 = nmin + this._random.nextInt(1 + nmax - nmin);
            int nh3 = nmin + this._random.nextInt(1 + nmax - nmin);
            int nx1 = nmin + this._random.nextInt(1 + nmax - nmin);
            int nx2 = nmin + this._random.nextInt(1 + nmax - nmin);
            int nx3 = nmin + this._random.nextInt(1 + nmax - nmin);
            int ny1 = nx1;
            int ny2 = nx2;
            int ny3 = nx3;
            int nz1 = nx1;
            int nz2 = nx2;
            int nz3 = nx3;
            int kh1 = this._random.nextInt(nh1);
            int kh2 = this._random.nextInt(nh2);
            int kh3 = this._random.nextInt(nh3);
            float[][][] h = ArrayMath.randfloat(nh1, nh2, nh3);
            float[][][] x = ArrayMath.randfloat(nx1, nx2, nx3);
            float[][][] y = ArrayMath.randfloat(ny1, ny2, ny3);
            float[][][] z = ArrayMath.randfloat(nz1, nz2, nz3);
            FftFilter ff = new FftFilter(kh1, kh2, kh3, h);
            ff.apply(x, y);
            Conv.conv(nh1, nh2, nh3, -kh1, -kh2, -kh3, h, nx1, nx2, nx3, 0, 0, 0, x, nz1, nz2, nz3, 0, 0, 0, z);
            FftFilterTest.assertEquals(z, y);
        }
    }

    private static void assertEquals(float[] a, float[] b) {
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            FftFilterTest.assertEquals((float)a[i], (float)b[i], (float)1.1920929E-4f);
        }
    }

    private static void assertEquals(float[][] a, float[][] b) {
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            FftFilterTest.assertEquals(a[i], b[i]);
        }
    }

    private static void assertEquals(float[][][] a, float[][][] b) {
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            FftFilterTest.assertEquals(a[i], b[i]);
        }
    }
}

