/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.ogl.Gl;
import edu.mines.jtk.sgl.Axis;
import edu.mines.jtk.sgl.AxisAlignedPanel;
import edu.mines.jtk.sgl.BoundingSphere;
import edu.mines.jtk.sgl.BoxConstraint;
import edu.mines.jtk.sgl.DrawContext;
import edu.mines.jtk.sgl.Group;
import edu.mines.jtk.sgl.Node;
import edu.mines.jtk.sgl.PickContext;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.Segment;
import edu.mines.jtk.util.Check;

public class AxisAlignedFrame
extends Group {
    private Axis _axis;
    private BoxConstraint _constraint;
    private Point3[] _p = new Point3[4];

    public AxisAlignedFrame(Axis axis, Point3 pa, Point3 pb) {
        this._axis = axis;
        this.setCorners(pa, pb);
        this.addChild(new Wire());
    }

    public Axis getAxis() {
        return this._axis;
    }

    public Point3 getCornerMin() {
        return new Point3(this._p[0]);
    }

    public Point3 getCornerMax() {
        return new Point3(this._p[3]);
    }

    public Point3 getCorner(int index) {
        return new Point3(this._p[index]);
    }

    public void setCorners(Point3 pa, Point3 pb) {
        Point3 pmin = new Point3(Math.min(pa.x, pb.x), Math.min(pa.y, pb.y), Math.min(pa.z, pb.z));
        Point3 pmax = new Point3(Math.max(pa.x, pb.x), Math.max(pa.y, pb.y), Math.max(pa.z, pb.z));
        if (this._constraint != null) {
            this._constraint.constrainBox(pmin, pmax);
        }
        if (this._axis == Axis.X) {
            double x = 0.5 * (pmin.x + pmax.x);
            this._p[0] = new Point3(x, pmin.y, pmin.z);
            this._p[1] = new Point3(x, pmax.y, pmin.z);
            this._p[2] = new Point3(x, pmin.y, pmax.z);
            this._p[3] = new Point3(x, pmax.y, pmax.z);
        } else if (this._axis == Axis.Y) {
            double y = 0.5 * (pmin.y + pmax.y);
            this._p[0] = new Point3(pmin.x, y, pmin.z);
            this._p[1] = new Point3(pmin.x, y, pmax.z);
            this._p[2] = new Point3(pmax.x, y, pmin.z);
            this._p[3] = new Point3(pmax.x, y, pmax.z);
        } else {
            double z = 0.5 * (pmin.z + pmax.z);
            this._p[0] = new Point3(pmin.x, pmin.y, z);
            this._p[1] = new Point3(pmax.x, pmin.y, z);
            this._p[2] = new Point3(pmin.x, pmax.y, z);
            this._p[3] = new Point3(pmax.x, pmax.y, z);
        }
        this.dirtyBoundingSphere();
        this.dirtyDraw();
    }

    public BoxConstraint getBoxConstraint() {
        return this._constraint;
    }

    public void setBoxConstraint(BoxConstraint constraint) {
        this._constraint = constraint;
        this.setCorners(this._p[0], this._p[3]);
    }

    @Override
    public void addChild(Node node) {
        super.addChild(node);
        if (node instanceof AxisAlignedPanel) {
            AxisAlignedPanel panel = (AxisAlignedPanel)node;
            Check.state(panel.getFrame() == null, "frame of panel equals null");
            panel.setFrame(this);
        }
    }

    @Override
    public void removeChild(Node node) {
        super.removeChild(node);
        if (node instanceof AxisAlignedPanel) {
            AxisAlignedPanel panel = (AxisAlignedPanel)node;
            Check.state(panel.getFrame() == this, "frame of panel equals this");
            panel.setFrame(null);
        }
    }

    BoundingSphere computeBoundingSphereOfFrame(boolean finite) {
        double dx = this._p[3].x - this._p[0].x;
        double dy = this._p[3].y - this._p[0].y;
        double dz = this._p[3].z - this._p[0].z;
        double r = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double x = 0.5 * (this._p[0].x + this._p[3].x);
        double y = 0.5 * (this._p[0].y + this._p[3].y);
        double z = 0.5 * (this._p[0].z + this._p[3].z);
        Point3 c = new Point3(x, y, z);
        return new BoundingSphere(c, r);
    }

    void pickOnFrame(PickContext pc) {
        Segment ps = pc.getPickSegment();
        Point3 pa = ps.intersectWithTriangle(this._p[0].x, this._p[0].y, this._p[0].z, this._p[1].x, this._p[1].y, this._p[1].z, this._p[3].x, this._p[3].y, this._p[3].z);
        Point3 pb = ps.intersectWithTriangle(this._p[0].x, this._p[0].y, this._p[0].z, this._p[3].x, this._p[3].y, this._p[3].z, this._p[2].x, this._p[2].y, this._p[2].z);
        pc.addResult(pa);
        pc.addResult(pb);
    }

    private class Wire
    extends Node {
        private Wire() {
        }

        @Override
        protected BoundingSphere computeBoundingSphere(boolean finite) {
            return AxisAlignedFrame.this.computeBoundingSphereOfFrame(finite);
        }

        @Override
        protected void draw(DrawContext dc) {
            Gl.glColor3f(1.0f, 1.0f, 1.0f);
            Gl.glLineWidth(1.5f);
            Gl.glPolygonMode(1032, 6913);
            Gl.glBegin(7);
            Gl.glVertex3d(((AxisAlignedFrame)AxisAlignedFrame.this)._p[0].x, ((AxisAlignedFrame)AxisAlignedFrame.this)._p[0].y, ((AxisAlignedFrame)AxisAlignedFrame.this)._p[0].z);
            Gl.glVertex3d(((AxisAlignedFrame)AxisAlignedFrame.this)._p[1].x, ((AxisAlignedFrame)AxisAlignedFrame.this)._p[1].y, ((AxisAlignedFrame)AxisAlignedFrame.this)._p[1].z);
            Gl.glVertex3d(((AxisAlignedFrame)AxisAlignedFrame.this)._p[3].x, ((AxisAlignedFrame)AxisAlignedFrame.this)._p[3].y, ((AxisAlignedFrame)AxisAlignedFrame.this)._p[3].z);
            Gl.glVertex3d(((AxisAlignedFrame)AxisAlignedFrame.this)._p[2].x, ((AxisAlignedFrame)AxisAlignedFrame.this)._p[2].y, ((AxisAlignedFrame)AxisAlignedFrame.this)._p[2].z);
            Gl.glEnd();
        }

        @Override
        public void pick(PickContext pc) {
            AxisAlignedFrame.this.pickOnFrame(pc);
        }
    }
}

