/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.Matrix44;
import edu.mines.jtk.sgl.PickResult;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.View;
import edu.mines.jtk.sgl.ViewCanvas;
import edu.mines.jtk.sgl.World;
import java.awt.event.MouseEvent;

public class DragContext {
    private MouseEvent _event;
    private ViewCanvas _canvas;
    private View _view;
    private World _world;
    private Point3 _pointLocal;
    private Point3 _pointWorld;
    private Point3 _pointPixel;
    private Matrix44 _localToWorld;
    private Matrix44 _localToPixel;
    private Matrix44 _worldToPixel;
    private Matrix44 _pixelToLocal;
    private Matrix44 _pixelToWorld;

    public DragContext(PickResult pr) {
        this._event = pr.getMouseEvent();
        this._canvas = pr.getViewCanvas();
        this._view = pr.getView();
        this._world = pr.getWorld();
        this._pointLocal = pr.getPointLocal();
        this._pointWorld = pr.getPointWorld();
        this._pointPixel = pr.getPointPixel();
        this._localToWorld = pr.getLocalToWorld();
        this._localToPixel = pr.getLocalToPixel();
        this._worldToPixel = pr.getWorldToPixel();
        this._pixelToLocal = this._localToPixel.inverse();
        this._pixelToWorld = this._worldToPixel.inverse();
    }

    public void update(MouseEvent event) {
        this._event = event;
        this._pointPixel.x = event.getX();
        this._pointPixel.y = event.getY();
        this._pointLocal = this._pixelToLocal.times(this._pointPixel);
        this._pointWorld = this._pixelToWorld.times(this._pointPixel);
    }

    public ViewCanvas getViewCanvas() {
        return this._canvas;
    }

    public View getView() {
        return this._view;
    }

    public World getWorld() {
        return this._world;
    }

    public MouseEvent getMouseEvent() {
        return this._event;
    }

    public Point3 getPointLocal() {
        return new Point3(this._pointLocal);
    }

    public Point3 getPointWorld() {
        return new Point3(this._pointWorld);
    }

    public Point3 getPointPixel() {
        return new Point3(this._pointPixel);
    }

    public double getPixelZ() {
        return this._pointPixel.z;
    }

    public Matrix44 getLocalToWorld() {
        return new Matrix44(this._localToWorld);
    }

    public Matrix44 getLocalToPixel() {
        return new Matrix44(this._localToPixel);
    }

    public Matrix44 getWorldToPixel() {
        return new Matrix44(this._worldToPixel);
    }
}

