/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.appearance;

import bdv.ui.appearance.Appearance;
import bdv.util.Prefs;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.UIManager;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

public class AppearanceIO {
    static final Tag APPEARANCE_TAG = new Tag("!appearance");
    static final Tag LOOK_AND_FEEL_TAG = new Tag("!lookandfeel");

    public static Appearance load(String filename) throws IOException {
        FileReader input = new FileReader(filename);
        LoaderOptions loaderOptions = new LoaderOptions();
        Yaml yaml = new Yaml((BaseConstructor)new AppearanceConstructor(loaderOptions));
        Iterable objs = yaml.loadAll((Reader)input);
        ArrayList list = new ArrayList();
        objs.forEach(list::add);
        if (list.size() != 1) {
            throw new IllegalArgumentException("unexpected input in yaml file");
        }
        return (Appearance)list.get(0);
    }

    public static void save(Appearance appearance, String filename) throws IOException {
        new File(filename).getParentFile().mkdirs();
        FileWriter output = new FileWriter(filename);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml((Representer)new AppearanceRepresenter(dumperOptions), dumperOptions);
        ArrayList<Appearance> objects = new ArrayList<Appearance>();
        objects.add(appearance);
        yaml.dumpAll(objects.iterator(), (Writer)output);
        output.close();
    }

    static class AppearanceConstructor
    extends Constructor {
        public AppearanceConstructor(LoaderOptions loaderOptions) {
            super(loaderOptions);
            this.yamlConstructors.put(APPEARANCE_TAG, new ConstructAppearance());
            this.yamlConstructors.put(LOOK_AND_FEEL_TAG, new ConstructLookAndFeelInfo());
        }

        private static int hexColor(Object rgba) {
            return ((Number)rgba).intValue();
        }

        private static Prefs.OverlayPosition overlayPosition(Object str) {
            return Prefs.OverlayPosition.valueOf((String)str);
        }

        private class ConstructLookAndFeelInfo
        extends AbstractConstruct {
            private ConstructLookAndFeelInfo() {
            }

            public Object construct(Node node) {
                String name = AppearanceConstructor.this.constructScalar((ScalarNode)node);
                return Appearance.lookAndFeelInfoForName(name);
            }
        }

        private class ConstructAppearance
        extends AbstractConstruct {
            private ConstructAppearance() {
            }

            public Object construct(Node node) {
                try {
                    Map mapping = AppearanceConstructor.this.constructMapping((MappingNode)node);
                    Appearance a = new Appearance();
                    a.setShowScaleBar((Boolean)mapping.get("showScaleBar"));
                    a.setShowScaleBarInMovie((Boolean)mapping.get("showScaleBarInMovie"));
                    a.setShowMultibox((Boolean)mapping.get("showMultibox"));
                    a.setShowTextOverlay((Boolean)mapping.get("showTextOverlay"));
                    a.setSourceNameOverlayPosition(AppearanceConstructor.overlayPosition(mapping.get("sourceNameOverlayPosition")));
                    a.setScaleBarColor(AppearanceConstructor.hexColor(mapping.get("scaleBarColor")));
                    a.setScaleBarBgColor(AppearanceConstructor.hexColor(mapping.get("scaleBarBgColor")));
                    a.setLookAndFeel((UIManager.LookAndFeelInfo)mapping.get("lookAndFeel"));
                    return a;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
    }

    static class AppearanceRepresenter
    extends Representer {
        public AppearanceRepresenter(DumperOptions dumperOptions) {
            super(dumperOptions);
            this.representers.put(Appearance.class, new RepresentAppearance());
            this.representers.put(Hex.class, new RepresentHex());
            this.representers.put(UIManager.LookAndFeelInfo.class, new RepresentLookAndFeelInfo());
        }

        private static Hex hex(int i) {
            return new Hex(i);
        }

        private class RepresentLookAndFeelInfo
        implements Represent {
            private RepresentLookAndFeelInfo() {
            }

            public Node representData(Object data) {
                UIManager.LookAndFeelInfo info = (UIManager.LookAndFeelInfo)data;
                String str = info == null ? null : info.getName();
                return AppearanceRepresenter.this.representScalar(LOOK_AND_FEEL_TAG, str);
            }
        }

        private class RepresentHex
        implements Represent {
            private RepresentHex() {
            }

            public Node representData(Object data) {
                return AppearanceRepresenter.this.representScalar(Tag.INT, String.format("0x%08x", ((Hex)data).value));
            }
        }

        private static class Hex {
            int value;

            Hex(int value) {
                this.value = value;
            }
        }

        private class RepresentAppearance
        implements Represent {
            private RepresentAppearance() {
            }

            public Node representData(Object data) {
                Appearance a = (Appearance)data;
                LinkedHashMap<String, Object> mapping = new LinkedHashMap<String, Object>();
                mapping.put("showScaleBar", a.showScaleBar());
                mapping.put("showScaleBarInMovie", a.showScaleBarInMovie());
                mapping.put("showMultibox", a.showMultibox());
                mapping.put("showTextOverlay", a.showTextOverlay());
                mapping.put("sourceNameOverlayPosition", a.sourceNameOverlayPosition().toString());
                mapping.put("scaleBarColor", AppearanceRepresenter.hex(a.scaleBarColor()));
                mapping.put("scaleBarBgColor", AppearanceRepresenter.hex(a.scaleBarBgColor()));
                mapping.put("lookAndFeel", a.lookAndFeel());
                return AppearanceRepresenter.this.representMapping(APPEARANCE_TAG, mapping, AppearanceRepresenter.this.getDefaultFlowStyle());
            }
        }
    }
}

