/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

public class BoundedValue {
    private int rangeMin;
    private int rangeMax;
    private int currentValue;
    private UpdateListener updateListener;

    public BoundedValue(int rangeMin, int rangeMax, int currentValue) {
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
        this.currentValue = currentValue;
        this.updateListener = null;
    }

    public int getRangeMin() {
        return this.rangeMin;
    }

    public int getRangeMax() {
        return this.rangeMax;
    }

    public int getCurrentValue() {
        return this.currentValue;
    }

    public void setRange(int min, int max) {
        assert (min <= max);
        this.rangeMin = min;
        this.rangeMax = max;
        this.currentValue = Math.min(Math.max(this.currentValue, min), max);
        if (this.updateListener != null) {
            this.updateListener.update();
        }
    }

    public void setCurrentValue(int value) {
        this.currentValue = value;
        if (this.currentValue < this.rangeMin) {
            this.currentValue = this.rangeMin;
        } else if (this.currentValue > this.rangeMax) {
            this.currentValue = this.rangeMax;
        }
        if (this.updateListener != null) {
            this.updateListener.update();
        }
    }

    public void setUpdateListener(UpdateListener l) {
        this.updateListener = l;
    }

    public static interface UpdateListener {
        public void update();
    }
}

