/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import bdv.viewer.render.VolatileProjector;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.util.StopWatch;

public class SimpleVolatileProjector<A, B>
implements VolatileProjector {
    private final Converter<? super A, B> converter;
    private final RandomAccessibleInterval<B> target;
    private final RandomAccessible<A> source;
    private long lastFrameRenderNanoTime;
    private volatile boolean canceled = false;
    private boolean valid = false;

    public SimpleVolatileProjector(RandomAccessible<A> source, Converter<? super A, B> converter, RandomAccessibleInterval<B> target) {
        this.converter = converter;
        this.target = target;
        this.source = source;
        this.lastFrameRenderNanoTime = -1L;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public long getLastFrameRenderNanoTime() {
        return this.lastFrameRenderNanoTime;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean map(boolean clearUntouchedTargetPixels) {
        if (this.canceled) {
            return false;
        }
        StopWatch stopWatch = StopWatch.createAndStart();
        int n = Math.max(2, this.source.numDimensions());
        long[] smin = new long[n];
        long[] smax = new long[n];
        smin[0] = this.target.min(0);
        smax[0] = this.target.max(0);
        smin[1] = this.target.min(1);
        smax[1] = this.target.max(1);
        FinalInterval sourceInterval = new FinalInterval(smin, smax);
        RandomAccess targetRandomAccess = this.target.randomAccess(this.target);
        RandomAccess<A> sourceRandomAccess = this.source.randomAccess(sourceInterval);
        int width = (int)this.target.dimension(0);
        int height = (int)this.target.dimension(1);
        for (int y = 0; y < height; ++y) {
            if (this.canceled) {
                return false;
            }
            sourceRandomAccess.setPosition(smin);
            targetRandomAccess.setPosition(smin);
            for (int x = 0; x < width; ++x) {
                this.converter.convert(sourceRandomAccess.get(), targetRandomAccess.get());
                sourceRandomAccess.fwd(0);
                targetRandomAccess.fwd(0);
            }
            smin[1] = smin[1] + 1L;
        }
        this.lastFrameRenderNanoTime = stopWatch.nanoTime();
        boolean success = !this.canceled;
        this.valid |= success;
        return success;
    }
}

