/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.awt.Shape;
import java.util.Arrays;
import net.imagej.display.ImageDisplay;
import net.imagej.display.OverlayView;
import net.imagej.overlay.Overlay;
import net.imagej.overlay.PolygonOverlay;
import net.imagej.ui.swing.overlay.AbstractJHotDrawAdapter;
import net.imagej.ui.swing.overlay.IJBezierTool;
import net.imagej.ui.swing.overlay.JHotDrawAdapter;
import net.imagej.ui.swing.overlay.JHotDrawTool;
import net.imagej.ui.swing.overlay.PolygonFigure;
import net.imagej.ui.swing.tools.SwingPolygonTool;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.roi.PolygonRegionOfInterest;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.BezierPath;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.tool.Tool;

@Plugin(type=JHotDrawAdapter.class, priority=98.0)
public class PolygonJHotDrawAdapter
extends AbstractJHotDrawAdapter<PolygonOverlay, BezierFigure> {
    @Parameter(required=false)
    private LogService log;

    private static PolygonOverlay downcastOverlay(Overlay overlay) {
        assert (overlay instanceof PolygonOverlay);
        return (PolygonOverlay)overlay;
    }

    @Override
    public boolean supports(Tool tool) {
        return tool instanceof SwingPolygonTool;
    }

    @Override
    public boolean supports(Overlay overlay, Figure figure) {
        if (!(overlay instanceof PolygonOverlay)) {
            return false;
        }
        return figure == null || figure instanceof BezierFigure;
    }

    @Override
    public Overlay createNewOverlay() {
        PolygonOverlay o = new PolygonOverlay(this.getContext());
        return o;
    }

    @Override
    public Figure createDefaultFigure() {
        PolygonFigure figure = new PolygonFigure();
        this.initDefaultSettings(figure);
        figure.set(AttributeKeys.WINDING_RULE, AttributeKeys.WindingRule.EVEN_ODD);
        return figure;
    }

    @Override
    public void updateOverlay(BezierFigure figure, OverlayView view) {
        super.updateOverlay(figure, view);
        PolygonOverlay poverlay = PolygonJHotDrawAdapter.downcastOverlay(view.getData());
        PolygonRegionOfInterest roi = (PolygonRegionOfInterest)poverlay.getRegionOfInterest();
        int nodeCount = figure.getNodeCount();
        while (roi.getVertexCount() > nodeCount) {
            roi.removeVertex(nodeCount);
            if (this.log == null) continue;
            this.log.debug((Object)"Removed node from overlay.");
        }
        for (int i = 0; i < nodeCount; ++i) {
            BezierPath.Node node = figure.getNode(i);
            double[] position = new double[]{node.x[0], node.y[0]};
            if (roi.getVertexCount() == i) {
                roi.addVertex(i, (RealLocalizable)new RealPoint(position));
                if (this.log == null) continue;
                this.log.debug((Object)"Added node to overlay");
                continue;
            }
            if ((position[0] != roi.getVertex(i).getDoublePosition(0) || position[1] != roi.getVertex(i).getDoublePosition(1)) && this.log != null) {
                this.log.debug((Object)String.format("Vertex # %d moved to %f,%f", i + 1, position[0], position[1]));
            }
            roi.setVertexPosition(i, position);
        }
        poverlay.update();
    }

    @Override
    public void updateFigure(OverlayView view, BezierFigure figure) {
        super.updateFigure(view, figure);
        PolygonOverlay polygonOverlay = PolygonJHotDrawAdapter.downcastOverlay(view.getData());
        PolygonRegionOfInterest roi = (PolygonRegionOfInterest)polygonOverlay.getRegionOfInterest();
        int vertexCount = roi.getVertexCount();
        while (figure.getNodeCount() > vertexCount) {
            figure.removeNode(vertexCount);
        }
        for (int i = 0; i < vertexCount; ++i) {
            RealLocalizable vertex = roi.getVertex(i);
            double x = vertex.getDoublePosition(0);
            double y = vertex.getDoublePosition(1);
            if (figure.getNodeCount() == i) {
                figure.addNode(new BezierPath.Node(x, y));
                continue;
            }
            BezierPath.Node node = figure.getNode(i);
            node.mask = 0;
            Arrays.fill(node.x, x);
            Arrays.fill(node.y, y);
        }
    }

    @Override
    public JHotDrawTool getCreationTool(ImageDisplay display) {
        return new IJBezierTool(display, this);
    }

    @Override
    public Shape toShape(BezierFigure figure) {
        return figure.getBezierPath().toGeneralPath();
    }
}

