/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.registration;

import mpicbg.spim.data.SpimDataInstantiationException;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.registration.ViewTransform;
import mpicbg.spim.data.registration.ViewTransformAffine;
import mpicbg.spim.data.registration.ViewTransformGeneric;
import net.imglib2.realtransform.AffineTransform3D;
import org.jdom2.Content;
import org.jdom2.Element;

public class XmlIoViewTransform {
    public String getTag() {
        return "ViewTransform";
    }

    public ViewTransform fromXml(Element viewTransform) throws SpimDataInstantiationException {
        String type = viewTransform.getAttributeValue("type");
        if ("affine".equals(type)) {
            return this.fromXmlAffine(viewTransform);
        }
        if ("generic".equals(type)) {
            return this.fromXmlGeneric(viewTransform);
        }
        throw new IllegalArgumentException("unknown <ViewTransform> type: " + type);
    }

    public Element toXml(ViewTransform viewTransform) {
        if (ViewTransformAffine.class.isInstance(viewTransform)) {
            return this.toXmlAffine((ViewTransformAffine)viewTransform);
        }
        if (ViewTransformGeneric.class.isInstance(viewTransform)) {
            return this.toXmlGeneric((ViewTransformGeneric)viewTransform);
        }
        throw new RuntimeException("unknown ViewTransform type: " + viewTransform.getClass().getName());
    }

    protected ViewTransformAffine fromXmlAffine(Element viewTransform) {
        String name = XmlHelpers.getText(viewTransform, "Name", null);
        AffineTransform3D affine = XmlHelpers.getAffineTransform3D(viewTransform, "affine");
        return new ViewTransformAffine(name, affine);
    }

    protected Element toXmlAffine(ViewTransformAffine viewTransform) {
        Element elem = new Element("ViewTransform");
        elem.setAttribute("type", "affine");
        if (viewTransform.hasName()) {
            elem.addContent((Content)XmlHelpers.textElement("Name", viewTransform.getName()));
        }
        elem.addContent((Content)XmlHelpers.affineTransform3DElement("affine", viewTransform.asAffine3D()));
        return elem;
    }

    protected ViewTransformGeneric fromXmlGeneric(Element viewTransform) throws SpimDataInstantiationException {
        String attributeClassName = viewTransform.getAttributeValue("class");
        try {
            ViewTransformGeneric t = (ViewTransformGeneric)Class.forName(attributeClassName).newInstance();
            t.init(viewTransform);
            return t;
        }
        catch (Exception e) {
            throw new SpimDataInstantiationException("could not instantiate " + ViewTransformGeneric.class.getSimpleName() + " instance " + attributeClassName, e);
        }
    }

    protected Element toXmlGeneric(ViewTransformGeneric viewTransform) {
        return viewTransform.toXml();
    }
}

