/*
 * Decompiled with CFR 0.152.
 */
import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Tag;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.text.TextWindow;
import java.io.File;

public class Exif_Reader
implements PlugIn {
    public void run(String arg) {
        String directory = null;
        String name = null;
        FileInfo fi = null;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            fi = imp.getOriginalFileInfo();
        }
        if (imp != null && fi != null) {
            directory = fi.directory;
            name = fi.fileName;
            if ((name == null || name.equals("")) && imp.getStack().isVirtual()) {
                name = imp.getStack().getSliceLabel(imp.getCurrentSlice());
            }
        } else {
            OpenDialog od = new OpenDialog("Open JPEG...", arg);
            directory = od.getDirectory();
            name = od.getFileName();
        }
        if (name == null) {
            return;
        }
        String path = directory + name;
        String metadata = Exif_Reader.getMetadata(path);
        if (!metadata.startsWith("Error:")) {
            String headings = "Tag\tValue";
            new TextWindow("EXIF Metadata for " + name, headings, metadata, 450, 500);
        } else {
            IJ.showMessage((String)"Exif Reader", (String)metadata);
        }
    }

    public static String getMetadata(String path) {
        Object metadata;
        File file = new File(path);
        StringBuilder sb = new StringBuilder();
        try {
            metadata = ImageMetadataReader.readMetadata((File)file);
            for (Directory dir : metadata.getDirectories()) {
                for (Tag tag : dir.getTags()) {
                    sb.append(tag);
                    sb.append("\n");
                }
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = "" + e;
            }
            return "Error: " + msg + "\n" + path;
        }
        metadata = sb.toString();
        if (metadata != null) {
            metadata = ((String)metadata).replace(" - ", ":\t");
        }
        return metadata;
    }
}

