/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.renjin.eval.ConditionException;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.Promise;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;

public class Conditions {
    private Conditions() {
    }

    @Internal(value=".addCondHands")
    public static void addConditionHandlers(@Current Context context, StringVector classes, ListVector handlers, Environment parentEnv, SEXP target, LogicalVector calling) {
        if (classes.length() != handlers.length()) {
            throw new EvalException("bad handler data", new Object[0]);
        }
        int n = handlers.length();
        for (int i = n - 1; i >= 0; --i) {
            context.setConditionHandler(classes.getElementAsString(i), Promise.repromise(parentEnv, handlers.getElementAsSEXP(i)));
        }
    }

    @Internal(value=".addRestart")
    public static void addRestart(SEXP restart) {
    }

    @Internal(value=".signalCondition")
    public static void signalCondition(@Current Context context, SEXP condition, String message, SEXP call2) {
        StringVector conditionClasses = condition.getS3Class();
        while (!context.isTopLevel()) {
            for (String conditionClass : conditionClasses) {
                SEXP handler = context.getConditionHandler(conditionClass);
                if (handler == null) continue;
                throw new ConditionException(condition, context, handler);
            }
            context = context.getParent();
        }
    }

    @Internal(value=".dfltStop")
    public static void defaultStop(@Current Context context, String message, FunctionCall call2) {
        EvalException e = new EvalException(message, new Object[0]);
        e.initContext(context);
        throw e;
    }

    @Internal(value=".dfltStop")
    public static void defaultStop(@Current Context context, String message, Null nz) {
        EvalException e = new EvalException(message, new Object[0]);
        e.initContext(context);
        throw e;
    }

    @Internal
    public static void stop(@Current Context context, boolean call2, String message) {
        throw new EvalException(message, new Object[0]);
    }

    @Internal
    public static String geterrmessage(@Current Context context) {
        ErrorMessage errorMessage = context.getSession().getSingleton(ErrorMessage.class);
        return errorMessage.getValue();
    }

    @Internal
    public static void seterrmessage(@Current Context context, String message) {
        ErrorMessage errorMessage = context.getSession().getSingleton(ErrorMessage.class);
        errorMessage.setValue(message);
    }

    public static class ErrorMessage {
        private String value;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

