/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.packaging;

import java.io.IOException;
import org.renjin.eval.Context;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.Invisible;
import org.renjin.primitives.packaging.Dataset;
import org.renjin.primitives.packaging.DatasetObjectPromise;
import org.renjin.primitives.packaging.Namespace;
import org.renjin.primitives.packaging.NamespaceRegistry;
import org.renjin.sexp.Environment;
import org.renjin.sexp.HashFrame;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;

public class Packages {
    @Internal
    public static void library(@Current Context context, @Current NamespaceRegistry namespaceRegistry, String packageName) throws IOException {
        Namespace namespace = namespaceRegistry.getNamespace(context, packageName);
        for (String dependencyName : namespace.getPackage().getPackageDependencies()) {
            context.getSession().getStdOut().println("Loading required package: " + dependencyName);
            Packages.library(context, namespaceRegistry, dependencyName);
        }
        Environment packageEnv = context.getGlobalEnvironment().insertAbove(new HashFrame());
        packageEnv.setAttribute(Symbols.NAME, (SEXP)StringVector.valueOf("package:" + packageName));
        namespace.copyExportsTo(context, packageEnv);
        for (Dataset dataset : namespace.getPackage().getDatasets()) {
            for (String objectName : dataset.getObjectNames()) {
                packageEnv.setVariable(objectName, (SEXP)new DatasetObjectPromise(dataset, objectName));
            }
        }
        context.setInvisibleFlag();
    }

    @Internal
    @Invisible
    public static boolean require(@Current Context context, @Current NamespaceRegistry registry, String packageName) {
        try {
            Packages.library(context, registry, packageName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

