/*
 * Decompiled with CFR 0.152.
 */
package de.biomedical_imaging.ij.steger;

import de.biomedical_imaging.ij.steger.Convol;
import de.biomedical_imaging.ij.steger.Junctions;
import de.biomedical_imaging.ij.steger.Lines;
import de.biomedical_imaging.ij.steger.LinesUtil;
import de.biomedical_imaging.ij.steger.Link;
import de.biomedical_imaging.ij.steger.Width;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableInt;

public class Position {
    private static final double PIXEL_BOUNDARY = 0.6;

    public void solve_linear(double a, double b, MutableDouble t, MutableInt num) {
        if (a == 0.0) {
            num.setValue(0);
            return;
        }
        num.setValue(1);
        t.setValue(-b / a);
    }

    public void compute_eigenvals(double dfdrr, double dfdrc, double dfdcc, double[] eigval, double[][] eigvec) {
        double e2;
        double e1;
        double s;
        double c;
        if (dfdrc != 0.0) {
            double theta = 0.5 * (dfdcc - dfdrr) / dfdrc;
            double t = 1.0 / (Math.abs(theta) + Math.sqrt(theta * theta + 1.0));
            if (theta < 0.0) {
                t = -t;
            }
            c = 1.0 / Math.sqrt(t * t + 1.0);
            s = t * c;
            e1 = dfdrr - t * dfdrc;
            e2 = dfdcc + t * dfdrc;
        } else {
            c = 1.0;
            s = 0.0;
            e1 = dfdrr;
            e2 = dfdcc;
        }
        double n1 = c;
        double n2 = -s;
        if (Math.abs(e1) > Math.abs(e2)) {
            eigval[0] = e1;
            eigval[1] = e2;
            eigvec[0][0] = n1;
            eigvec[0][1] = n2;
            eigvec[1][0] = -n2;
            eigvec[1][1] = n1;
        } else if (Math.abs(e1) < Math.abs(e2)) {
            eigval[0] = e2;
            eigval[1] = e1;
            eigvec[0][0] = -n2;
            eigvec[0][1] = n1;
            eigvec[1][0] = n1;
            eigvec[1][1] = n2;
        } else if (e1 < e2) {
            eigval[0] = e1;
            eigval[1] = e2;
            eigvec[0][0] = n1;
            eigvec[0][1] = n2;
            eigvec[1][0] = -n2;
            eigvec[1][1] = n1;
        } else {
            eigval[0] = e2;
            eigval[1] = e1;
            eigvec[0][0] = -n2;
            eigvec[0][1] = n1;
            eigvec[1][0] = n1;
            eigvec[1][1] = n2;
        }
    }

    private void print_ascii2(byte[] image, int width, int height) {
        int i = 0;
        int j = 0;
        int k = 0;
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                k = LinesUtil.LINCOOR(i, j, width);
                System.out.print("" + image[k] + " ");
            }
            System.out.print("\n");
        }
    }

    private void print_ascii2(float[] image, int width, int height) {
        int i = 0;
        int j = 0;
        int k = 0;
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                k = LinesUtil.LINCOOR(i, j, width);
                System.out.print("" + image[k] + " \t");
            }
            System.out.print("\n");
        }
    }

    private void compute_line_points(float[][] ku, byte[] ismax, float[] ev, float[] nx, float[] ny, float[] px, float[] py, int width, int height, double low, double high, int mode) {
        double[] k = new double[5];
        double[] eigval = new double[2];
        double[][] eigvec = new double[2][2];
        MutableDouble t = new MutableDouble();
        MutableInt num = new MutableInt();
        for (int r = 0; r < height; ++r) {
            for (int c = 0; c < width; ++c) {
                int l = LinesUtil.LINCOOR(r, c, width);
                k[0] = ku[0][l];
                k[1] = ku[1][l];
                k[2] = ku[2][l];
                k[3] = ku[3][l];
                k[4] = ku[4][l];
                ev[l] = 0.0f;
                nx[l] = 0.0f;
                ny[l] = 0.0f;
                this.compute_eigenvals(k[2], k[3], k[4], eigval, eigvec);
                double val = mode == 1 ? -eigval[0] : eigval[0];
                if (!(val > 0.0)) continue;
                ev[l] = (float)val;
                double n1 = eigvec[0][0];
                double n2 = eigvec[0][1];
                double a = k[2] * n1 * n1 + 2.0 * k[3] * n1 * n2 + k[4] * n2 * n2;
                double b = k[0] * n1 + k[1] * n2;
                this.solve_linear(a, b, t, num);
                if (num.intValue() == 0) continue;
                double p1 = t.doubleValue() * n1;
                double p2 = t.doubleValue() * n2;
                if (!(Math.abs(p1) <= 0.6) || !(Math.abs(p2) <= 0.6)) continue;
                if (val >= low) {
                    ismax[l] = val >= high ? 2 : 1;
                }
                nx[l] = (float)n1;
                ny[l] = (float)n2;
                px[l] = (float)((double)r + p1);
                py[l] = (float)((double)c + p2);
            }
        }
    }

    public void detect_lines(float[] image, int width, int height, Lines contours, MutableInt num_result, double sigma, double low, double high, int mode, boolean compute_width, boolean correct_pos, boolean extend_lines, Junctions junctions) {
        float[][] k = new float[5][width * height];
        Convol convol = new Convol();
        convol.convolve_gauss(image, k[0], width, height, sigma, 1);
        convol.convolve_gauss(image, k[1], width, height, sigma, 2);
        convol.convolve_gauss(image, k[2], width, height, sigma, 3);
        convol.convolve_gauss(image, k[3], width, height, sigma, 4);
        convol.convolve_gauss(image, k[4], width, height, sigma, 5);
        byte[] ismax = new byte[width * height];
        float[] ev = new float[width * height];
        float[] n1 = new float[width * height];
        float[] n2 = new float[width * height];
        float[] p1 = new float[width * height];
        float[] p2 = new float[width * height];
        for (int j = 0; j < ismax.length; ++j) {
            ev[j] = 0.0f;
            ismax[j] = 0;
        }
        this.compute_line_points(k, ismax, ev, n1, n2, p1, p2, width, height, low, high, mode);
        Link l = new Link();
        l.compute_contours(ismax, ev, n1, n2, p1, p2, k[0], k[1], contours, num_result, sigma, extend_lines, mode, low, high, width, height, junctions);
        Width w = new Width();
        if (compute_width) {
            w.compute_line_width(k[0], k[1], width, height, sigma, mode, correct_pos, contours, num_result);
        }
    }
}

