/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.convert;

import java.util.function.Function;
import org.scijava.convert.AbstractConverter;

public abstract class ConciseConverter<I, O>
extends AbstractConverter<I, O> {
    private final Class<I> inType;
    private final Class<O> outType;
    private final Function<I, O> conversionFunction;

    public ConciseConverter(Class<I> inType, Class<O> outType, Function<I, O> conversionFunction) {
        this.inType = inType;
        this.outType = outType;
        this.conversionFunction = conversionFunction;
    }

    public Class<I> getInputType() {
        return this.inType;
    }

    public Class<O> getOutputType() {
        return this.outType;
    }

    public <T> T convert(Object src, Class<T> dest) {
        O result;
        if (!this.canConvert(src, dest)) {
            throw new IllegalArgumentException("Cannot convert source object of type " + src.getClass().getName() + " to destination type " + dest.getName());
        }
        Object typedSrc = src;
        O typedResult = result = this.convert(typedSrc);
        return (T)typedResult;
    }

    protected O convert(I src) {
        return this.conversionFunction.apply(src);
    }
}

