/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.display;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.imagej.display.OverlayInfo;
import net.imagej.overlay.Overlay;

public class OverlayInfoList {
    private final LinkedList<OverlayInfo> list = new LinkedList();

    public int getOverlayInfoCount() {
        return this.list.size();
    }

    public OverlayInfo getOverlayInfo(int i) {
        return this.list.get(i);
    }

    public boolean addOverlayInfo(int i, OverlayInfo info) {
        if (this.findIndex(info) >= 0) {
            return false;
        }
        this.list.add(i, info);
        return true;
    }

    public boolean addOverlayInfo(OverlayInfo info) {
        int last = this.list.size();
        return this.addOverlayInfo(last, info);
    }

    public boolean addOverlay(int i, Overlay overlay) {
        if (this.findIndex(overlay) >= 0) {
            return false;
        }
        OverlayInfo info = new OverlayInfo(overlay);
        return this.addOverlayInfo(i, info);
    }

    public boolean addOverlay(Overlay overlay) {
        int last = this.list.size();
        return this.addOverlay(last, overlay);
    }

    public boolean replaceOverlayInfo(int i, OverlayInfo info) {
        if (this.deleteOverlayInfo(i)) {
            return this.addOverlayInfo(i, info);
        }
        return false;
    }

    public boolean replaceOverlay(int i, Overlay overlay) {
        OverlayInfo info = new OverlayInfo(overlay);
        return this.replaceOverlayInfo(i, info);
    }

    public boolean deleteOverlayInfo(int i) {
        OverlayInfo info = this.list.remove(i);
        return info != null;
    }

    public boolean deleteOverlayInfo(OverlayInfo info) {
        int index = this.findIndex(info);
        if (index < 0) {
            return false;
        }
        return this.deleteOverlayInfo(index);
    }

    public boolean deleteOverlay(Overlay overlay) {
        int index = this.findIndex(overlay);
        if (index < 0) {
            return false;
        }
        return this.deleteOverlayInfo(index);
    }

    public void deleteAll() {
        int num = this.list.size();
        for (int i = 0; i < num; ++i) {
            this.deleteOverlayInfo(0);
        }
    }

    public int findIndex(OverlayInfo info) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (info != this.list.get(i)) continue;
            return i;
        }
        return -1;
    }

    public int findIndex(Overlay overlay) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (overlay != this.list.get(i).getOverlay()) continue;
            return i;
        }
        return -1;
    }

    public void sort() {
        Collections.sort(this.list, new Comparator<OverlayInfo>(){

            @Override
            public int compare(OverlayInfo arg0, OverlayInfo arg1) {
                return arg0.toString().compareTo(arg1.toString());
            }
        });
    }

    public int[] selectedIndices() {
        int selCount = 0;
        for (int i = 0; i < this.getOverlayInfoCount(); ++i) {
            if (!this.getOverlayInfo(i).isSelected()) continue;
            ++selCount;
        }
        int[] selectedIndices = new int[selCount];
        int index = 0;
        for (int i = 0; i < this.getOverlayInfoCount(); ++i) {
            if (!this.getOverlayInfo(i).isSelected()) continue;
            selectedIndices[index++] = i;
        }
        return selectedIndices;
    }

    public void deselectAll() {
        for (int i = 0; i < this.getOverlayInfoCount(); ++i) {
            this.getOverlayInfo(i).setSelected(false);
        }
    }

    public List<Overlay> selectedOverlays() {
        ArrayList<Overlay> overlays = new ArrayList<Overlay>();
        for (int i = 0; i < this.getOverlayInfoCount(); ++i) {
            OverlayInfo info = this.getOverlayInfo(i);
            if (!info.isSelected()) continue;
            overlays.add(info.getOverlay());
        }
        return overlays;
    }
}

